/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.apache.activemq.artemis.cli.commands.messages.perf.PaddingDecimalFormat;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerLoadGenerator;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerTargetRateLoadGenerator;
import org.apache.activemq.artemis.cli.commands.messages.perf.RateSampler;
import org.apache.activemq.artemis.cli.commands.messages.perf.RecordingMessageListener;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public final class LiveStatistics {
    private final ProducerLoadGenerator[] producers;
    private final Histogram[] waitLatencies;
    private final Histogram intervalWaitLatencies;
    private final Histogram[] sentLatencies;
    private final Histogram intervalSentLatencies;
    private final RecordingMessageListener[] listeners;
    private final Histogram[] endToEndLatencies;
    private final Histogram intervalEndToEndLatencies;
    private final RateSampler sentMsg;
    private final RateSampler blockedMsg;
    private final RateSampler completedMsg;
    private final RateSampler receivedMsg;
    private final Histogram accumulatedWaitLatencies;
    private final Histogram accumulatedSentLatencies;
    private final Histogram accumulatedEndToEndLatencies;
    private final DecimalFormat jsonLatencyFormat;
    private final PaddingDecimalFormat latencyFormat;
    private final PaddingDecimalFormat rateFormat;
    private final PaddingDecimalFormat countFormat;
    private long sampleTime;
    private final FileWriter jsonWriter;
    private long jsonSamples;
    private final HistogramLogWriter latenciesLogWriter;

    public LiveStatistics(String jsonOutput, String hdrOutput, ProducerLoadGenerator[] producers, RecordingMessageListener[] listeners) throws IOException {
        if (producers != null && producers.length > 0) {
            this.producers = producers;
            this.sentLatencies = new Histogram[producers.length];
            this.intervalSentLatencies = new Histogram(2);
            this.accumulatedSentLatencies = new Histogram(2);
            if (producers[0] instanceof ProducerTargetRateLoadGenerator) {
                this.waitLatencies = new Histogram[producers.length];
                this.intervalWaitLatencies = new Histogram(2);
                this.accumulatedWaitLatencies = new Histogram(2);
            } else {
                this.waitLatencies = null;
                this.intervalWaitLatencies = null;
                this.accumulatedWaitLatencies = null;
            }
            this.sentMsg = RateSampler.of(() -> {
                long sum = 0L;
                for (ProducerLoadGenerator producer : producers) {
                    sum += producer.getProducer().getMessageSent();
                }
                return sum;
            });
            this.blockedMsg = RateSampler.of(() -> {
                long sum = 0L;
                for (ProducerLoadGenerator producer : producers) {
                    sum += producer.getProducer().getNotAvailable();
                }
                return sum;
            });
            this.completedMsg = RateSampler.of(() -> {
                long sum = 0L;
                for (ProducerLoadGenerator producer : producers) {
                    sum += producer.getProducer().getMessageCompleted();
                }
                return sum;
            });
        } else {
            this.producers = null;
            this.sentLatencies = null;
            this.intervalSentLatencies = null;
            this.accumulatedSentLatencies = null;
            this.waitLatencies = null;
            this.intervalWaitLatencies = null;
            this.accumulatedWaitLatencies = null;
            this.sentMsg = null;
            this.blockedMsg = null;
            this.completedMsg = null;
        }
        if (listeners != null) {
            this.listeners = listeners;
            this.endToEndLatencies = new Histogram[listeners.length];
            this.intervalEndToEndLatencies = new Histogram(2);
            this.accumulatedEndToEndLatencies = new Histogram(2);
            this.receivedMsg = RateSampler.of(() -> {
                long sum = 0L;
                for (RecordingMessageListener listener : listeners) {
                    sum += listener.getReceivedMessages();
                }
                return sum;
            });
        } else {
            this.listeners = null;
            this.endToEndLatencies = null;
            this.intervalEndToEndLatencies = null;
            this.accumulatedEndToEndLatencies = null;
            this.receivedMsg = null;
        }
        this.sampleTime = System.currentTimeMillis();
        this.jsonLatencyFormat = new DecimalFormat("0.00");
        this.latencyFormat = new PaddingDecimalFormat("0.00", 9);
        this.rateFormat = new PaddingDecimalFormat("0", 8);
        this.countFormat = new PaddingDecimalFormat("0", 12);
        this.jsonSamples = 0L;
        if (jsonOutput != null) {
            this.jsonWriter = new FileWriter(jsonOutput);
            this.jsonWriter.write("[\n");
        } else {
            this.jsonWriter = null;
        }
        if (hdrOutput != null) {
            this.latenciesLogWriter = new HistogramLogWriter(hdrOutput);
            this.latenciesLogWriter.outputLogFormatVersion();
            this.latenciesLogWriter.outputLegend();
        } else {
            this.latenciesLogWriter = null;
        }
    }

    private boolean anyFatalError() {
        if (this.producers != null) {
            for (ProducerLoadGenerator producer : this.producers) {
                if (producer.getFatalException() == null) continue;
                return true;
            }
        }
        if (this.listeners != null) {
            for (RecordingMessageListener listener : this.listeners) {
                if (!listener.anyFatalException()) continue;
                return true;
            }
        }
        return false;
    }

    public void sampleMetrics(boolean warmup) {
        int i;
        int size;
        long lastSampleTime = this.sampleTime;
        this.sampleTime = System.currentTimeMillis();
        if (this.receivedMsg != null) {
            this.receivedMsg.run();
        }
        if (this.completedMsg != null) {
            this.completedMsg.run();
        }
        if (this.blockedMsg != null) {
            this.blockedMsg.run();
        }
        if (this.sentMsg != null) {
            this.sentMsg.run();
        }
        if (this.endToEndLatencies != null) {
            size = this.listeners.length;
            for (i = 0; i < size; ++i) {
                this.endToEndLatencies[i] = this.listeners[i].getReceiveLatencyRecorder().getIntervalHistogram(this.endToEndLatencies[i]);
            }
        }
        if (this.sentLatencies != null) {
            size = this.producers.length;
            for (i = 0; i < size; ++i) {
                this.sentLatencies[i] = this.producers[i].getSendCompletedLatencies().getIntervalHistogram(this.sentLatencies[i]);
            }
        }
        if (this.waitLatencies != null) {
            size = this.producers.length;
            for (i = 0; i < size; ++i) {
                this.waitLatencies[i] = this.producers[i].getWaitLatencies().getIntervalHistogram(this.waitLatencies[i]);
            }
        }
        LiveStatistics.aggregateLatencies(warmup, lastSampleTime, this.sampleTime, this.intervalEndToEndLatencies, this.endToEndLatencies, this.accumulatedEndToEndLatencies);
        LiveStatistics.aggregateLatencies(warmup, lastSampleTime, this.sampleTime, this.intervalSentLatencies, this.sentLatencies, this.accumulatedSentLatencies);
        LiveStatistics.aggregateLatencies(warmup, lastSampleTime, this.sampleTime, this.intervalWaitLatencies, this.waitLatencies, this.accumulatedWaitLatencies);
    }

    private static void aggregateLatencies(boolean warmup, long lastSampleTime, long sampleTime, Histogram intervalSentLatencies, Histogram[] sentLatencies, Histogram accumulatedSentLatencies) {
        if (intervalSentLatencies != null) {
            intervalSentLatencies.reset();
            intervalSentLatencies.setStartTimeStamp(lastSampleTime);
            intervalSentLatencies.setEndTimeStamp(sampleTime);
            for (Histogram histogram : sentLatencies) {
                intervalSentLatencies.add((AbstractHistogram)histogram);
            }
            if (!warmup) {
                accumulatedSentLatencies.add((AbstractHistogram)intervalSentLatencies);
            }
        }
    }

    public void outAtInterval(boolean warmup, StringBuilder out, ReportInterval interval, boolean includeLatencies) throws IOException {
        out.append("\n--- warmup ").append(warmup ? "true " : "false");
        LiveStatistics.appendRateOf(out, "\n--- sent:     ", this.sentMsg, this.rateFormat, interval, "msg");
        LiveStatistics.appendRateOf(out, "\n--- blocked:  ", this.blockedMsg, this.rateFormat, interval, "msg");
        LiveStatistics.appendRateOf(out, "\n--- completed:", this.completedMsg, this.rateFormat, interval, "msg");
        LiveStatistics.appendRateOf(out, "\n--- received: ", this.receivedMsg, this.rateFormat, interval, "msg");
        if (includeLatencies) {
            LiveStatistics.outPercentiles(out, "\n--- send delay time:", this.intervalWaitLatencies, this.latencyFormat);
            LiveStatistics.outPercentiles(out, "\n--- send ack time:  ", this.intervalSentLatencies, this.latencyFormat);
            LiveStatistics.outPercentiles(out, "\n--- transfer time:  ", this.intervalEndToEndLatencies, this.latencyFormat);
        }
        this.appendJsonIntervalSampleOnFile(warmup, interval);
        this.appendTaggedHdrHistograms(warmup);
    }

    private void appendJsonIntervalSampleOnFile(boolean warmup, ReportInterval interval) throws IOException {
        if (this.jsonWriter == null) {
            return;
        }
        JsonObjectBuilder jsonBuilder = JsonLoader.createObjectBuilder();
        jsonBuilder.add("sampleType", "interval");
        jsonBuilder.add("warmup", warmup);
        jsonBuilder.add("time", this.sampleTime);
        LiveStatistics.addRate(jsonBuilder, "sent", this.sentMsg, interval);
        LiveStatistics.addRate(jsonBuilder, "delayed", this.blockedMsg, interval);
        LiveStatistics.addRate(jsonBuilder, "completed", this.completedMsg, interval);
        LiveStatistics.addRate(jsonBuilder, "received", this.receivedMsg, interval);
        this.addPercentiles(jsonBuilder, "delaySendTime", this.intervalWaitLatencies);
        this.addPercentiles(jsonBuilder, "sendTime", this.intervalSentLatencies);
        this.addPercentiles(jsonBuilder, "transferTime", this.intervalEndToEndLatencies);
        String jsonSample = jsonBuilder.build().toString();
        if (this.jsonSamples > 0L) {
            this.jsonWriter.write(",\n");
        }
        ++this.jsonSamples;
        this.jsonWriter.write(jsonSample);
        this.jsonWriter.flush();
    }

    private void appendJsonSummarySampleOnFile(boolean failedBenchmark) throws IOException {
        if (this.jsonWriter == null) {
            return;
        }
        JsonObjectBuilder jsonBuilder = JsonLoader.createObjectBuilder();
        jsonBuilder.add("sampleType", "summary");
        jsonBuilder.add("time", this.sampleTime);
        jsonBuilder.add("result", failedBenchmark ? "fail" : "success");
        if (this.sentMsg != null) {
            jsonBuilder.add("totalSent", this.sentMsg.getLastSample());
        }
        if (this.blockedMsg != null) {
            jsonBuilder.add("totalBlocked", this.blockedMsg.getLastSample());
        }
        if (this.completedMsg != null) {
            jsonBuilder.add("totalCompleted", this.completedMsg.getLastSample());
        }
        if (this.receivedMsg != null) {
            jsonBuilder.add("totalReceived", this.receivedMsg.getLastSample());
        }
        this.addPercentiles(jsonBuilder, "totalDelaySendTime", this.accumulatedWaitLatencies);
        this.addPercentiles(jsonBuilder, "totalSendTime", this.accumulatedSentLatencies);
        this.addPercentiles(jsonBuilder, "totalTransferTime", this.accumulatedEndToEndLatencies);
        String jsonSample = jsonBuilder.build().toString();
        if (this.jsonSamples > 0L) {
            this.jsonWriter.write(",\n");
        }
        ++this.jsonSamples;
        this.jsonWriter.write(jsonSample);
        this.jsonWriter.flush();
    }

    private void appendTaggedHdrHistograms(boolean warmup) {
        if (this.latenciesLogWriter == null) {
            return;
        }
        if (this.intervalWaitLatencies != null) {
            this.intervalWaitLatencies.setTag(warmup ? "warmup delay send" : "delay send");
            this.latenciesLogWriter.outputIntervalHistogram((EncodableHistogram)this.intervalWaitLatencies);
        }
        if (this.intervalSentLatencies != null) {
            this.intervalSentLatencies.setTag(warmup ? "warmup send" : "send");
            this.latenciesLogWriter.outputIntervalHistogram((EncodableHistogram)this.intervalSentLatencies);
        }
        if (this.intervalEndToEndLatencies != null) {
            this.intervalEndToEndLatencies.setTag(warmup ? "warmup transfer" : "transfer");
            this.latenciesLogWriter.outputIntervalHistogram((EncodableHistogram)this.intervalEndToEndLatencies);
        }
    }

    private static JsonObjectBuilder addRate(JsonObjectBuilder obj, String metric, RateSampler rate, ReportInterval interval) {
        if (rate == null) {
            return obj;
        }
        return obj.add(metric, rate.reportRate(interval.nanoseconds));
    }

    private JsonObjectBuilder addPercentiles(JsonObjectBuilder obj, String metric, Histogram distribution) {
        if (distribution == null) {
            return obj;
        }
        return obj.add(metric, JsonLoader.createObjectBuilder().add("mean", this.jsonLatencyFormat.format(distribution.getMean())).add("50", distribution.getValueAtPercentile(50.0)).add("90", distribution.getValueAtPercentile(90.0)).add("99", distribution.getValueAtPercentile(99.0)).add("99.9", distribution.getValueAtPercentile(99.9)).add("99.99", distribution.getValueAtPercentile(99.99)).add("max", distribution.getMaxValue()).add("count", distribution.getTotalCount()));
    }

    public void outSummary(StringBuilder out) throws IOException {
        out.append("\n--- SUMMARY");
        boolean failedBenchmark = this.anyFatalError();
        out.append("\n--- result:         ").append(failedBenchmark ? "        fail" : "     success");
        if (this.sentMsg != null) {
            out.append("\n--- total sent:     ").append(this.countFormat.format(this.sentMsg.getLastSample()));
        }
        if (this.blockedMsg != null) {
            out.append("\n--- total blocked:  ").append(this.countFormat.format(this.blockedMsg.getLastSample()));
        }
        if (this.completedMsg != null) {
            out.append("\n--- total completed:").append(this.countFormat.format(this.completedMsg.getLastSample()));
        }
        if (this.receivedMsg != null) {
            out.append("\n--- total received: ").append(this.countFormat.format(this.receivedMsg.getLastSample()));
        }
        LiveStatistics.outPercentiles(out, "\n--- aggregated delay send time:", this.accumulatedWaitLatencies, this.latencyFormat);
        LiveStatistics.outPercentiles(out, "\n--- aggregated send time:      ", this.accumulatedSentLatencies, this.latencyFormat);
        LiveStatistics.outPercentiles(out, "\n--- aggregated transfer time:  ", this.accumulatedEndToEndLatencies, this.latencyFormat);
        this.appendJsonSummarySampleOnFile(failedBenchmark);
    }

    public void close() throws IOException {
        if (this.jsonWriter != null) {
            this.jsonWriter.write("\n]");
            this.jsonWriter.close();
        }
        if (this.latenciesLogWriter != null) {
            this.latenciesLogWriter.close();
        }
    }

    private static void outPercentiles(StringBuilder out, String metric, Histogram histogram, DecimalFormat latencyFormat) {
        if (histogram == null) {
            return;
        }
        out.append(' ').append(metric);
        out.append(' ').append("mean: ").append(latencyFormat.format(histogram.getMean())).append(" us");
        out.append(" - ").append("50.00%: ").append(latencyFormat.format(histogram.getValueAtPercentile(50.0))).append(" us");
        out.append(" - ").append("90.00%: ").append(latencyFormat.format(histogram.getValueAtPercentile(90.0))).append(" us");
        out.append(" - ").append("99.00%: ").append(latencyFormat.format(histogram.getValueAtPercentile(99.0))).append(" us");
        out.append(" - ").append("99.90%: ").append(latencyFormat.format(histogram.getValueAtPercentile(99.9))).append(" us");
        out.append(" - ").append("99.99%: ").append(latencyFormat.format(histogram.getValueAtPercentile(99.99))).append(" us");
        out.append(" - ").append("max:    ").append(latencyFormat.format(histogram.getMaxValue())).append(" us");
    }

    private static StringBuilder appendRateOf(StringBuilder out, String metric, RateSampler sampler, DecimalFormat rateFormat, ReportInterval outInterval, String unit) {
        if (sampler == null) {
            return out;
        }
        return out.append(' ').append(metric).append(' ').append(rateFormat.format(sampler.reportRate(outInterval.nanoseconds))).append(' ').append(unit).append('/').append(outInterval.name());
    }

    public static enum ReportInterval {
        ns(1L),
        us(TimeUnit.MICROSECONDS.toNanos(1L)),
        ms(TimeUnit.MILLISECONDS.toNanos(1L)),
        sec(TimeUnit.SECONDS.toNanos(1L));

        public final long nanoseconds;

        private ReportInterval(long value) {
            this.nanoseconds = value;
        }
    }
}

