/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.console.command.store.BackupStreamManager;
import org.apache.activemq.console.command.store.protobuf.MessagePB;
import org.apache.activemq.console.command.store.protobuf.QueueEntryPB;
import org.apache.activemq.console.command.store.protobuf.QueuePB;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.protobuf.AsciiBuffer;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.protobuf.UTF8Buffer;
import org.apache.activemq.store.MessageRecoveryContext;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.kahadb.disk.util.DataByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreBackup {
    private static final Logger logger = LoggerFactory.getLogger(StoreBackup.class);
    static final int OPENWIRE_VERSION = 11;
    static final boolean TIGHT_ENCODING = false;
    URI config;
    String filename;
    File file;
    String queue;
    Integer offset;
    Integer count = Integer.MAX_VALUE;
    String indexes;
    Collection<Integer> indexesList;
    String startMsgId;
    String endMsgId;
    private final ObjectMapper mapper = new ObjectMapper();
    private final AsciiBuffer ds_kind = new AsciiBuffer("ds");
    private final AsciiBuffer ptp_kind = new AsciiBuffer("ptp");
    private final AsciiBuffer codec_id = new AsciiBuffer("openwire");
    private final OpenWireFormat wireformat = new OpenWireFormat();

    public StoreBackup() throws URISyntaxException {
        this.config = new URI("xbean:activemq.xml");
        this.wireformat.setCacheEnabled(false);
        this.wireformat.setTightEncodingEnabled(false);
        this.wireformat.setVersion(11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        if (this.config == null) {
            throw new IllegalArgumentException("required --config option missing");
        }
        if (this.filename == null) {
            throw new IllegalArgumentException("required --filename option missing");
        }
        if (this.offset != null && this.count == null) {
            throw new IllegalArgumentException("optional --offset and --count must be specified together");
        }
        if ((this.startMsgId != null || this.endMsgId != null) && this.queue == null) {
            throw new IllegalArgumentException("optional --queue must be specified when using startMsgId or endMsgId");
        }
        if (this.indexes != null && !this.indexes.isBlank()) {
            this.indexesList = Stream.of(this.indexes.split(",")).map(index -> Integer.parseInt(index.trim())).peek(num -> {
                if (num < 0) {
                    throw new IllegalArgumentException("Index value cannot be negative: " + num);
                }
            }).collect(Collectors.toList());
        }
        this.setFile(new File(this.filename));
        logger.info("Loading config file:{} ", (Object)this.config);
        BrokerFactory.setStartDefault(false);
        BrokerService broker = BrokerFactory.createBroker(this.config);
        BrokerFactory.resetStartDefault();
        PersistenceAdapter store = broker.getPersistenceAdapter();
        logger.info("Starting: " + String.valueOf(store));
        store.start();
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.file));){
            this.export(store, fos);
        }
        finally {
            store.stop();
        }
    }

    void export(PersistenceAdapter store, BufferedOutputStream fos) throws Exception {
        final long[] messageKeyCounter = new long[]{0L};
        final long[] containerKeyCounter = new long[]{0L};
        final BackupStreamManager manager = new BackupStreamManager(fos, 1);
        final int[] preparedTxs = new int[]{0};
        store.createTransactionStore().recover(new TransactionRecoveryListener(){

            @Override
            public void recover(XATransactionId xid, Message[] addedMessages, MessageAck[] aks) {
                preparedTxs[0] = preparedTxs[0] + 1;
            }
        });
        if (preparedTxs[0] > 0) {
            throw new IllegalStateException("Cannot export a store with prepared XA transactions.  Please commit or rollback those transactions before attempting to backup.");
        }
        for (ActiveMQDestination odest : store.getDestinations()) {
            ActiveMQDestination dest;
            if (this.queue != null && !this.queue.equals(odest.getPhysicalName())) continue;
            containerKeyCounter[0] = containerKeyCounter[0] + 1L;
            if (odest instanceof ActiveMQQueue) {
                dest = (ActiveMQQueue)odest;
                MessageStore queue = store.createQueueMessageStore((ActiveMQQueue)dest);
                QueuePB destRecord = new QueuePB();
                destRecord.setKey(containerKeyCounter[0]);
                destRecord.setBindingKind(this.ptp_kind);
                final long[] seqKeyCounter = new long[]{0L};
                HashMap<String, String> jsonMap = new HashMap<String, String>();
                jsonMap.put("@class", "queue_destination");
                jsonMap.put("name", ((ActiveMQQueue)dest).getQueueName());
                String json = this.mapper.writeValueAsString(jsonMap);
                logger.info("Queue info:{}", (Object)json);
                destRecord.setBindingData(new UTF8Buffer(json));
                manager.store_queue(destRecord);
                MessageRecoveryContext.Builder builder = new MessageRecoveryContext.Builder().maxMessageCountReturned(this.count).messageRecoveryListener(new MessageRecoveryListener(){

                    @Override
                    public boolean hasSpace() {
                        return true;
                    }

                    @Override
                    public boolean recoverMessageReference(MessageId ref) throws Exception {
                        return true;
                    }

                    @Override
                    public boolean isDuplicate(MessageId ref) {
                        return false;
                    }

                    @Override
                    public boolean recoverMessage(Message message) throws IOException {
                        messageKeyCounter[0] = messageKeyCounter[0] + 1L;
                        seqKeyCounter[0] = seqKeyCounter[0] + 1L;
                        MessagePB messageRecord = StoreBackup.this.createMessagePB(message, messageKeyCounter[0]);
                        manager.store_message(messageRecord);
                        QueueEntryPB entryRecord = StoreBackup.this.createQueueEntryPB(message, containerKeyCounter[0], seqKeyCounter[0], messageKeyCounter[0]);
                        manager.store_queue_entry(entryRecord);
                        return true;
                    }
                });
                if (this.startMsgId != null || this.endMsgId != null) {
                    logger.info("Backing up from startMsgId:{} to endMsgId:{} ", (Object)this.startMsgId, (Object)this.endMsgId);
                    queue.recoverMessages(builder.endMessageId(this.endMsgId).startMessageId(this.startMsgId).build());
                    continue;
                }
                if (this.indexesList != null) {
                    logger.info("Backing up using indexes count:{}", (Object)this.indexesList.size());
                    for (int idx : this.indexesList) {
                        queue.recoverMessages(builder.maxMessageCountReturned(1).offset(idx).build());
                    }
                    continue;
                }
                if (this.offset != null) {
                    logger.info("Backing up from offset:{} count:{} ", (Object)this.offset, (Object)this.count);
                    queue.recoverMessages(builder.offset(this.offset.intValue()).build());
                    continue;
                }
                queue.recover(builder.build());
                continue;
            }
            if (!(odest instanceof ActiveMQTopic)) continue;
            dest = (ActiveMQTopic)odest;
            TopicMessageStore topic = store.createTopicMessageStore((ActiveMQTopic)dest);
            for (SubscriptionInfo sub : topic.getAllSubscriptions()) {
                QueuePB destRecord = new QueuePB();
                destRecord.setKey(containerKeyCounter[0]);
                destRecord.setBindingKind(this.ds_kind);
                HashMap<String, Object> jsonMap = new HashMap<String, Object>();
                jsonMap.put("@class", "dsub_destination");
                jsonMap.put("name", sub.getClientId() + ":" + sub.getSubscriptionName());
                HashMap<String, String> jsonTopic = new HashMap<String, String>();
                jsonTopic.put("name", ((ActiveMQTopic)dest).getTopicName());
                jsonMap.put("topics", new Object[]{jsonTopic});
                if (sub.getSelector() != null) {
                    jsonMap.put("selector", sub.getSelector());
                }
                jsonMap.put("noLocal", sub.isNoLocal());
                String json = this.mapper.writeValueAsString(jsonMap);
                logger.info("Topic info:{}", (Object)json);
                destRecord.setBindingData(new UTF8Buffer(json));
                manager.store_queue(destRecord);
                final long[] seqKeyCounter = new long[]{0L};
                topic.recoverSubscription(sub.getClientId(), sub.getSubscriptionName(), new MessageRecoveryListener(){

                    @Override
                    public boolean hasSpace() {
                        return true;
                    }

                    @Override
                    public boolean recoverMessageReference(MessageId ref) throws Exception {
                        return true;
                    }

                    @Override
                    public boolean isDuplicate(MessageId ref) {
                        return false;
                    }

                    @Override
                    public boolean recoverMessage(Message message) throws IOException {
                        messageKeyCounter[0] = messageKeyCounter[0] + 1L;
                        seqKeyCounter[0] = seqKeyCounter[0] + 1L;
                        MessagePB messageRecord = StoreBackup.this.createMessagePB(message, messageKeyCounter[0]);
                        manager.store_message(messageRecord);
                        QueueEntryPB entryRecord = StoreBackup.this.createQueueEntryPB(message, containerKeyCounter[0], seqKeyCounter[0], messageKeyCounter[0]);
                        manager.store_queue_entry(entryRecord);
                        return true;
                    }
                });
            }
        }
        manager.finish();
    }

    private QueueEntryPB createQueueEntryPB(Message message, long queueKey, long queueSeq, long messageKey) {
        QueueEntryPB entryRecord = new QueueEntryPB();
        entryRecord.setQueueKey(queueKey);
        entryRecord.setQueueSeq(queueSeq);
        entryRecord.setMessageKey(messageKey);
        entryRecord.setSize(message.getSize());
        if (message.getExpiration() != 0L) {
            entryRecord.setExpiration(message.getExpiration());
        }
        if (message.getRedeliveryCounter() != 0) {
            entryRecord.setRedeliveries(message.getRedeliveryCounter());
        }
        return entryRecord;
    }

    private MessagePB createMessagePB(Message message, long messageKey) throws IOException {
        DataByteArrayOutputStream mos = new DataByteArrayOutputStream();
        mos.writeBoolean(false);
        mos.writeInt(11);
        this.wireformat.marshal(message, mos);
        MessagePB messageRecord = new MessagePB();
        messageRecord.setCodec(this.codec_id);
        messageRecord.setMessageKey(messageKey);
        messageRecord.setSize(message.getSize());
        messageRecord.setValue(new Buffer(mos.getData()));
        return messageRecord;
    }

    public File getFile() {
        return this.file;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public URI getConfig() {
        return this.config;
    }

    public void setConfig(URI config) {
        this.config = config;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setIndexes(String indexes) {
        this.indexes = indexes;
    }

    public String getIndexes() {
        return this.indexes;
    }

    public String getStartMsgId() {
        return this.startMsgId;
    }

    public void setStartMsgId(String startMsgId) {
        this.startMsgId = startMsgId;
    }

    public String getEndMsgId() {
        return this.endMsgId;
    }

    public void setEndMsgId(String endMsgId) {
        this.endMsgId = endMsgId;
    }
}

