/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.activemq.store.kahadb.disk.index.BTreeIndex;
import org.apache.activemq.store.kahadb.disk.index.BTreeVisitor;
import org.apache.activemq.store.kahadb.disk.page.Page;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;

public final class BTreeNode<Key, Value> {
    private final BTreeIndex<Key, Value> index;
    private BTreeNode<Key, Value> parent;
    private Page<BTreeNode<Key, Value>> page;
    private Key[] keys;
    private Value[] values;
    private long[] children;
    private long next = -1L;

    public BTreeNode(BTreeIndex<Key, Value> index) {
        this.index = index;
    }

    public void setEmpty() {
        this.setLeafData(this.createKeyArray(0), this.createValueArray(0));
    }

    private BTreeNode<Key, Value> getChild(Transaction tx, int idx) throws IOException {
        if (this.isBranch() && idx >= 0 && idx < this.children.length) {
            BTreeNode<Key, Value> result = this.index.loadNode(tx, this.children[idx], this);
            return result;
        }
        return null;
    }

    private BTreeNode<Key, Value> getRightLeaf(Transaction tx) throws IOException {
        BTreeNode<Key, Value> cur = this;
        while (cur.isBranch()) {
            cur = cur.getChild(tx, cur.keys.length);
        }
        return cur;
    }

    private BTreeNode<Key, Value> getLeftLeaf(Transaction tx) throws IOException {
        BTreeNode<Key, Value> cur = this;
        while (cur.isBranch()) {
            cur = cur.getChild(tx, 0);
        }
        return cur;
    }

    private BTreeNode<Key, Value> getLeftPeer(Transaction tx, BTreeNode<Key, Value> x) throws IOException {
        BTreeNode<Key, Value> cur = x;
        while (cur.parent != null) {
            if (cur.parent.children[0] == cur.getPageId()) {
                cur = cur.parent;
                continue;
            }
            for (int i = 0; i < cur.parent.children.length; ++i) {
                if (cur.parent.children[i] != cur.getPageId()) continue;
                return cur.parent.getChild(tx, i - 1);
            }
            throw new AssertionError((Object)("page " + String.valueOf(x) + " was decendent of " + cur.getPageId()));
        }
        return null;
    }

    public Value remove(Transaction tx, Key key) throws IOException {
        if (this.isBranch()) {
            int idx = Arrays.binarySearch(this.keys, key);
            idx = idx < 0 ? -(idx + 1) : idx + 1;
            BTreeNode<Key, Value> child = this.getChild(tx, idx);
            if (child.getPageId() == this.index.getPageId()) {
                throw new IOException("BTree corrupted: Cycle detected.");
            }
            Value rc = child.remove(tx, key);
            if (child.keys.length == 0) {
                if (child.isBranch()) {
                    this.children[idx] = child.children[0];
                    tx.free(child.getPage());
                } else {
                    BTreeNode<Key, Value> previousLeaf = null;
                    if (idx > 0) {
                        previousLeaf = this.getChild(tx, idx - 1).getRightLeaf(tx);
                    } else {
                        BTreeNode<Key, Value> lp = this.getLeftPeer(tx, this);
                        if (lp != null) {
                            previousLeaf = lp.getRightLeaf(tx);
                        }
                    }
                    if (previousLeaf != null) {
                        previousLeaf.next = child.next;
                        this.index.storeNode(tx, previousLeaf, true);
                    }
                    if (idx < this.children.length - 1) {
                        this.setBranchData(BTreeNode.arrayDelete(this.keys, idx), BTreeNode.arrayDelete(this.children, idx));
                    } else {
                        this.setBranchData(BTreeNode.arrayDelete(this.keys, idx - 1), BTreeNode.arrayDelete(this.children, idx));
                    }
                    if (this.children.length == 1 && this.parent == null) {
                        child = this.getChild(tx, 0);
                        this.keys = child.keys;
                        this.children = child.children;
                        this.values = child.values;
                        tx.free(child.getPage());
                    }
                }
                this.index.storeNode(tx, this, true);
            }
            return rc;
        }
        int idx = Arrays.binarySearch(this.keys, key);
        if (idx < 0) {
            return null;
        }
        Value oldValue = this.values[idx];
        this.setLeafData(BTreeNode.arrayDelete(this.keys, idx), BTreeNode.arrayDelete(this.values, idx));
        if (this.keys.length == 0 && this.parent != null) {
            tx.free(this.getPage());
        } else {
            this.index.storeNode(tx, this, true);
        }
        return oldValue;
    }

    public Value put(Transaction tx, Key key, Value value) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.isBranch()) {
            return BTreeNode.getLeafNode(tx, this, key).put(tx, key, value);
        }
        int idx = Arrays.binarySearch(this.keys, key);
        Value oldValue = null;
        if (idx >= 0) {
            oldValue = this.values[idx];
            this.values[idx] = value;
            this.setLeafData(this.keys, this.values);
        } else {
            idx = -(idx + 1);
            this.setLeafData(BTreeNode.arrayInsert(this.keys, key, idx), BTreeNode.arrayInsert(this.values, value, idx));
        }
        try {
            this.index.storeNode(tx, this, this.allowOverflow());
        }
        catch (Transaction.PageOverflowIOException e) {
            this.split(tx);
        }
        return oldValue;
    }

    private void promoteValue(Transaction tx, Key key, long nodeId) throws IOException {
        int idx = Arrays.binarySearch(this.keys, key);
        idx = idx < 0 ? -(idx + 1) : idx + 1;
        this.setBranchData(BTreeNode.arrayInsert(this.keys, key, idx), BTreeNode.arrayInsert(this.children, nodeId, idx + 1));
        try {
            this.index.storeNode(tx, this, this.allowOverflow());
        }
        catch (Transaction.PageOverflowIOException e) {
            this.split(tx);
        }
    }

    private void split(Transaction tx) throws IOException {
        BTreeNode<Key, Value> rNode;
        Key separator;
        Key[] rightKeys;
        Key[] leftKeys;
        Value[] leftValues = null;
        Value[] rightValues = null;
        long[] leftChildren = null;
        long[] rightChildren = null;
        int vc = this.keys.length;
        int pivot = vc / 2;
        if (this.isBranch()) {
            leftKeys = this.createKeyArray(pivot);
            leftChildren = new long[leftKeys.length + 1];
            rightKeys = this.createKeyArray(vc - (pivot + 1));
            rightChildren = new long[rightKeys.length + 1];
            System.arraycopy(this.keys, 0, leftKeys, 0, leftKeys.length);
            System.arraycopy(this.children, 0, leftChildren, 0, leftChildren.length);
            System.arraycopy(this.keys, leftKeys.length + 1, rightKeys, 0, rightKeys.length);
            System.arraycopy(this.children, leftChildren.length, rightChildren, 0, rightChildren.length);
            BTreeIndex.Prefixer<Key> prefixer = this.index.getPrefixer();
            separator = prefixer != null ? prefixer.getSimplePrefix(leftKeys[leftKeys.length - 1], rightKeys[0]) : this.keys[leftKeys.length];
        } else {
            leftKeys = this.createKeyArray(pivot);
            leftValues = this.createValueArray(leftKeys.length);
            rightKeys = this.createKeyArray(vc - pivot);
            rightValues = this.createValueArray(rightKeys.length);
            System.arraycopy(this.keys, 0, leftKeys, 0, leftKeys.length);
            System.arraycopy(this.values, 0, leftValues, 0, leftValues.length);
            System.arraycopy(this.keys, leftKeys.length, rightKeys, 0, rightKeys.length);
            System.arraycopy(this.values, leftValues.length, rightValues, 0, rightValues.length);
            separator = rightKeys[0];
        }
        if (this.parent == null) {
            rNode = this.index.createNode(tx, this);
            BTreeNode<Key, Value> lNode = this.index.createNode(tx, this);
            if (this.isBranch()) {
                rNode.setBranchData(rightKeys, rightChildren);
                lNode.setBranchData(leftKeys, leftChildren);
            } else {
                rNode.setLeafData(rightKeys, rightValues);
                lNode.setLeafData(leftKeys, leftValues);
                lNode.setNext(rNode.getPageId());
            }
            Key[] v = this.createKeyArray(1);
            v[0] = separator;
            this.setBranchData(v, new long[]{lNode.getPageId(), rNode.getPageId()});
            this.index.storeNode(tx, this, true);
            this.index.storeNode(tx, rNode, true);
            this.index.storeNode(tx, lNode, true);
        } else {
            rNode = this.index.createNode(tx, this.parent);
            if (this.isBranch()) {
                this.setBranchData(leftKeys, leftChildren);
                rNode.setBranchData(rightKeys, rightChildren);
            } else {
                rNode.setNext(this.next);
                this.next = rNode.getPageId();
                this.setLeafData(leftKeys, leftValues);
                rNode.setLeafData(rightKeys, rightValues);
            }
            this.index.storeNode(tx, this, true);
            this.index.storeNode(tx, rNode, true);
            this.parent.promoteValue(tx, separator, rNode.getPageId());
        }
    }

    public void printStructure(Transaction tx, PrintWriter out, String prefix) throws IOException {
        if (((String)prefix).length() > 0 && this.parent == null) {
            throw new IllegalStateException("Cycle back to root node detected.");
        }
        if (this.parent == null) {
            prefix = (String)prefix + "|";
            out.println((String)prefix + this.getPageId());
        }
        if (this.isBranch()) {
            for (int i = 0; i < this.children.length; ++i) {
                BTreeNode<Key, Value> child = this.getChild(tx, i);
                if (i == this.children.length - 1) {
                    out.println((String)prefix + "\\- " + child.getPageId() + (String)(child.isBranch() ? " (" + child.children.length + ")" : ""));
                    child.printStructure(tx, out, (String)prefix + "   ");
                    continue;
                }
                out.println((String)prefix + "|- " + child.getPageId() + (String)(child.isBranch() ? " (" + child.children.length + ")" : "") + " : " + String.valueOf(this.keys[i]));
                child.printStructure(tx, out, (String)prefix + "   ");
            }
        }
    }

    public int getMinLeafDepth(Transaction tx, int depth) throws IOException {
        ++depth;
        if (this.isBranch()) {
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < this.children.length; ++i) {
                min = Math.min(min, this.getChild(tx, i).getMinLeafDepth(tx, depth));
            }
            return min;
        }
        return depth;
    }

    public int getMaxLeafDepth(Transaction tx, int depth) throws IOException {
        ++depth;
        if (this.isBranch()) {
            int v = 0;
            for (int i = 0; i < this.children.length; ++i) {
                v = Math.max(v, this.getChild(tx, i).getMaxLeafDepth(tx, depth));
            }
            depth = v;
        }
        return depth;
    }

    public Value get(Transaction tx, Key key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.isBranch()) {
            return BTreeNode.getLeafNode(tx, this, key).get(tx, key);
        }
        int idx = Arrays.binarySearch(this.keys, key);
        if (idx < 0) {
            return null;
        }
        return this.values[idx];
    }

    public boolean isEmpty(Transaction tx) throws IOException {
        return this.keys.length == 0;
    }

    public void visit(Transaction tx, BTreeVisitor<Key, Value> visitor) throws IOException {
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor cannot be null");
        }
        if (this.isBranch()) {
            for (int i = 0; i < this.children.length; ++i) {
                Object key1 = null;
                if (i != 0) {
                    key1 = this.keys[i - 1];
                }
                Object key2 = null;
                if (i != this.children.length - 1) {
                    key2 = this.keys[i];
                }
                if (!visitor.isInterestedInKeysBetween(key1, key2)) continue;
                BTreeNode<Object, Value> child = this.getChild(tx, i);
                child.visit(tx, visitor);
            }
        } else {
            visitor.visit(Arrays.asList(this.keys), Arrays.asList(this.values));
        }
    }

    public Map.Entry<Key, Value> getFirst(Transaction tx) throws IOException {
        BTreeNode<Key, Value> node = this;
        while (node.isBranch()) {
            node = node.getChild(tx, 0);
        }
        if (node.values.length > 0) {
            return new KeyValueEntry(node.keys[0], node.values[0]);
        }
        return null;
    }

    public Map.Entry<Key, Value> getLast(Transaction tx) throws IOException {
        BTreeNode<Key, Value> node = this;
        while (node.isBranch()) {
            node = node.getChild(tx, node.children.length - 1);
        }
        if (node.values.length > 0) {
            int idx = node.values.length - 1;
            return new KeyValueEntry(node.keys[idx], node.values[idx]);
        }
        return null;
    }

    public BTreeNode<Key, Value> getFirstLeafNode(Transaction tx) throws IOException {
        BTreeNode<Key, Value> node = this;
        while (node.isBranch()) {
            node = node.getChild(tx, 0);
        }
        return node;
    }

    public Iterator<Map.Entry<Key, Value>> iterator(Transaction tx, Key startKey, Key endKey) throws IOException {
        if (startKey == null) {
            return this.iterator(tx);
        }
        if (this.isBranch()) {
            return BTreeNode.getLeafNode(tx, this, startKey).iterator(tx, startKey, endKey);
        }
        int idx = Arrays.binarySearch(this.keys, startKey);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        return new BTreeIterator(tx, this, idx, endKey);
    }

    public Iterator<Map.Entry<Key, Value>> iterator(Transaction tx) throws IOException {
        return new BTreeIterator(tx, this.getFirstLeafNode(tx), 0, null);
    }

    public void clear(Transaction tx) throws IOException {
        if (this.isBranch()) {
            for (int i = 0; i < this.children.length; ++i) {
                BTreeNode<Key, Value> node = this.index.loadNode(tx, this.children[i], this);
                node.clear(tx);
                tx.free(node.getPage());
            }
        }
        if (this.parent == null) {
            this.setLeafData(this.createKeyArray(0), this.createValueArray(0));
            this.next = -1L;
            this.index.storeNode(tx, this, true);
        }
    }

    private static <Key, Value> BTreeNode<Key, Value> getLeafNode(Transaction tx, BTreeNode<Key, Value> node, Key key) throws IOException {
        BTreeNode<Key, Value> current = node;
        while (current.isBranch()) {
            int idx = Arrays.binarySearch(current.keys, key);
            idx = idx < 0 ? -(idx + 1) : idx + 1;
            BTreeNode<Key, Value> child = current.getChild(tx, idx);
            if (child == node) {
                throw new IOException("BTree corrupted: Cylce detected.");
            }
            current = child;
        }
        return current;
    }

    public boolean contains(Transaction tx, Key key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.isBranch()) {
            return BTreeNode.getLeafNode(tx, this, key).contains(tx, key);
        }
        int idx = Arrays.binarySearch(this.keys, key);
        return idx >= 0;
    }

    private boolean allowOverflow() {
        return this.keys.length <= 3;
    }

    private void setLeafData(Key[] keys, Value[] values) {
        this.keys = keys;
        this.values = values;
        this.children = null;
    }

    private void setBranchData(Key[] keys, long[] nodeIds) {
        this.keys = keys;
        this.children = nodeIds;
        this.values = null;
    }

    private Key[] createKeyArray(int size) {
        return new Object[size];
    }

    private Value[] createValueArray(int size) {
        return new Object[size];
    }

    private static <T> T[] arrayDelete(T[] vals, int idx) {
        Object[] newVals = new Object[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    private static long[] arrayDelete(long[] vals, int idx) {
        long[] newVals = new long[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    private static <T> T[] arrayInsert(T[] vals, T val, int idx) {
        Object[] newVals = new Object[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    private static long[] arrayInsert(long[] vals, long val, int idx) {
        long[] newVals = new long[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    private boolean isBranch() {
        return this.children != null;
    }

    public long getPageId() {
        return this.page.getPageId();
    }

    public BTreeNode<Key, Value> getParent() {
        return this.parent;
    }

    public void setParent(BTreeNode<Key, Value> parent) {
        this.parent = parent;
    }

    public Page<BTreeNode<Key, Value>> getPage() {
        return this.page;
    }

    public void setPage(Page<BTreeNode<Key, Value>> page) {
        this.page = page;
    }

    public long getNext() {
        return this.next;
    }

    public void setNext(long next) {
        this.next = next;
    }

    public String toString() {
        return "[BTreeNode " + (this.isBranch() ? "branch" : "leaf") + ": " + String.valueOf(Arrays.asList(this.keys)) + "]";
    }

    public static class Marshaller<Key, Value>
    extends VariableMarshaller<BTreeNode<Key, Value>> {
        private final BTreeIndex<Key, Value> index;

        public Marshaller(BTreeIndex<Key, Value> index) {
            this.index = index;
        }

        @Override
        public void writePayload(BTreeNode<Key, Value> node, DataOutput os) throws IOException {
            int i;
            int count = node.keys.length;
            if (count != node.keys.length) {
                throw new IOException("Too many keys");
            }
            os.writeShort(count);
            for (i = 0; i < node.keys.length; ++i) {
                this.index.getKeyMarshaller().writePayload(node.keys[i], os);
            }
            if (node.isBranch()) {
                os.writeBoolean(true);
                for (i = 0; i < count + 1; ++i) {
                    os.writeLong(node.children[i]);
                }
            } else {
                os.writeBoolean(false);
                for (i = 0; i < count; ++i) {
                    this.index.getValueMarshaller().writePayload(node.values[i], os);
                }
                os.writeLong(node.next);
            }
        }

        @Override
        public BTreeNode<Key, Value> readPayload(DataInput is) throws IOException {
            int i;
            BTreeNode<Key, Value> node = new BTreeNode<Key, Value>(this.index);
            int count = is.readShort();
            node.keys = new Object[count];
            for (i = 0; i < count; ++i) {
                node.keys[i] = this.index.getKeyMarshaller().readPayload(is);
            }
            if (is.readBoolean()) {
                node.children = new long[count + 1];
                for (i = 0; i < count + 1; ++i) {
                    node.children[i] = is.readLong();
                }
            } else {
                node.values = new Object[count];
                for (i = 0; i < count; ++i) {
                    node.values[i] = this.index.getValueMarshaller().readPayload(is);
                }
                node.next = is.readLong();
            }
            return node;
        }
    }

    private final class BTreeIterator
    implements Iterator<Map.Entry<Key, Value>> {
        private final Transaction tx;
        private final Key endKey;
        BTreeNode<Key, Value> current;
        int nextIndex;
        Map.Entry<Key, Value> nextEntry;

        private BTreeIterator(Transaction tx, BTreeNode<Key, Value> current, int nextIndex, Key endKey) {
            this.tx = tx;
            this.current = current;
            this.nextIndex = nextIndex;
            this.endKey = endKey;
            if (endKey != null && endKey.equals(0L)) {
                Thread.dumpStack();
            }
        }

        private synchronized void findNextPage() {
            if (this.nextEntry != null) {
                return;
            }
            try {
                while (this.current != null) {
                    if (this.nextIndex >= this.current.keys.length) {
                        if (this.current.next >= 0L) {
                            this.current = BTreeNode.this.index.loadNode(this.tx, this.current.next, null);
                            assert (!this.current.isBranch()) : "Should have linked to the next leaf node.";
                            this.nextIndex = 0;
                            continue;
                        }
                    } else if (this.endKey == null || !this.current.keys[this.nextIndex].equals(this.endKey)) {
                        this.nextEntry = new KeyValueEntry(this.current.keys[this.nextIndex], this.current.values[this.nextIndex]);
                        ++this.nextIndex;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public boolean hasNext() {
            this.findNextPage();
            return this.nextEntry != null;
        }

        @Override
        public Map.Entry<Key, Value> next() {
            this.findNextPage();
            if (this.nextEntry != null) {
                Map.Entry lastEntry = this.nextEntry;
                this.nextEntry = null;
                return lastEntry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyValueEntry
    implements Map.Entry<Key, Value> {
        private final Key key;
        private final Value value;

        public KeyValueEntry(Key key, Value value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @Override
        public Value setValue(Value value) {
            throw new UnsupportedOperationException();
        }
    }
}

