/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.function;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.camel.util.function.ThrowingSupplier;

public final class Suppliers {
    private Suppliers() {
    }

    public static <T> Supplier<T> memorize(Supplier<T> supplier) {
        AtomicReference valueHolder = new AtomicReference();
        return () -> {
            Object supplied = valueHolder.get();
            if (supplied == null) {
                AtomicReference atomicReference = valueHolder;
                synchronized (atomicReference) {
                    supplied = valueHolder.get();
                    if (supplied == null) {
                        supplied = Objects.requireNonNull(supplier.get(), "Supplier should not return null");
                        valueHolder.lazySet(supplied);
                    }
                }
            }
            return supplied;
        };
    }

    public static <T> Supplier<T> memorize(ThrowingSupplier<T, ? extends Exception> supplier, Consumer<Exception> consumer) {
        AtomicReference valueHolder = new AtomicReference();
        return () -> {
            Object supplied = valueHolder.get();
            if (supplied == null) {
                AtomicReference atomicReference = valueHolder;
                synchronized (atomicReference) {
                    supplied = valueHolder.get();
                    if (supplied == null) {
                        try {
                            supplied = Objects.requireNonNull(supplier.get(), "Supplier should not return null");
                            valueHolder.lazySet(supplied);
                        }
                        catch (Exception e) {
                            consumer.accept(e);
                        }
                    }
                }
            }
            return supplied;
        };
    }

    public static <T> Optional<T> firstNotNull(ThrowingSupplier<T, Exception> ... suppliers) throws Exception {
        ThrowingSupplier<T, Exception> supplier;
        Object answer = null;
        ThrowingSupplier<T, Exception>[] throwingSupplierArray = suppliers;
        int n = throwingSupplierArray.length;
        for (int i = 0; i < n && (answer = (Object)(supplier = throwingSupplierArray[i]).get()) == null; ++i) {
        }
        return Optional.ofNullable(answer);
    }

    public static <T> Optional<T> firstMatching(Predicate<T> predicate, ThrowingSupplier<T, Exception> ... suppliers) throws Exception {
        ThrowingSupplier<T, Exception> supplier;
        Object answer = null;
        ThrowingSupplier<T, Exception>[] throwingSupplierArray = suppliers;
        int n = throwingSupplierArray.length;
        for (int i = 0; i < n && !predicate.test(answer = (Object)(supplier = throwingSupplierArray[i]).get()); ++i) {
        }
        return Optional.ofNullable(answer);
    }
}

