/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.com.github.benmanes.caffeine.cache;

import java.lang.ref.ReferenceQueue;
import org.apache.camel.com.github.benmanes.caffeine.base.UnsafeAccess;
import org.apache.camel.com.github.benmanes.caffeine.cache.Node;
import org.apache.camel.com.github.benmanes.caffeine.cache.PD;

class PDA<K, V>
extends PD<K, V> {
    protected static final long ACCESS_TIME_OFFSET = UnsafeAccess.objectFieldOffset(PDA.class, "accessTime");
    volatile long accessTime;
    Node<K, V> previousInAccessOrder;
    Node<K, V> nextInAccessOrder;

    PDA() {
    }

    PDA(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        super(k, referenceQueue, v, referenceQueue2, n, l);
        UnsafeAccess.UNSAFE.putLong(this, ACCESS_TIME_OFFSET, l);
    }

    PDA(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        super(object, v, referenceQueue, n, l);
        UnsafeAccess.UNSAFE.putLong(this, ACCESS_TIME_OFFSET, l);
    }

    @Override
    public Node<K, V> getPreviousInVariableOrder() {
        return this.previousInAccessOrder;
    }

    @Override
    public void setPreviousInVariableOrder(Node<K, V> node) {
        this.previousInAccessOrder = node;
    }

    @Override
    public Node<K, V> getNextInVariableOrder() {
        return this.nextInAccessOrder;
    }

    @Override
    public void setNextInVariableOrder(Node<K, V> node) {
        this.nextInAccessOrder = node;
    }

    @Override
    public long getVariableTime() {
        return this.accessTime;
    }

    @Override
    public void setVariableTime(long l) {
        this.accessTime = l;
    }

    @Override
    public final long getAccessTime() {
        return UnsafeAccess.UNSAFE.getLong(this, ACCESS_TIME_OFFSET);
    }

    @Override
    public final void setAccessTime(long l) {
        UnsafeAccess.UNSAFE.putLong(this, ACCESS_TIME_OFFSET, l);
    }

    @Override
    public final Node<K, V> getPreviousInAccessOrder() {
        return this.previousInAccessOrder;
    }

    @Override
    public final void setPreviousInAccessOrder(Node<K, V> node) {
        this.previousInAccessOrder = node;
    }

    @Override
    public final Node<K, V> getNextInAccessOrder() {
        return this.nextInAccessOrder;
    }

    @Override
    public final void setNextInAccessOrder(Node<K, V> node) {
        this.nextInAccessOrder = node;
    }

    @Override
    public Node<K, V> newNode(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        return new PDA<K, V>(k, referenceQueue, v, referenceQueue2, n, l);
    }

    @Override
    public Node<K, V> newNode(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        return new PDA<K, V>(object, v, referenceQueue, n, l);
    }
}

