/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.extension;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.GlobalCASSource;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerPreprocessorDelegate;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TextRulerPreprocessor {
    public String run(String inFolder, String tmFile, String tmpDir, String[] currentSlotNames, TextRulerPreprocessorDelegate delegate) {
        return this.run(inFolder, "input", tmFile, tmpDir, currentSlotNames, delegate);
    }

    public String run(String inFolder, String docType, String tmFile, String tmpDir, String[] currentSlotNames, TextRulerPreprocessorDelegate delegate) {
        if (StringUtils.isBlank((CharSequence)inFolder)) {
            return inFolder;
        }
        AnalysisEngineDescription analysisEngineDescription = TextRulerToolkit.getAnalysisEngineDescription(TextRulerToolkit.getEngineDescriptorFromTMSourceFile((IPath)new Path(tmFile)));
        if (analysisEngineDescription == null) {
            delegate.preprocessorStatusUpdate(this, "Descriptor is missing. Please rebuild the project.");
            return null;
        }
        TextRulerToolkit.addBoundaryTypes(analysisEngineDescription, currentSlotNames);
        AnalysisEngine ae = TextRulerToolkit.loadAnalysisEngine(analysisEngineDescription);
        File inputFolder = new File(inFolder);
        File outputFolder = new File(tmpDir + docType);
        File[] files = inputFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xmi");
            }
        });
        try {
            outputFolder.mkdir();
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
            return null;
        }
        CAS cas = null;
        for (File file : files) {
            if (delegate != null && delegate.shouldAbort()) {
                TextRulerToolkit.log("[PREPROCESSOR] ABORT");
                break;
            }
            TextRulerToolkit.log("Load INPUT XMI file: " + file.getName());
            if (delegate != null) {
                delegate.preprocessorStatusUpdate(this, "Loading input XMI file (" + docType + "): " + file.getName());
            }
            cas = TextRulerToolkit.readCASfromXMIFile(file, ae, cas);
            System.out.print("Processing...");
            try {
                ae.process(cas);
                TextRulerToolkit.log(" OK");
                TextRulerToolkit.writeCAStoXMIFile(cas, outputFolder + "/processed_" + file.getName());
            }
            catch (Exception e) {
                TextRulerPlugin.error(e);
                TextRulerToolkit.log(" ERROR!");
            }
            cas.reset();
            if (delegate == null) continue;
            delegate.preprocessorStatusUpdate(this, "Done");
        }
        if (cas != null) {
            cas.reset();
            GlobalCASSource.releaseCAS(cas);
        }
        return tmpDir + docType;
    }
}

