/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.validator;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.parser.ast.FeatureMatchExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaAbstractDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaBlock;
import org.apache.uima.ruta.ide.parser.ast.RutaDeclareDeclarationsStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaFeatureDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaImportStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaPackageDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaTypeDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.apache.uima.ruta.ide.validator.RutaCheckerProblemFactory;
import org.apache.uima.ruta.ide.validator.RutaCheckerUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.ISourceLineTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaTypeChecker
implements IBuildParticipant,
IBuildParticipantExtension {
    private IScriptProject project;

    public RutaTypeChecker(IScriptProject project) throws CoreException {
        this.project = project;
    }

    public boolean beginBuild(int buildType) {
        return true;
    }

    public void endBuild(IProgressMonitor monitor) {
    }

    public void build(IBuildContext context) throws CoreException {
        Object mdObj = context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (!(mdObj instanceof ModuleDeclaration)) {
            return;
        }
        ModuleDeclaration md = (ModuleDeclaration)mdObj;
        IProblemReporter problemReporter = context.getProblemReporter();
        ISourceModule smod = context.getSourceModule();
        Set<String> types = null;
        try {
            types = this.importBasicTypeSystem();
        }
        catch (InvalidXMLException e1) {
            System.err.println("ERROR: Failed to get BasicTypeSystem!! " + this.toString());
        }
        catch (IOException e1) {
            System.err.println("ERROR: Failed to get BasicTypeSystem!! " + this.toString());
        }
        if (types == null) {
            types = new TreeSet<String>();
        }
        ISourceLineTracker linetracker = context.getLineTracker();
        Set<String> shortTypes = this.getShortTypeNames(types);
        try {
            TypeCheckerVisitor visitor = new TypeCheckerVisitor(problemReporter, linetracker, smod, types, shortTypes);
            md.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            RutaIdeUIPlugin.error(e);
        }
    }

    private Set<String> importBasicTypeSystem() throws InvalidXMLException, IOException, CoreException {
        String basicXmlFile = "BasicTypeSystem";
        Set<String> types = this.importTypeSystem("BasicTypeSystem");
        types.add("uima.tcas.Annotation");
        types.add("uima.tcas.DocumentAnnotation");
        return types;
    }

    public Set<String> getShortTypeNames(Set<String> types) {
        TreeSet<String> result = new TreeSet<String>();
        for (String string : types) {
            String[] nameSpace = string.split("[.]");
            result.add(nameSpace[nameSpace.length - 1]);
        }
        return result;
    }

    private Set<String> importTypeSystem(String xmlFilePath) throws InvalidXMLException, IOException, CoreException {
        List folders = RutaProjectUtils.getAllDescriptorFolders((IProject)this.project.getProject());
        String[] split = xmlFilePath.split("[.]");
        String fileExtended = "";
        for (String string : split) {
            fileExtended = fileExtended + string;
            fileExtended = fileExtended + "/";
        }
        fileExtended = fileExtended.substring(0, fileExtended.length() - 1) + ".xml";
        TreeSet<String> types = new TreeSet<String>();
        for (IFolder folder : folders) {
            types.addAll(this.getTypes(folder, fileExtended));
        }
        return types;
    }

    private Set<String> getTypes(IFolder folder, String filePath) throws InvalidXMLException, IOException {
        Set<String> types = new HashSet<String>();
        IFile iFile = this.getFile(folder, filePath);
        if (iFile.exists()) {
            try {
                URL url = iFile.getLocationURI().toURL();
                ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
                resMgr.setDataPath(folder.getLocation().toPortableString());
                types = this.getTypes(url, resMgr);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return types;
    }

    private IFile getFile(IFolder folder, String filePath) {
        int lastDot = filePath.lastIndexOf(46);
        int sndLastDot = filePath.lastIndexOf(46, lastDot - 1);
        String fName = filePath;
        if (sndLastDot >= 0) {
            String subFolder = filePath.substring(0, sndLastDot);
            folder = folder.getFolder(subFolder);
            fName = filePath.substring(sndLastDot + 1);
        }
        IFile file = folder.getFile(fName);
        return file;
    }

    private Set<String> getTypes(URL resource, ResourceManager resMgr) throws IOException, InvalidXMLException {
        HashSet<String> types = new HashSet<String>();
        TypeSystemDescription typeSysDescr = null;
        typeSysDescr = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(resource));
        typeSysDescr.resolveImports(resMgr);
        for (TypeDescription each : typeSysDescr.getTypes()) {
            String name = each.getName();
            types.add(name);
        }
        return types;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeCheckerVisitor
    extends ASTVisitor {
        private final Stack<String> blocks;
        private final Set<String> typeVariables;
        private final Set<String> otherVariables;
        private IProblemReporter rep;
        private ISourceModule currentFile;
        private ISourceLineTracker linetracker;
        private Set<String> completeTypes;
        private Set<String> shortTypes;
        private RutaCheckerProblemFactory problemFactory;
        private String packageName;
        private TypeSystemDescription description;
        private Set<String> otherTypes;
        private Set<String> finalTypes;
        private boolean reportWarningOnShortNames;

        public TypeCheckerVisitor(IProblemReporter rep, ISourceLineTracker linetracker, ISourceModule curFile, Set<String> completeTypes, Set<String> shortTypes) {
            this.problemFactory = new RutaCheckerProblemFactory(curFile.getElementName(), linetracker);
            this.linetracker = linetracker;
            this.rep = rep;
            this.typeVariables = new HashSet<String>();
            this.otherVariables = new HashSet<String>();
            this.blocks = new Stack();
            this.packageName = "";
            this.currentFile = curFile;
            this.completeTypes = completeTypes;
            this.shortTypes = shortTypes;
            this.otherTypes = new HashSet<String>();
            HashSet<String> uimaPredefTypes = new HashSet<String>();
            uimaPredefTypes.addAll(Arrays.asList("uima.cas.Boolean", "uima.cas.Byte", "uima.cas.Short", "uima.cas.Integer", "uima.cas.Long", "uima.cas.Float", "uima.cas.Double", "uima.cas.String", "uima.cas.BooleanArray", "uima.cas.ByteArray", "uima.cas.ShortArray", "uima.cas.IntegerArray", "uima.cas.LongArray", "uima.cas.FloatArray", "uima.cas.DoubleArray", "uima.cas.StringArray", "uima.cas.FSArray", "uima.cas.AnnotationBase", "uima.tcas.Annotation", "uima.tcas.DocumentAnnotation", "uima.cas.FloatList", "uima.cas.IntegerList", "uima.cas.StringList", "uima.cas.FSList", "uima.cas.EmptyFloatList", "uima.cas.EmptyIntegerList", "uima.cas.EmptyStringList", "uima.cas.EmptyFSList", "uima.cas.NonEmptyFloatList", "uima.cas.NonEmptyIntegerList", "uima.cas.NonEmptyStringList", "uima.cas.NonEmptyFSList"));
            for (String string : uimaPredefTypes) {
                int indexOf = string.lastIndexOf(46);
                this.otherTypes.add(string);
                this.otherTypes.add(string.substring(indexOf + 1, string.length()));
            }
            this.finalTypes = new HashSet<String>();
            HashSet<String> uimaFinalTypes = new HashSet<String>();
            uimaFinalTypes.addAll(Arrays.asList("uima.cas.Boolean", "uima.cas.Byte", "uima.cas.Short", "uima.cas.Integer", "uima.cas.Long", "uima.cas.Float", "uima.cas.Double", "uima.cas.BooleanArray", "uima.cas.ByteArray", "uima.cas.ShortArray", "uima.cas.IntegerArray", "uima.cas.LongArray", "uima.cas.FloatArray", "uima.cas.DoubleArray", "uima.cas.StringArray", "uima.cas.FSArray"));
            for (String string : uimaFinalTypes) {
                int indexOf = string.lastIndexOf(46);
                this.finalTypes.add(string);
                this.finalTypes.add(string.substring(indexOf + 1, string.length()));
            }
            try {
                this.description = this.getTypeSystemOfScript();
            }
            catch (Exception e) {
                RutaIdeUIPlugin.error(e);
            }
            Preferences store = RutaIdeUIPlugin.getDefault().getPluginPreferences();
            this.reportWarningOnShortNames = !store.getBoolean("BuilderErrorOnDuplicateShortnames");
        }

        public boolean endvisit(MethodDeclaration s) throws Exception {
            if (s instanceof RutaBlock) {
                this.blocks.pop();
            }
            return super.endvisit(s);
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            if (s instanceof RutaBlock) {
                RutaBlock b = (RutaBlock)s;
                this.blocks.push(b.getName());
            }
            return true;
        }

        public boolean visit(Statement s) throws Exception {
            if (s instanceof RutaPackageDeclaration) {
                this.packageName = ((RutaPackageDeclaration)s).getName();
                return false;
            }
            if (s instanceof RutaDeclareDeclarationsStatement) {
                RutaVariableReference p;
                String name;
                RutaDeclareDeclarationsStatement dds = (RutaDeclareDeclarationsStatement)s;
                ASTNode parent = dds.getParent();
                if (parent != null && parent instanceof RutaVariableReference && this.finalTypes.contains(name = (p = (RutaVariableReference)parent).getName())) {
                    IProblem problem = this.problemFactory.createInheritenceFinalProblem(p);
                    this.rep.reportProblem(problem);
                }
                return true;
            }
            if (s instanceof RutaVariableDeclaration) {
                RutaVariableDeclaration newVar = (RutaVariableDeclaration)s;
                if (this.shortTypes.contains(newVar.getName())) {
                    IProblem problem = this.problemFactory.createIdConflictsWithTypeProblem((RutaAbstractDeclaration)newVar);
                    this.rep.reportProblem(problem);
                    return false;
                }
                if ((newVar.getKind() & 0x800000) != 0) {
                    this.typeVariables.add(newVar.getName());
                    return false;
                }
                this.otherVariables.add(newVar.getName());
                return false;
            }
            if (s instanceof RutaTypeDeclaration) {
                RutaTypeDeclaration newType = (RutaTypeDeclaration)s;
                String longName = this.getLongLocalName(newType.getName());
                if (this.completeTypes.contains(longName)) {
                    IProblem problem = this.problemFactory.createIdConflictsWithTypeProblem((RutaAbstractDeclaration)newType);
                    this.rep.reportProblem(problem);
                    return false;
                }
                if (this.reportWarningOnShortNames && this.shortTypes.contains(newType.getName())) {
                    IProblem problem = this.problemFactory.createDuplicateShortName((RutaAbstractDeclaration)newType, ProblemSeverity.WARNING);
                    this.rep.reportProblem(problem);
                    return false;
                }
                if (this.typeVariables.contains(newType.getName()) || this.otherVariables.contains(newType.getName())) {
                    IProblem problem = this.problemFactory.createIdConflictsWithVariableProblem((RutaAbstractDeclaration)newType);
                    this.rep.reportProblem(problem);
                    return false;
                }
                List features = newType.getFeatures();
                if (features != null) {
                    for (RutaFeatureDeclaration each : features) {
                        String type = each.getType();
                        if (type.equals("INT") || type.equals("STRING") || type.equals("DOUBLE") || type.equals("FLOAT") || type.equals("BOOLEAN") || this.shortTypes.contains(type) || this.completeTypes.contains(type) || this.otherTypes.contains(type)) continue;
                        IProblem problem = this.problemFactory.createUnknownFeatureTypeProblem(each);
                        this.rep.reportProblem(problem);
                    }
                }
                String[] nameSplit = newType.getName().split("[.]");
                String shortName = nameSplit[nameSplit.length - 1];
                this.completeTypes.add(longName);
                this.shortTypes.add(shortName);
                return false;
            }
            if (s instanceof RutaImportStatement) {
                if (((RutaImportStatement)s).getType() == 3) {
                    SimpleReference sRef = (SimpleReference)((RutaImportStatement)s).getExpression();
                    String localPath = sRef.getName();
                    try {
                        List<String> checkDuplicateShortNames;
                        boolean checkTypeSystemImport = RutaCheckerUtils.checkTypeSystemImport(localPath, RutaTypeChecker.this.project);
                        if (!checkTypeSystemImport) {
                            this.rep.reportProblem(this.problemFactory.createFileNotFoundProblem((ASTNode)sRef, localPath));
                        }
                        Set importedTypes = RutaTypeChecker.this.importTypeSystem(localPath);
                        Set<String> importedShortTypes = RutaTypeChecker.this.getShortTypeNames(importedTypes);
                        if (this.reportWarningOnShortNames && !(checkDuplicateShortNames = this.checkDuplicateShortNames(this.completeTypes, importedTypes)).isEmpty()) {
                            this.rep.reportProblem(this.problemFactory.createDuplicateShortNameInImported((ASTNode)sRef, localPath, checkDuplicateShortNames, ProblemSeverity.WARNING));
                        }
                        this.completeTypes.addAll(importedTypes);
                        this.shortTypes.addAll(importedShortTypes);
                    }
                    catch (IOException e) {
                        this.rep.reportProblem(this.problemFactory.createFileNotFoundProblem((ASTNode)sRef, localPath));
                    }
                    catch (InvalidXMLException e) {
                        this.rep.reportProblem(this.problemFactory.createXMLProblem((ASTNode)sRef, localPath));
                    }
                    return false;
                }
                if (((RutaImportStatement)s).getType() == 5) {
                    SimpleReference sRef = (SimpleReference)((RutaImportStatement)s).getExpression();
                    String localpath = sRef.getName();
                    try {
                        List<String> checkDuplicateShortNames;
                        boolean checkScriptImport = RutaCheckerUtils.checkScriptImport(localpath, RutaTypeChecker.this.project);
                        if (!checkScriptImport) {
                            this.rep.reportProblem(this.problemFactory.createFileNotFoundProblem((ASTNode)sRef, localpath));
                        }
                        Set importedTypes = RutaTypeChecker.this.importTypeSystem(localpath + "TypeSystem");
                        Set<String> importedShortTypes = RutaTypeChecker.this.getShortTypeNames(importedTypes);
                        Preferences store = RutaIdeUIPlugin.getDefault().getPluginPreferences();
                        if (this.reportWarningOnShortNames && !(checkDuplicateShortNames = this.checkDuplicateShortNames(this.completeTypes, importedTypes)).isEmpty()) {
                            this.rep.reportProblem(this.problemFactory.createDuplicateShortNameInImported((ASTNode)sRef, localpath, checkDuplicateShortNames, ProblemSeverity.WARNING));
                        }
                        this.completeTypes.addAll(importedTypes);
                        this.shortTypes.addAll(importedShortTypes);
                    }
                    catch (IOException e) {
                        this.rep.reportProblem(this.problemFactory.createFileNotFoundProblem((ASTNode)sRef, localpath));
                    }
                    Set<Object> importedTypes = new HashSet();
                    try {
                        importedTypes = RutaCheckerUtils.importScript(localpath, 8, RutaTypeChecker.this.project, true);
                    }
                    catch (IOException e) {
                        this.rep.reportProblem(this.problemFactory.createFileNotFoundProblem((ASTNode)sRef, localpath));
                    }
                    this.shortTypes.addAll(importedTypes);
                    return false;
                }
            }
            return true;
        }

        private String getLongLocalName(String name) {
            if (name.indexOf(".") == -1) {
                String pack = this.packageName.equals("") ? "" : this.packageName + ".";
                String longName = pack + this.currentFile.getElementName().substring(0, this.currentFile.getElementName().length() - 5) + ".";
                for (String each : this.blocks) {
                    longName = longName + each + ".";
                }
                longName = longName + name;
                return longName;
            }
            return name;
        }

        private List<String> checkDuplicateShortNames(Set<String> types, Set<String> importedTypes) {
            ArrayList<String> result = new ArrayList<String>();
            for (String t1 : importedTypes) {
                for (String t2 : types) {
                    if (!this.checkTypeName(t1, t2)) continue;
                    result.add(t1);
                    result.add(t2);
                }
            }
            return result;
        }

        private boolean checkTypeName(String t1, String t2) {
            int lastIndexOf1 = t1.lastIndexOf(".");
            int lastIndexOf2 = t2.lastIndexOf(".");
            String shortName1 = t1.substring(lastIndexOf1 + 1, t1.length());
            String shortName2 = t2.substring(lastIndexOf2 + 1, t2.length());
            String namespace1 = "";
            String namespace2 = "";
            if (lastIndexOf1 >= 0) {
                namespace1 = t1.substring(0, lastIndexOf1);
            }
            if (lastIndexOf2 >= 0) {
                namespace2 = t2.substring(0, lastIndexOf2);
            }
            return shortName1.equals(shortName2) && !namespace1.equals(namespace2);
        }

        private TypeSystemDescription getTypeSystemOfScript() throws InvalidXMLException, IOException {
            IPath descriptorPath = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)this.currentFile.getResource().getLocation(), (IProject)RutaTypeChecker.this.project.getProject());
            TypeSystemDescription typeSysDescr = null;
            if (descriptorPath.toFile().exists()) {
                typeSysDescr = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(descriptorPath.toPortableString()));
                ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
                IFolder folder = RutaTypeChecker.this.project.getProject().getFolder(RutaProjectUtils.getDefaultDescriptorLocation());
                resMgr.setDataPath(folder.getLocation().toPortableString());
                typeSysDescr.resolveImports(resMgr);
            }
            return typeSysDescr;
        }

        public boolean visit(Expression s) throws Exception {
            if (s instanceof RutaVariableReference) {
                RutaVariableReference ref = (RutaVariableReference)s;
                int kind = ref.getKind();
                int rutaTypeAt = 0x800000;
                int rutaTypeS = 0x200000;
                if ((ref.getType() & 0x800000) == 0) {
                    return false;
                }
                if (this.typeVariables.contains(ref.getName()) || this.completeTypes.contains(ref.getName()) || this.shortTypes.contains(ref.getName()) || this.otherTypes.contains(ref.getName()) || this.isLongLocalATRef(ref.getName()) || this.isLongExternalATRef(ref.getName())) {
                    return false;
                }
                if (this.isFeatureMatch(ref.getName()) != null) {
                    return false;
                }
                this.rep.reportProblem(this.problemFactory.createTypeProblem(ref, this.currentFile));
                return false;
            }
            if (s instanceof FeatureMatchExpression) {
                FeatureMatchExpression fme = (FeatureMatchExpression)s;
                String featText = fme.getFeature().getText();
                this.checkTypeOfFeatureMatch(featText, fme);
                return true;
            }
            return true;
        }

        private void checkTypeOfFeatureMatch(String featText, FeatureMatchExpression fme) {
            int lastIndexOf = featText.lastIndexOf(".");
            if (lastIndexOf == -1) {
                return;
            }
            String aref = featText.substring(0, lastIndexOf);
            String fref = featText.substring(lastIndexOf + 1, featText.length());
            String match = this.isFeatureMatch(aref);
            if (match != null) {
                boolean findFeature;
                int kind = -1;
                if (fme.getValue() != null) {
                    kind = fme.getValue().getKind();
                    if (fme.getValue() instanceof StringLiteral) {
                        kind = 0x200000;
                    } else if (fme.getValue() instanceof NumericLiteral) {
                        kind = 262144;
                    }
                }
                if (!(findFeature = this.findFeature(match, fref, kind))) {
                    this.rep.reportProblem(this.problemFactory.createUnknownFeatureProblem((Expression)fme, aref));
                }
            } else {
                this.rep.reportProblem(this.problemFactory.createUnknownFeatureProblem((Expression)fme, aref));
            }
        }

        private String isFeatureMatch(String text) {
            String t;
            for (String each : this.shortTypes) {
                t = this.checkFeatureMatch(text, each);
                if (t == null) continue;
                return t;
            }
            for (String each : this.completeTypes) {
                t = this.checkFeatureMatch(text, each);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        private boolean findFeature(String structure, String feat, int kind) {
            String typeName;
            if (this.description == null) {
                return true;
            }
            if (structure == null) {
                return false;
            }
            if ("begin".equals(feat) || "end".equals(feat)) {
                return true;
            }
            if ((structure.equals("Document") || structure.equals("DocumentAnnotation") || structure.equals("uima.tcas.DocumentAnnotation")) && feat.equals("language")) {
                return true;
            }
            boolean featureFound = false;
            TypeDescription[] descriptions = this.description.getTypes();
            HashMap<String, TypeDescription> typeMap = new HashMap<String, TypeDescription>();
            for (TypeDescription typeDescription : descriptions) {
                typeName = typeDescription.getName();
                typeMap.put(typeName, typeDescription);
            }
            for (TypeDescription typeDescription : descriptions) {
                typeName = typeDescription.getName();
                String shortName = this.getShortName(typeName);
                if (typeName.equals(structure) || shortName.equals(structure)) {
                    Collection<FeatureDescription> allFeatures = this.getAllDeclaredFeatures(typeDescription, typeMap);
                    for (FeatureDescription featureDescription : allFeatures) {
                        String featureName = featureDescription.getName();
                        if (!featureName.equals(feat) || !this.checkFeatureKind(featureDescription, kind)) continue;
                        featureFound = true;
                        break;
                    }
                }
                if (featureFound) break;
            }
            return featureFound;
        }

        private boolean checkFeatureKind(FeatureDescription f, int kind) {
            if (kind == -1) {
                return true;
            }
            String t = f.getRangeTypeName();
            if (t.equals("uima.cas.Boolean") && 0x400000 == kind) {
                return true;
            }
            if (t.equals("uima.cas.String") && 0x200000 == kind) {
                return true;
            }
            return (t.equals("uima.cas.Byte") || t.equals("uima.cas.Double") || t.equals("uima.cas.Float") || t.equals("uima.cas.Integer") || t.equals("uima.cas.Long") || t.equals("uima.cas.Short")) && 262144 == kind;
        }

        private String getShortName(String typeName) {
            String[] nameSpace = typeName.split("[.]");
            return nameSpace[nameSpace.length - 1];
        }

        private Collection<FeatureDescription> getAllDeclaredFeatures(TypeDescription typeDescription, Map<String, TypeDescription> typeMap) {
            HashSet<FeatureDescription> result = new HashSet<FeatureDescription>();
            if (typeDescription == null) {
                return result;
            }
            FeatureDescription[] features = typeDescription.getFeatures();
            if (features == null) {
                return result;
            }
            result.addAll(Arrays.asList(features));
            String supertypeName = typeDescription.getSupertypeName();
            if (supertypeName != null) {
                TypeDescription parent = typeMap.get(supertypeName);
                result.addAll(this.getAllDeclaredFeatures(parent, typeMap));
            }
            return result;
        }

        private String checkFeatureMatch(String name, String type) {
            if (name.startsWith(type)) {
                boolean foundAll = true;
                if (name.length() > type.length()) {
                    String tail = name.substring(type.length() + 1);
                    String[] split = tail.split("[.]");
                    String typeToCheck = type;
                    for (String feat : split) {
                        if (foundAll &= (typeToCheck = this.checkFSFeatureOfType(feat, typeToCheck)) != null) continue;
                        return null;
                    }
                    return typeToCheck;
                }
                return type;
            }
            return null;
        }

        private String checkFSFeatureOfType(String feat, String type) {
            FeatureDescription[] features;
            TypeDescription t;
            if (type.indexOf(".") == -1) {
                for (String each : this.completeTypes) {
                    String[] split = each.split("[.]");
                    if (!split[split.length - 1].equals(type)) continue;
                    type = each;
                    break;
                }
            }
            if ((t = this.description.getType(type)) == null) {
                return null;
            }
            for (FeatureDescription featureDescription : features = t.getFeatures()) {
                String name = featureDescription.getName();
                String rangeTypeName = featureDescription.getRangeTypeName();
                boolean isFS = this.isFeatureStructure(rangeTypeName);
                if (!name.equals(feat) || !isFS) continue;
                return rangeTypeName;
            }
            return null;
        }

        private boolean isFeatureStructure(String rangeTypeName) {
            if (rangeTypeName.equals("uima.tcas.Annotation") || rangeTypeName.equals("uima.cas.TOP")) {
                return true;
            }
            TypeDescription type = this.description.getType(rangeTypeName);
            if (type == null) {
                return false;
            }
            String supertypeName = type.getSupertypeName();
            if (supertypeName != null) {
                return this.isFeatureStructure(supertypeName);
            }
            return false;
        }

        private boolean isLongExternalATRef(String name) {
            int lastIndexOf = name.lastIndexOf(".");
            if (lastIndexOf == -1) {
                return false;
            }
            for (String each : this.shortTypes) {
                lastIndexOf = each.lastIndexOf(".");
                if (lastIndexOf == -1 || !each.endsWith(name)) continue;
                return true;
            }
            return false;
        }

        private boolean isLongLocalATRef(String name) {
            String ref;
            String longName = this.packageName + "." + this.currentFile.getElementName().substring(0, this.currentFile.getElementName().length() - 5);
            if (!name.startsWith(longName)) {
                return false;
            }
            try {
                ref = name.substring(longName.length() + 1);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            return this.shortTypes.contains(ref);
        }
    }
}

