/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.ruta.explain.tree.ApplyRootNode;
import org.apache.uima.ruta.explain.tree.BlockApplyNode;
import org.apache.uima.ruta.explain.tree.ConditionNode;
import org.apache.uima.ruta.explain.tree.ExplainAbstractTreeNode;
import org.apache.uima.ruta.explain.tree.FailedRootNode;
import org.apache.uima.ruta.explain.tree.IExplainTreeNode;
import org.apache.uima.ruta.explain.tree.InlinedRootNode;
import org.apache.uima.ruta.explain.tree.InlinedRuleBlockNode;
import org.apache.uima.ruta.explain.tree.MatchedRootNode;
import org.apache.uima.ruta.explain.tree.RuleApplyNode;
import org.apache.uima.ruta.explain.tree.RuleElementMatchNode;
import org.apache.uima.ruta.explain.tree.RuleElementMatchesNode;
import org.apache.uima.ruta.explain.tree.RuleElementRootNode;
import org.apache.uima.ruta.explain.tree.RuleMatchNode;
import org.apache.uima.ruta.type.DebugBlockApply;
import org.apache.uima.ruta.type.DebugEvaluatedCondition;
import org.apache.uima.ruta.type.DebugInlinedBlock;
import org.apache.uima.ruta.type.DebugRuleApply;
import org.apache.uima.ruta.type.DebugRuleElementMatch;
import org.apache.uima.ruta.type.DebugRuleElementMatches;
import org.apache.uima.ruta.type.DebugRuleMatch;
import org.apache.uima.ruta.type.DebugScriptApply;

public class ExplainTree {
    private IExplainTreeNode root;

    public ExplainTree(JCas jcas) {
        this(jcas, -1);
    }

    public ExplainTree(JCas jcas, int offset) {
        this(jcas, offset, false);
        if (offset >= 0) {
            this.prune(this.root);
        }
    }

    public ExplainTree(JCas jcas, int offset, boolean onlyRules) {
        this.createTree(jcas, offset, onlyRules);
    }

    public IExplainTreeNode getRoot() {
        return this.root;
    }

    private void createTree(JCas jcas, int offset, boolean onlyRules) {
        TypeSystem ts = jcas.getTypeSystem();
        ArrayList scriptApplies = new ArrayList(JCasUtil.select((JCas)jcas, DebugScriptApply.class));
        Collections.sort(scriptApplies, new Comparator<DebugScriptApply>(){

            @Override
            public int compare(DebugScriptApply o1, DebugScriptApply o2) {
                long l1 = o1.getTimestamp();
                long l2 = o2.getTimestamp();
                return Long.compare(l1, l2);
            }
        });
        this.root = new ApplyRootNode(null, ts);
        for (DebugScriptApply scriptApply : scriptApplies) {
            this.buildTree((FeatureStructure)scriptApply, this.root, ts, offset, onlyRules);
        }
    }

    private void buildTree(FeatureStructure fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        if (fs instanceof DebugBlockApply) {
            this.processBlockApply((DebugBlockApply)fs, parent, ts, offset, onlyRules);
        } else if (fs instanceof DebugRuleApply) {
            this.processRuleApply((DebugRuleApply)fs, parent, ts, offset, onlyRules);
        } else if (fs instanceof DebugRuleMatch) {
            this.processRuleMatch((DebugRuleMatch)fs, parent, ts, offset, onlyRules);
        } else if (fs instanceof DebugRuleElementMatches) {
            this.processRuleElementMatches((DebugRuleElementMatches)fs, parent, ts, offset, onlyRules);
        } else if (fs instanceof DebugRuleElementMatch) {
            this.processRuleElementMatch((DebugRuleElementMatch)fs, parent, ts, offset, onlyRules);
        } else if (fs instanceof DebugEvaluatedCondition) {
            this.processEvaluatedCondition((DebugEvaluatedCondition)fs, parent, ts, offset, onlyRules);
        }
    }

    private void buildInlinedBlock(boolean asCondition, DebugInlinedBlock debugInlinedBlock, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        InlinedRuleBlockNode inlinedBlockNode = new InlinedRuleBlockNode(parent, (FeatureStructure)debugInlinedBlock, debugInlinedBlock.getAsCondition(), debugInlinedBlock.getMatched(), ts);
        parent.addChild(inlinedBlockNode);
        FSArray inlinedRules = debugInlinedBlock.getInlinedRules();
        if (inlinedRules != null) {
            for (FeatureStructure each : inlinedRules) {
                this.buildTree(each, inlinedBlockNode, ts, offset, onlyRules);
            }
        }
    }

    private void processBlockApply(DebugBlockApply fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        BlockApplyNode blockNode = null;
        if (!onlyRules) {
            blockNode = new BlockApplyNode(parent, (FeatureStructure)fs, ts);
            parent.addChild(blockNode);
            this.processBlockRuleApply(fs, blockNode, ts, offset, onlyRules);
        }
        if (fs.getInnerApply() != null) {
            for (FeatureStructure each : fs.getInnerApply()) {
                if (!onlyRules) {
                    this.buildTree(each, blockNode, ts, offset, onlyRules);
                    continue;
                }
                this.buildTree(each, parent, ts, offset, onlyRules);
            }
        }
    }

    private void processBlockRuleApply(DebugBlockApply fs, BlockApplyNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        RuleApplyNode ruleNode = new RuleApplyNode(parent, (FeatureStructure)fs, ts);
        parent.setBlockRuleApply(ruleNode);
        MatchedRootNode matched = new MatchedRootNode(ruleNode, ts);
        FailedRootNode failed = new FailedRootNode(ruleNode, ts);
        ruleNode.addChild(matched);
        ruleNode.addChild(failed);
        if (fs.getRules() != null) {
            for (FeatureStructure each : fs.getRules()) {
                DebugRuleMatch eachRuleMatch = (DebugRuleMatch)each;
                boolean matchedValue = eachRuleMatch.getMatched();
                if (matchedValue) {
                    this.buildTree((FeatureStructure)eachRuleMatch, matched, ts, offset, onlyRules);
                } else {
                    this.buildTree((FeatureStructure)eachRuleMatch, failed, ts, offset, onlyRules);
                }
                if (eachRuleMatch.getDelegates() == null) continue;
                for (FeatureStructure delegateFS : eachRuleMatch.getDelegates()) {
                    this.buildTree(delegateFS, ruleNode, ts, offset, onlyRules);
                }
            }
        }
    }

    private void processRuleApply(DebugRuleApply fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        RuleApplyNode ruleNode = new RuleApplyNode(parent, (FeatureStructure)fs, ts);
        parent.addChild(ruleNode);
        MatchedRootNode matched = new MatchedRootNode(ruleNode, ts);
        FailedRootNode failed = new FailedRootNode(ruleNode, ts);
        ruleNode.addChild(matched);
        ruleNode.addChild(failed);
        if (fs.getRules() != null) {
            for (FeatureStructure each : fs.getRules()) {
                DebugRuleMatch eachRuleMatch = (DebugRuleMatch)each;
                boolean matchedValue = eachRuleMatch.getMatched();
                if (matchedValue) {
                    this.buildTree((FeatureStructure)eachRuleMatch, matched, ts, offset, onlyRules);
                } else {
                    this.buildTree((FeatureStructure)eachRuleMatch, failed, ts, offset, onlyRules);
                }
                if (eachRuleMatch.getDelegates() == null) continue;
                for (FeatureStructure delegateFS : eachRuleMatch.getDelegates()) {
                    this.buildTree(delegateFS, ruleNode, ts, offset, onlyRules);
                }
            }
            if (fs.getRules().size() == 1) {
                this.mergeInlinedRuleBlockNodesOfChildren(ruleNode);
            }
        }
    }

    private void processRuleMatch(DebugRuleMatch fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        RuleMatchNode matchNode = new RuleMatchNode(parent, (FeatureStructure)fs, ts);
        parent.addChild(matchNode);
        RuleElementRootNode remRoot = new RuleElementRootNode(matchNode, ts);
        matchNode.addChild(remRoot);
        if (fs.getElements() != null) {
            for (FeatureStructure each : fs.getElements()) {
                this.buildTree(each, remRoot, ts, offset, onlyRules);
            }
        }
        this.mergeInlinedRuleBlockNodesOfChildren(matchNode);
    }

    private void processRuleElementMatches(DebugRuleElementMatches fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        FSArray inlinedActionBlocks;
        RuleElementMatchesNode remsNode = new RuleElementMatchesNode(parent, (FeatureStructure)fs, ts);
        parent.addChild(remsNode);
        if (fs.getMatches() != null) {
            for (FeatureStructure each : fs.getMatches()) {
                this.buildTree(each, remsNode, ts, offset, onlyRules);
            }
        }
        if ((inlinedActionBlocks = fs.getInlinedActionBlocks()) != null) {
            InlinedRootNode inlinedRootNode = new InlinedRootNode(remsNode, ts);
            remsNode.setInlined(inlinedRootNode);
            for (FeatureStructure each : inlinedActionBlocks) {
                if (!(each instanceof DebugInlinedBlock)) continue;
                this.buildInlinedBlock(false, (DebugInlinedBlock)each, inlinedRootNode, ts, offset, onlyRules);
            }
        }
        this.mergeInlinedRuleBlockNodesOfChildren(remsNode);
    }

    private void processRuleElementMatch(DebugRuleElementMatch fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        FSArray inlinedConditionBlocks;
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        RuleElementMatchNode remNode = new RuleElementMatchNode(parent, (FeatureStructure)fs, ts);
        parent.addChild(remNode);
        DebugEvaluatedCondition baseCondition = fs.getBaseCondition();
        this.buildTree((FeatureStructure)baseCondition, remNode, ts, offset, onlyRules);
        if (fs.getConditions() != null) {
            for (FeatureStructure each : fs.getConditions()) {
                this.buildTree(each, remNode, ts, offset, onlyRules);
            }
        }
        if (fs.getElements() != null) {
            for (FeatureStructure each : fs.getElements()) {
                this.buildTree(each, remNode, ts, offset, onlyRules);
            }
        }
        if ((inlinedConditionBlocks = fs.getInlinedConditionBlocks()) != null) {
            InlinedRootNode inlinedRootNode = new InlinedRootNode(remNode, ts);
            remNode.setInlined(inlinedRootNode);
            for (FeatureStructure each : inlinedConditionBlocks) {
                if (!(each instanceof DebugInlinedBlock)) continue;
                this.buildInlinedBlock(true, (DebugInlinedBlock)each, inlinedRootNode, ts, offset, onlyRules);
            }
        }
        this.mergeInlinedRuleBlockNodesOfChildren(remNode);
    }

    private void processEvaluatedCondition(DebugEvaluatedCondition fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        ConditionNode condNode = new ConditionNode(parent, (FeatureStructure)fs, ts);
        parent.addChild(condNode);
        if (fs.getConditions() != null) {
            for (FeatureStructure each : fs.getConditions()) {
                this.buildTree(each, condNode, ts, offset, onlyRules);
            }
        }
    }

    private void mergeInlinedRuleBlockNodesOfChildren(ExplainAbstractTreeNode parent) {
        ArrayList<IExplainTreeNode> list = new ArrayList<IExplainTreeNode>();
        for (IExplainTreeNode each : parent.getChildren()) {
            this.collectInlinedBlockNodes(each, list);
        }
        InlinedRootNode inlinedRootNode = parent.getInlined();
        if (inlinedRootNode == null && !list.isEmpty()) {
            inlinedRootNode = new InlinedRootNode(parent, parent.getTypeSystem());
            parent.setInlined(inlinedRootNode);
        }
        if (inlinedRootNode != null) {
            for (IExplainTreeNode each : list) {
                if (inlinedRootNode.getChildren().contains(each)) continue;
                inlinedRootNode.addChild(each);
            }
        }
    }

    private void collectInlinedBlockNodes(IExplainTreeNode node, List<IExplainTreeNode> result) {
        if (node.getInlined() != null && node.getInlined().hasChildren()) {
            result.addAll(node.getInlined().getChildren());
            return;
        }
        List<IExplainTreeNode> children = node.getChildren();
        for (IExplainTreeNode each : children) {
            this.collectInlinedBlockNodes(each, result);
        }
    }

    private void prune(IExplainTreeNode node) {
        if (node == null) {
            return;
        }
        List<IExplainTreeNode> children = node.getChildren();
        IExplainTreeNode parent = node.getParent();
        for (IExplainTreeNode each : new ArrayList<IExplainTreeNode>(children)) {
            this.prune(each);
        }
        if (!(node instanceof ApplyRootNode || node instanceof BlockApplyNode || node instanceof ConditionNode)) {
            if (node instanceof FailedRootNode) {
                if (!node.hasChildren()) {
                    parent.removeChild(node);
                }
            } else if (node instanceof MatchedRootNode) {
                if (!node.hasChildren()) {
                    parent.removeChild(node);
                }
            } else if (node instanceof RuleApplyNode) {
                if (!node.hasChildren()) {
                    parent.removeChild(node);
                }
            } else if (node instanceof RuleElementMatchesNode || node instanceof RuleElementMatchNode || node instanceof RuleElementRootNode || node instanceof RuleMatchNode) {
                // empty if block
            }
        }
    }
}

