/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerIndex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

final class TinkerIndex<T extends Element>
extends AbstractTinkerIndex<T> {
    protected Map<String, Map<Object, Set<T>>> index = new ConcurrentHashMap<String, Map<Object, Set<T>>>();

    public TinkerIndex(TinkerGraph graph, Class<T> indexClass) {
        super(graph, indexClass);
    }

    protected void put(String key, Object value, T element) {
        Object indexableValue;
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            this.index.putIfAbsent(key, new ConcurrentHashMap());
            keyMap = this.index.get(key);
        }
        if (null == (objects = keyMap.get(indexableValue = TinkerIndex.indexable(value)))) {
            keyMap.putIfAbsent(indexableValue, ConcurrentHashMap.newKeySet());
            objects = keyMap.get(indexableValue);
        }
        objects.add(element);
    }

    @Override
    public List<T> get(String key, Object value) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return Collections.emptyList();
        }
        Set<T> set = keyMap.get(TinkerIndex.indexable(value));
        if (null == set) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(set);
    }

    @Override
    public long count(String key, Object value) {
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null == keyMap) {
            return 0L;
        }
        Set<T> set = keyMap.get(TinkerIndex.indexable(value));
        if (null == set) {
            return 0L;
        }
        return set.size();
    }

    @Override
    public void remove(String key, Object value, T element) {
        Set<T> objects;
        Map<Object, Set<T>> keyMap = this.index.get(key);
        if (null != keyMap && null != (objects = keyMap.get(TinkerIndex.indexable(value)))) {
            objects.remove(element);
            if (objects.size() == 0) {
                keyMap.remove(value);
            }
        }
    }

    @Override
    public void removeElement(T element) {
        if (this.indexClass.isAssignableFrom(element.getClass())) {
            for (Map<Object, Set<T>> map : this.index.values()) {
                for (Set<T> set : map.values()) {
                    set.remove(element);
                }
            }
        }
    }

    @Override
    public void autoUpdate(String key, Object newValue, Object oldValue, T element) {
        if (this.indexedKeys.contains(key)) {
            this.remove(key, oldValue, element);
            this.put(key, newValue, element);
        }
    }

    @Override
    public void createKeyIndex(String key) {
        if (null == key) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"key");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("The key for the index cannot be an empty string");
        }
        if (this.indexedKeys.contains(key)) {
            return;
        }
        this.indexedKeys.add(key);
        (Vertex.class.isAssignableFrom(this.indexClass) ? ((TinkerGraph)this.graph).vertices.values().parallelStream() : ((TinkerGraph)this.graph).edges.values().parallelStream()).map(e -> new Object[]{e.property(key), e}).filter(a -> ((Property)a[0]).isPresent()).forEach(a -> this.put(key, ((Property)a[0]).value(), (Element)a[1]));
    }

    @Override
    public void dropKeyIndex(String key) {
        if (this.index.containsKey(key)) {
            this.index.remove(key).clear();
        }
        this.indexedKeys.remove(key);
    }
}

