/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management.observation;

import io.micrometer.observation.transport.ReceiverContext;
import java.nio.charset.StandardCharsets;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public class MessageReceiverContext
extends ReceiverContext<Message<?>> {
    private final Message<?> message;
    private final String handlerName;

    public MessageReceiverContext(Message<?> message, @Nullable String handlerName) {
        super(MessageReceiverContext::getHeader);
        this.message = message;
        this.handlerName = handlerName != null ? handlerName : "unknown";
    }

    public Message<?> getCarrier() {
        return this.message;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    @Nullable
    private static String getHeader(Message<?> message, String key) {
        String string;
        Object value = message.getHeaders().get((Object)key);
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            string = new String(bytes, StandardCharsets.UTF_8);
        } else {
            string = value != null ? value.toString() : null;
        }
        return string;
    }
}

