/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.SessionStoreFactory;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.logout.handler.DefaultSessionLogoutHandler;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.profile.factory.ProfileManagerFactory;
import org.pac4j.core.util.CommonHelper;

public class Config {
    private static final SessionLogoutHandler DEFAULT_SESSION_LOGOUT_HANDLER = new DefaultSessionLogoutHandler();
    private Clients clients = new Clients();
    private Map<String, Authorizer> authorizers = new HashMap<String, Authorizer>();
    private Map<String, Matcher> matchers = new HashMap<String, Matcher>();
    private SecurityLogic securityLogic;
    private CallbackLogic callbackLogic;
    private LogoutLogic logoutLogic;
    private WebContextFactory webContextFactory;
    private SessionStoreFactory sessionStoreFactory;
    private ProfileManagerFactory profileManagerFactory;
    private HttpActionAdapter httpActionAdapter;
    private SessionLogoutHandler sessionLogoutHandler = DEFAULT_SESSION_LOGOUT_HANDLER;

    public Config() {
    }

    public Config(Client client) {
        this.clients = new Clients(client);
        this.setConfigForClients();
    }

    protected void setConfigForClients() {
        if (this.clients != null) {
            for (Client client : this.clients.getClients()) {
                ((BaseClient)client).setConfig(this);
            }
        }
    }

    public Config(Clients clients) {
        this.clients = clients;
        this.setConfigForClients();
    }

    public Config(List<Client> clients) {
        this.clients = new Clients(clients);
        this.setConfigForClients();
    }

    public Config(Client ... clients) {
        this.clients = new Clients(clients);
        this.setConfigForClients();
    }

    public Config(String callbackUrl, Client client) {
        this.clients = new Clients(callbackUrl, client);
        this.setConfigForClients();
    }

    public Config(String callbackUrl, Client ... clients) {
        this.clients = new Clients(callbackUrl, clients);
        this.setConfigForClients();
    }

    public Config(String callbackUrl, List<Client> clients) {
        this.clients = new Clients(callbackUrl, clients);
        this.setConfigForClients();
    }

    public Config(Map<String, Authorizer> authorizers) {
        this.setAuthorizers(authorizers);
    }

    public Config(Clients clients, Map<String, Authorizer> authorizers) {
        this.clients = clients;
        this.setConfigForClients();
        this.setAuthorizers(authorizers);
    }

    public Config(Client client, Map<String, Authorizer> authorizers) {
        this.clients = new Clients(client);
        this.setConfigForClients();
        this.setAuthorizers(authorizers);
    }

    public Config(Map<String, Authorizer> authorizers, Client ... clients) {
        this.clients = new Clients(clients);
        this.setConfigForClients();
        this.setAuthorizers(authorizers);
    }

    public Config(String callbackUrl, Map<String, Authorizer> authorizers, Client ... clients) {
        this.clients = new Clients(callbackUrl, clients);
        this.setConfigForClients();
        this.setAuthorizers(authorizers);
    }

    public Config(String callbackUrl, Client client, Map<String, Authorizer> authorizers) {
        this.clients = new Clients(callbackUrl, client);
        this.setConfigForClients();
        this.setAuthorizers(authorizers);
    }

    public Config setClients(Clients clients) {
        this.clients = clients;
        this.setConfigForClients();
        return this;
    }

    public Config addClient(Client client) {
        this.clients.addClient(client);
        this.setConfigForClients();
        return this;
    }

    public Config setAuthorizer(Authorizer authorizer) {
        CommonHelper.assertNotNull("authorizer", authorizer);
        this.authorizers.put(authorizer.getClass().getSimpleName(), authorizer);
        return this;
    }

    public Config setAuthorizers(Map<String, Authorizer> authorizers) {
        CommonHelper.assertNotNull("authorizers", authorizers);
        this.authorizers = authorizers;
        return this;
    }

    public Config addAuthorizer(String name, Authorizer authorizer) {
        this.authorizers.put(name, authorizer);
        return this;
    }

    public Config setMatcher(Matcher matcher) {
        CommonHelper.assertNotNull("matcher", matcher);
        this.matchers.put(matcher.getClass().getSimpleName(), matcher);
        return this;
    }

    public Config setMatchers(Map<String, Matcher> matchers) {
        CommonHelper.assertNotNull("matchers", matchers);
        this.matchers = matchers;
        return this;
    }

    public Config addMatcher(String name, Matcher matcher) {
        this.matchers.put(name, matcher);
        return this;
    }

    public Config setSecurityLogic(SecurityLogic securityLogic) {
        this.securityLogic = securityLogic;
        return this;
    }

    public Config setCallbackLogic(CallbackLogic callbackLogic) {
        this.callbackLogic = callbackLogic;
        return this;
    }

    public Config setLogoutLogic(LogoutLogic logoutLogic) {
        this.logoutLogic = logoutLogic;
        return this;
    }

    public Config setWebContextFactory(WebContextFactory webContextFactory) {
        this.webContextFactory = webContextFactory;
        return this;
    }

    public Config setSessionStoreFactory(SessionStoreFactory sessionStoreFactory) {
        this.sessionStoreFactory = sessionStoreFactory;
        return this;
    }

    public Config setProfileManagerFactory(ProfileManagerFactory profileManagerFactory) {
        this.profileManagerFactory = profileManagerFactory;
        return this;
    }

    public Config setHttpActionAdapter(HttpActionAdapter httpActionAdapter) {
        this.httpActionAdapter = httpActionAdapter;
        return this;
    }

    public void setSecurityLogicIfUndefined(SecurityLogic securityLogic) {
        if (this.securityLogic == null) {
            this.setSecurityLogic(securityLogic);
        }
    }

    public void setCallbackLogicIfUndefined(CallbackLogic callbackLogic) {
        if (this.callbackLogic == null) {
            this.setCallbackLogic(callbackLogic);
        }
    }

    public void setLogoutLogicIfUndefined(LogoutLogic logoutLogic) {
        if (this.logoutLogic == null) {
            this.setLogoutLogic(logoutLogic);
        }
    }

    public void setWebContextFactoryIfUndefined(WebContextFactory webContextFactory) {
        if (this.webContextFactory == null) {
            this.setWebContextFactory(webContextFactory);
        }
    }

    public void setSessionStoreFactoryIfUndefined(SessionStoreFactory sessionStoreFactory) {
        if (this.sessionStoreFactory == null) {
            this.setSessionStoreFactory(sessionStoreFactory);
        }
    }

    public void setProfileManagerFactoryIfUndefined(ProfileManagerFactory profileManagerFactory) {
        if (this.profileManagerFactory == null) {
            this.setProfileManagerFactory(profileManagerFactory);
        }
    }

    public void setHttpActionAdapterIfUndefined(HttpActionAdapter httpActionAdapter) {
        if (this.httpActionAdapter == null) {
            this.setHttpActionAdapter(httpActionAdapter);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config setSessionLogoutHandler(SessionLogoutHandler sessionLogoutHandler) {
        this.sessionLogoutHandler = sessionLogoutHandler;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Clients getClients() {
        return this.clients;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Authorizer> getAuthorizers() {
        return this.authorizers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Matcher> getMatchers() {
        return this.matchers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SecurityLogic getSecurityLogic() {
        return this.securityLogic;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CallbackLogic getCallbackLogic() {
        return this.callbackLogic;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogoutLogic getLogoutLogic() {
        return this.logoutLogic;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WebContextFactory getWebContextFactory() {
        return this.webContextFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SessionStoreFactory getSessionStoreFactory() {
        return this.sessionStoreFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProfileManagerFactory getProfileManagerFactory() {
        return this.profileManagerFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HttpActionAdapter getHttpActionAdapter() {
        return this.httpActionAdapter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SessionLogoutHandler getSessionLogoutHandler() {
        return this.sessionLogoutHandler;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withClients(Clients clients) {
        return this.clients == clients ? this : new Config(clients, this.authorizers, this.matchers, this.securityLogic, this.callbackLogic, this.logoutLogic, this.webContextFactory, this.sessionStoreFactory, this.profileManagerFactory, this.httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withAuthorizers(Map<String, Authorizer> authorizers) {
        return this.authorizers == authorizers ? this : new Config(this.clients, authorizers, this.matchers, this.securityLogic, this.callbackLogic, this.logoutLogic, this.webContextFactory, this.sessionStoreFactory, this.profileManagerFactory, this.httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withMatchers(Map<String, Matcher> matchers) {
        return this.matchers == matchers ? this : new Config(this.clients, this.authorizers, matchers, this.securityLogic, this.callbackLogic, this.logoutLogic, this.webContextFactory, this.sessionStoreFactory, this.profileManagerFactory, this.httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withSecurityLogic(SecurityLogic securityLogic) {
        return this.securityLogic == securityLogic ? this : new Config(this.clients, this.authorizers, this.matchers, securityLogic, this.callbackLogic, this.logoutLogic, this.webContextFactory, this.sessionStoreFactory, this.profileManagerFactory, this.httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withCallbackLogic(CallbackLogic callbackLogic) {
        return this.callbackLogic == callbackLogic ? this : new Config(this.clients, this.authorizers, this.matchers, this.securityLogic, callbackLogic, this.logoutLogic, this.webContextFactory, this.sessionStoreFactory, this.profileManagerFactory, this.httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withLogoutLogic(LogoutLogic logoutLogic) {
        return this.logoutLogic == logoutLogic ? this : new Config(this.clients, this.authorizers, this.matchers, this.securityLogic, this.callbackLogic, logoutLogic, this.webContextFactory, this.sessionStoreFactory, this.profileManagerFactory, this.httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withWebContextFactory(WebContextFactory webContextFactory) {
        return this.webContextFactory == webContextFactory ? this : new Config(this.clients, this.authorizers, this.matchers, this.securityLogic, this.callbackLogic, this.logoutLogic, webContextFactory, this.sessionStoreFactory, this.profileManagerFactory, this.httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withSessionStoreFactory(SessionStoreFactory sessionStoreFactory) {
        return this.sessionStoreFactory == sessionStoreFactory ? this : new Config(this.clients, this.authorizers, this.matchers, this.securityLogic, this.callbackLogic, this.logoutLogic, this.webContextFactory, sessionStoreFactory, this.profileManagerFactory, this.httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withProfileManagerFactory(ProfileManagerFactory profileManagerFactory) {
        return this.profileManagerFactory == profileManagerFactory ? this : new Config(this.clients, this.authorizers, this.matchers, this.securityLogic, this.callbackLogic, this.logoutLogic, this.webContextFactory, this.sessionStoreFactory, profileManagerFactory, this.httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withHttpActionAdapter(HttpActionAdapter httpActionAdapter) {
        return this.httpActionAdapter == httpActionAdapter ? this : new Config(this.clients, this.authorizers, this.matchers, this.securityLogic, this.callbackLogic, this.logoutLogic, this.webContextFactory, this.sessionStoreFactory, this.profileManagerFactory, httpActionAdapter, this.sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config withSessionLogoutHandler(SessionLogoutHandler sessionLogoutHandler) {
        return this.sessionLogoutHandler == sessionLogoutHandler ? this : new Config(this.clients, this.authorizers, this.matchers, this.securityLogic, this.callbackLogic, this.logoutLogic, this.webContextFactory, this.sessionStoreFactory, this.profileManagerFactory, this.httpActionAdapter, sessionLogoutHandler);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config(Clients clients, Map<String, Authorizer> authorizers, Map<String, Matcher> matchers, SecurityLogic securityLogic, CallbackLogic callbackLogic, LogoutLogic logoutLogic, WebContextFactory webContextFactory, SessionStoreFactory sessionStoreFactory, ProfileManagerFactory profileManagerFactory, HttpActionAdapter httpActionAdapter, SessionLogoutHandler sessionLogoutHandler) {
        this.clients = clients;
        this.authorizers = authorizers;
        this.matchers = matchers;
        this.securityLogic = securityLogic;
        this.callbackLogic = callbackLogic;
        this.logoutLogic = logoutLogic;
        this.webContextFactory = webContextFactory;
        this.sessionStoreFactory = sessionStoreFactory;
        this.profileManagerFactory = profileManagerFactory;
        this.httpActionAdapter = httpActionAdapter;
        this.sessionLogoutHandler = sessionLogoutHandler;
    }
}

