/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultGroupProvisioningManager
implements GroupProvisioningManager {
    protected final GroupWorkflowAdapter gwfAdapter;
    protected final PropagationManager propagationManager;
    protected final PropagationTaskExecutor taskExecutor;
    protected final GroupDataBinder groupDataBinder;
    protected final GroupDAO groupDAO;

    public DefaultGroupProvisioningManager(GroupWorkflowAdapter gwfAdapter, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, GroupDataBinder groupDataBinder, GroupDAO groupDAO) {
        this.gwfAdapter = gwfAdapter;
        this.propagationManager = propagationManager;
        this.taskExecutor = taskExecutor;
        this.groupDataBinder = groupDataBinder;
        this.groupDAO = groupDAO;
    }

    public ProvisioningManager.ProvisioningResult<String> create(GroupCR groupCR, boolean nullPriorityAsync, String creator, String context) {
        WorkflowResult created = this.gwfAdapter.create(groupCR, creator, context);
        List tasks = this.propagationManager.getCreateTasks(AnyTypeKind.GROUP, (String)created.getResult(), null, created.getPropByRes(), Set.of());
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, nullPriorityAsync, creator);
        return new ProvisioningManager.ProvisioningResult((Object)((String)created.getResult()), propagationReporter.getStatuses());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ProvisioningManager.ProvisioningResult<String> create(GroupCR groupCR, Map<String, String> groupOwnerMap, Set<String> excludedResources, boolean nullPriorityAsync, String creator, String context) {
        WorkflowResult created = this.gwfAdapter.create(groupCR, creator, context);
        groupCR.getPlainAttr("").ifPresent(groupOwner -> groupOwnerMap.put((String)created.getResult(), (String)groupOwner.getValues().getFirst()));
        List tasks = this.propagationManager.getCreateTasks(AnyTypeKind.GROUP, (String)created.getResult(), null, created.getPropByRes(), excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, nullPriorityAsync, creator);
        return new ProvisioningManager.ProvisioningResult((Object)((String)created.getResult()), propagationReporter.getStatuses());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ProvisioningManager.ProvisioningResult<GroupUR> update(GroupUR groupUR, Set<String> excludedResources, boolean nullPriorityAsync, String updater, String context) {
        List beforeAttrs = this.propagationManager.prepareAttrs(AnyTypeKind.GROUP, groupUR.getKey(), null, List.of(), null, excludedResources);
        WorkflowResult updated = this.gwfAdapter.update(groupUR, updater, context);
        List tasks = this.propagationManager.setAttributeDeltas(this.propagationManager.getUpdateTasks((AnyUR)updated.getResult(), AnyTypeKind.GROUP, ((GroupUR)updated.getResult()).getKey(), List.of(), null, updated.getPropByRes(), null, excludedResources), beforeAttrs);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, nullPriorityAsync, updater);
        return new ProvisioningManager.ProvisioningResult((Object)((GroupUR)updated.getResult()), propagationReporter.getStatuses());
    }

    public List<PropagationStatus> delete(String key, boolean nullPriorityAsync, String eraser, String context) {
        return this.delete(key, Set.of(), nullPriorityAsync, eraser, context);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PropagationStatus> delete(String key, Set<String> excludedResources, boolean nullPriorityAsync, String eraser, String context) {
        ArrayList taskInfos = new ArrayList();
        this.groupDataBinder.findUsersWithTransitiveResources(key).forEach((anyKey, propByRes) -> taskInfos.addAll(this.propagationManager.getDeleteTasks(AnyTypeKind.USER, anyKey, propByRes, null, (Collection)excludedResources)));
        this.groupDataBinder.findAnyObjectsWithTransitiveResources(key).forEach((anyKey, propByRes) -> taskInfos.addAll(this.propagationManager.getDeleteTasks(AnyTypeKind.ANY_OBJECT, anyKey, propByRes, null, (Collection)excludedResources)));
        taskInfos.addAll(this.propagationManager.getDeleteTasks(AnyTypeKind.GROUP, key, null, null, null));
        PropagationReporter propagationReporter = this.taskExecutor.execute(taskInfos, nullPriorityAsync, eraser);
        this.gwfAdapter.delete(key, eraser, context);
        return propagationReporter.getStatuses();
    }

    public String link(GroupUR groupUR, String updater, String context) {
        return ((GroupUR)this.gwfAdapter.update(groupUR, updater, context).getResult()).getKey();
    }

    public String unlink(GroupUR groupUR, String updater, String context) {
        return ((GroupUR)this.gwfAdapter.update(groupUR, updater, context).getResult()).getKey();
    }

    public List<PropagationStatus> provision(String key, Collection<String> resources, boolean nullPriorityAsync, String executor) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, resources);
        List taskInfos = this.propagationManager.getUpdateTasks(null, AnyTypeKind.GROUP, key, List.of(), null, propByRes, null, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, executor);
        return propagationReporter.getStatuses();
    }

    public List<PropagationStatus> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync, String executor) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, resources);
        List taskInfos = this.propagationManager.getDeleteTasks(AnyTypeKind.GROUP, key, propByRes, null, this.groupDAO.findAllResourceKeys(key).stream().filter(resource -> !resources.contains(resource)).toList());
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, executor);
        return propagationReporter.getStatuses();
    }
}

