/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.KeyException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.DataExpiredException;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.shared.security.DataSealerKeyStrategy;
import org.opensaml.storage.AbstractMapBackedStorageService;
import org.opensaml.storage.MutableStorageRecord;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.opensaml.storage.impl.client.ClientStorageServiceStore;
import org.opensaml.storage.impl.client.JSONClientStorageServiceStore;
import org.slf4j.Logger;

public class ClientStorageService
extends AbstractMapBackedStorageService
implements Filter,
StorageCapabilities {
    @Nonnull
    protected static final String LOCK_ATTRIBUTE = "org.opensaml.storage.impl.client.ClientStorageService.lock";
    @Nonnull
    protected static final String STORAGE_ATTRIBUTE = "org.opensaml.storage.impl.client.ClientStorageService.store";
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_STORAGE_NAME = "shib_idp_client_ss";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientStorageService.class);
    @Nonnull
    @NotEmpty
    private Map<ClientStorageSource, Integer> capabilityMap = new HashMap<ClientStorageSource, Integer>(2);
    @NonnullAfterInit
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    @NotEmpty
    private String storageName = "shib_idp_client_ss";
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nullable
    private DataSealerKeyStrategy keyStrategy;
    @Nonnull
    private ClientStorageServiceStore.Factory storeFactory;

    public ClientStorageService() {
        this.capabilityMap.put(ClientStorageSource.COOKIE, 4096);
        this.capabilityMap.put(ClientStorageSource.HTML_LOCAL_STORAGE, 0x100000);
        this.storeFactory = new JSONClientStorageServiceStore.JSONClientStorageServiceStoreFactory();
    }

    public synchronized void setCleanupInterval(@Nullable Duration interval) {
        super.setCleanupInterval(Duration.ZERO);
    }

    public void setCapabilityMap(@Nonnull Map<ClientStorageSource, Integer> map) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(map, (String)"Capability map cannot be null");
        for (Map.Entry<ClientStorageSource, Integer> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.capabilityMap.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isServerSide() {
        return false;
    }

    public boolean isClustered() {
        return true;
    }

    public void setHttpServletRequestSupplier(@Nonnull NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpServletRequestSupplier = (NonnullSupplier)Constraint.isNotNull(requestSupplier, (String)"HttpServletRequest cannot be null");
    }

    @Nonnull
    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.httpServletRequestSupplier.get();
    }

    @NonnullAfterInit
    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public void setCookieManager(@Nonnull CookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    @Nonnull
    @NotEmpty
    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.storageName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Storage name cannot be null or empty");
    }

    @NonnullAfterInit
    public DataSealer getDataSealer() {
        return this.dataSealer;
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.checkSetterPreconditions();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setKeyStrategy(@Nullable DataSealerKeyStrategy strategy) {
        this.checkSetterPreconditions();
        this.keyStrategy = strategy;
    }

    public void setClientStorageServiceStoreFactory(@Nonnull ClientStorageServiceStore.Factory factory) {
        this.checkSetterPreconditions();
        this.storeFactory = (ClientStorageServiceStore.Factory)Constraint.isNotNull((Object)factory, (String)"Factory cannot be null");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    public int getContextSize() {
        try {
            return this.capabilityMap.get((Object)this.getSource());
        }
        catch (IOException e) {
            return this.capabilityMap.get((Object)ClientStorageSource.COOKIE);
        }
    }

    public int getKeySize() {
        return this.getContextSize();
    }

    public long getValueSize() {
        return this.getContextSize();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpServletRequestSupplier == null) {
            throw new ComponentInitializationException("HttpServletRequestSupplier must be set");
        }
        if (this.dataSealer == null || this.cookieManager == null) {
            throw new ComponentInitializationException("DataSealer and CookieManager must be set");
        }
    }

    @Nullable
    protected TimerTask getCleanupTask() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected ReadWriteLock getLock() {
        HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.getHttpServletRequest().getSession(), (String)"HttpSession cannot be null");
        Object lock = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.lock." + this.storageName);
        if (lock == null || !(lock instanceof ReadWriteLock)) {
            ClientStorageService clientStorageService = this;
            synchronized (clientStorageService) {
                lock = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.lock." + this.storageName);
                if (lock == null) {
                    lock = new ReentrantReadWriteLock();
                    session.setAttribute("org.opensaml.storage.impl.client.ClientStorageService.lock." + this.storageName, lock);
                }
            }
        }
        return (ReadWriteLock)lock;
    }

    @Nonnull
    @Live
    protected Map<String, Map<String, MutableStorageRecord<?>>> getContextMap() throws IOException {
        try {
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.getHttpServletRequest().getSession(), (String)"HttpSession cannot be null");
            Object store = Constraint.isNotNull((Object)session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName), (String)"Storage object was not present in session");
            return ((ClientStorageServiceStore)store).getContextMap();
        }
        catch (ConstraintViolationException e) {
            throw new IOException(e);
        }
    }

    protected void setDirty() throws IOException {
        try {
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.getHttpServletRequest().getSession(), (String)"HttpSession cannot be null");
            Object store = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName);
            if (store != null && store instanceof ClientStorageServiceStore) {
                ((ClientStorageServiceStore)store).setDirty(true);
            }
        }
        catch (ConstraintViolationException e) {
            throw new IOException(e);
        }
    }

    @Nullable
    ClientStorageSource getSource() throws IOException {
        Lock lock = this.getLock().readLock();
        try {
            lock.lock();
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.getHttpServletRequest().getSession(), (String)"HttpSession cannot be null");
            Object object = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName);
            if (object != null && object instanceof ClientStorageServiceStore) {
                ClientStorageSource clientStorageSource = ((ClientStorageServiceStore)object).getSource();
                return clientStorageSource;
            }
            ClientStorageSource clientStorageSource = ClientStorageSource.COOKIE;
            return clientStorageSource;
        }
        catch (ConstraintViolationException e) {
            throw new IOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    boolean isLoaded() throws IOException {
        Lock lock = this.getLock().readLock();
        try {
            lock.lock();
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.getHttpServletRequest().getSession(), (String)"HttpSession cannot be null");
            boolean bl = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName) instanceof ClientStorageServiceStore;
            return bl;
        }
        catch (ConstraintViolationException e) {
            throw new IOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(@Nullable @NotEmpty String raw, @Nonnull ClientStorageSource source) {
        ClientStorageServiceStore storageObject;
        if (raw != null) {
            this.log.trace("{} Loading storage state into session", (Object)this.getLogPrefix());
            try {
                StringBuffer keyAliasUsed = new StringBuffer();
                String decrypted = this.dataSealer.unwrap(raw, keyAliasUsed);
                this.log.trace("{} Data after decryption: {}", (Object)this.getLogPrefix(), (Object)decrypted);
                storageObject = this.storeFactory.load(decrypted, source);
                if (this.keyStrategy != null) {
                    try {
                        if (!this.keyStrategy.getDefaultKeyRecord().name().equals(keyAliasUsed.toString())) {
                            storageObject.setDirty(true);
                        }
                    }
                    catch (KeyException e) {
                        this.log.error("{} Exception while accessing default key during stale key detection", (Object)this.getLogPrefix(), (Object)e);
                    }
                }
                this.log.debug("{} Successfully decrypted and loaded storage state from client", (Object)this.getLogPrefix());
            }
            catch (DataExpiredException e) {
                this.log.debug("{} Secured data or key has expired", (Object)this.getLogPrefix());
                storageObject = this.storeFactory.load(null, source);
                storageObject.setDirty(true);
            }
            catch (DataSealerException e) {
                this.log.error("{} Exception unwrapping secured data", (Object)this.getLogPrefix(), (Object)e);
                storageObject = this.storeFactory.load(null, source);
                storageObject.setDirty(true);
            }
        } else {
            this.log.trace("{} Initializing empty storage state into session", (Object)this.getLogPrefix());
            storageObject = this.storeFactory.load(null, source);
        }
        Lock lock = this.getLock().writeLock();
        try {
            lock.lock();
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.getHttpServletRequest().getSession(), (String)"HttpSession cannot be null");
            session.setAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName, (Object)storageObject);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ClientStorageServiceOperation save() {
        this.log.trace("{} Preserving storage state from session", (Object)this.getLogPrefix());
        Lock lock = this.getLock().writeLock();
        try {
            lock.lock();
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.getHttpServletRequest().getSession(), (String)"HttpSession cannot be null");
            Object object = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName);
            if (object == null || !(object instanceof ClientStorageServiceStore)) {
                this.log.error("{} No storage object found in session", (Object)this.getLogPrefix());
                ClientStorageServiceOperation clientStorageServiceOperation = null;
                return clientStorageServiceOperation;
            }
            ClientStorageServiceOperation clientStorageServiceOperation = ((ClientStorageServiceStore)object).save(this);
            return clientStorageServiceOperation;
        }
        finally {
            lock.unlock();
        }
    }

    @Nonnull
    @NotEmpty
    String getLogPrefix() {
        return "StorageService " + this.getId() + ":";
    }

    public static enum ClientStorageSource {
        COOKIE,
        HTML_LOCAL_STORAGE;

    }
}

