/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.condition;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.kafka.test.EmbeddedKafkaBrokerFactory;
import org.springframework.kafka.test.context.EmbeddedKafka;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.Assert;

public class EmbeddedKafkaCondition
implements ExecutionCondition,
AfterAllCallback,
ParameterResolver {
    private static final String EMBEDDED_BROKER = "embedded-kafka";
    private static final ThreadLocal<EmbeddedKafkaBroker> BROKERS = new ThreadLocal();

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (BROKERS.get() == null) {
            return false;
        }
        return EmbeddedKafkaBroker.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        EmbeddedKafkaBroker broker = this.getBrokerFromStore(context);
        Assert.state((broker != null ? 1 : 0) != 0, (String)"Could not find embedded broker instance");
        return broker;
    }

    public void afterAll(ExtensionContext context) {
        EmbeddedKafkaBroker broker = BROKERS.get();
        if (broker != null) {
            broker.destroy();
            BROKERS.remove();
        }
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        EmbeddedKafkaBroker broker;
        EmbeddedKafka embedded;
        Optional element = context.getElement();
        if (element.isPresent() && !this.springTestContext((AnnotatedElement)element.get()) && (embedded = (EmbeddedKafka)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)((AnnotatedElement)element.get()), EmbeddedKafka.class)) != null && (broker = this.getBrokerFromStore(context)) == null) {
            broker = this.createBroker(embedded);
            BROKERS.set(broker);
            this.getStore(context).put((Object)EMBEDDED_BROKER, (Object)broker);
        }
        return ConditionEvaluationResult.enabled((String)"");
    }

    private boolean springTestContext(AnnotatedElement annotatedElement) {
        return AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)annotatedElement, ExtendWith.class).stream().map(ExtendWith::value).flatMap(Arrays::stream).anyMatch(SpringExtension.class::isAssignableFrom);
    }

    private EmbeddedKafkaBroker createBroker(EmbeddedKafka embedded) {
        return EmbeddedKafkaBrokerFactory.create(embedded);
    }

    private EmbeddedKafkaBroker getBrokerFromStore(ExtensionContext context) {
        EmbeddedKafkaBroker embeddedKafkaBrokerFromParentStore = (EmbeddedKafkaBroker)this.getParentStore(context).get((Object)EMBEDDED_BROKER, EmbeddedKafkaBroker.class);
        return embeddedKafkaBrokerFromParentStore == null ? (EmbeddedKafkaBroker)this.getStore(context).get((Object)EMBEDDED_BROKER, EmbeddedKafkaBroker.class) : embeddedKafkaBrokerFromParentStore;
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
    }

    private ExtensionContext.Store getParentStore(ExtensionContext context) {
        ExtensionContext parent = (ExtensionContext)context.getParent().get();
        return parent.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), parent}));
    }

    public static EmbeddedKafkaBroker getBroker() {
        return BROKERS.get();
    }
}

