/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.java.propagation.PriorityPropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.AsyncTaskExecutor;

public class InstrumentedPriorityPropagationTaskExecutor
extends PriorityPropagationTaskExecutor {
    protected final MeterRegistry meterRegistry;

    public InstrumentedPriorityPropagationTaskExecutor(ConnectorManager connectorManager, ConnObjectUtils connObjectUtils, TaskDAO taskDAO, ExternalResourceDAO resourceDAO, PlainSchemaDAO plainSchemaDAO, NotificationManager notificationManager, AuditManager auditManager, TaskDataBinder taskDataBinder, AnyUtilsFactory anyUtilsFactory, TaskUtilsFactory taskUtilsFactory, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, ApplicationEventPublisher publisher, AsyncTaskExecutor taskExecutor, MeterRegistry meterRegistry) {
        super(connectorManager, connObjectUtils, taskDAO, resourceDAO, plainSchemaDAO, notificationManager, auditManager, taskDataBinder, anyUtilsFactory, taskUtilsFactory, outboundMatcher, validator, publisher, taskExecutor);
        this.meterRegistry = meterRegistry;
    }

    public PropagationReporter execute(Collection<PropagationTaskInfo> taskInfos, boolean nullPriorityAsync, String executor) {
        PropagationReporter reporter = super.execute(taskInfos, nullPriorityAsync, executor);
        reporter.getStatuses().forEach(status -> Counter.builder((String)("syncope.propagation." + status.getStatus().name().toLowerCase() + ".count")).description("The total number of propagations with status " + status.getStatus().name()).tag("resource", status.getResource()).register(this.meterRegistry).increment());
        return reporter;
    }
}

