/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.TabStopAlignEnum;

public class PptxParagraphHelper
extends BaseHelper {
    private static final String HORIZONTAL_ALIGN_LEFT = "left";
    private static final String HORIZONTAL_ALIGN_RIGHT = "right";
    private static final String HORIZONTAL_ALIGN_CENTER = "center";
    private static final String HORIZONTAL_ALIGN_BOTH = "both";
    private static final String TAB_STOP_ALIGN_LEFT = "left";
    private static final String TAB_STOP_ALIGN_RIGHT = "right";
    private static final String TAB_STOP_ALIGN_CENTER = "center";
    protected static final int LINE_SPACING_FACTOR = 240;

    public PptxParagraphHelper(JasperReportsContext jasperReportsContext, Writer writer) {
        super(jasperReportsContext, writer);
    }

    public void exportProps(JRStyle style) {
        this.exportPropsHeader(null, style.getParagraph());
        this.exportAlignment(PptxParagraphHelper.getHorizontalTextAlign(style.getOwnHorizontalTextAlign()));
        this.exportTabStops(style.getParagraph());
        this.exportLineSpacing(style.getParagraph());
        this.exportPropsFooter();
    }

    public void exportProps(JRPrintText text) {
        JRStyle baseStyle = text.getDefaultStyleProvider().getStyleResolver().getBaseStyle(text);
        this.exportPropsHeader(baseStyle == null ? null : baseStyle.getName(), text.getParagraph());
        this.exportAlignment(PptxParagraphHelper.getHorizontalTextAlign(text.getOwnHorizontalTextAlign()));
        this.exportTabStops(text.getParagraph());
        this.exportLineSpacing(text.getParagraph());
        this.exportPropsFooter();
    }

    public void exportProps(JRPrintImage image) {
        JRStyle baseStyle = image.getDefaultStyleProvider().getStyleResolver().getBaseStyle(image);
        this.exportPropsHeader(baseStyle == null ? null : baseStyle.getName(), null);
        this.exportAlignment(PptxParagraphHelper.getHorizontalImageAlign(image.getOwnHorizontalImageAlign()));
        this.write("   <a:spacing a:lineRule=\"auto\" a:line=\"240\" a:after=\"0\" a:before=\"0\"/>\n");
        this.exportPropsFooter();
    }

    private void exportPropsHeader(String styleNameReference, JRParagraph paragraph) {
        this.write("      <a:pPr>\n");
        if (styleNameReference != null) {
            this.write("        <a:pStyle a:val=\"" + styleNameReference + "\"/>\n");
        }
        if (paragraph != null) {
            this.write("      <a:ind");
            if (paragraph.getOwnFirstLineIndent() != null) {
                this.write(" a:firstLine=\"" + LengthUtil.twip(paragraph.getOwnFirstLineIndent().intValue()) + "\"");
            }
            if (paragraph.getOwnLeftIndent() != null) {
                this.write(" a:left=\"" + LengthUtil.twip(paragraph.getOwnLeftIndent().intValue()) + "\"");
            }
            if (paragraph.getOwnRightIndent() != null) {
                this.write(" a:right=\"" + LengthUtil.twip(paragraph.getOwnRightIndent().intValue()) + "\"");
            }
            this.write("/>\n");
        }
    }

    private void exportAlignment(String horizontalAlignment) {
        if (horizontalAlignment != null) {
            this.write("   <a:jc a:val=\"" + horizontalAlignment + "\" />\n");
        }
    }

    private void exportTabStops(JRParagraph paragraph) {
        TabStop[] tabStops = paragraph.getTabStops();
        if (tabStops != null && tabStops.length > 0) {
            this.write("   <a:tabs>\n");
            for (int i = 0; i < tabStops.length; ++i) {
                TabStop tabStop = tabStops[i];
                this.write("   <a:tab a:pos=\"" + LengthUtil.twip(tabStop.getPosition()) + "\" a:val=\"" + PptxParagraphHelper.getTabStopAlignment(TabStopAlignEnum.getValueOrDefault(tabStop.getAlignment())) + "\"/>\n");
            }
            this.write("   </a:tabs>\n");
        }
    }

    private void exportLineSpacing(JRParagraph paragraph) {
        if (paragraph.getOwnLineSpacing() != null || paragraph.getOwnLineSpacingSize() != null || paragraph.getOwnSpacingBefore() != null || paragraph.getOwnSpacingAfter() != null) {
            String lineSpacing;
            String lineRule;
            switch (paragraph.getLineSpacing()) {
                case AT_LEAST: {
                    lineRule = "atLeast";
                    lineSpacing = String.valueOf(LengthUtil.twip(paragraph.getLineSpacingSize().floatValue()));
                    break;
                }
                case FIXED: {
                    lineRule = "exact";
                    lineSpacing = String.valueOf(LengthUtil.twip(paragraph.getLineSpacingSize().floatValue()));
                    break;
                }
                case PROPORTIONAL: {
                    lineRule = "auto";
                    lineSpacing = String.valueOf((int)(paragraph.getLineSpacingSize().floatValue() * 240.0f));
                    break;
                }
                case DOUBLE: {
                    lineRule = "auto";
                    lineSpacing = String.valueOf(480);
                    break;
                }
                case ONE_AND_HALF: {
                    lineRule = "auto";
                    lineSpacing = String.valueOf(360);
                    break;
                }
                default: {
                    lineRule = "auto";
                    lineSpacing = String.valueOf(240);
                }
            }
            this.write("   <a:spacing a:lineRule=\"" + lineRule + "\" a:line=\"" + lineSpacing + "\"");
            this.write(" a:after=\"" + LengthUtil.twip(paragraph.getSpacingAfter().intValue()) + "\"");
            this.write(" a:before=\"" + LengthUtil.twip(paragraph.getSpacingBefore().intValue()) + "\"/>\n");
        }
    }

    private void exportPropsFooter() {
        this.write("      </a:pPr>\n");
    }

    public void exportEmptyParagraph() {
        this.write("  <a:txBody>\n");
        this.write("    <a:bodyPr/>\n");
        this.write("    <a:lstStyle/>\n");
        this.write("     <a:p><a:pPr><a:defRPr sz=\"100\"/>");
        this.write("     </a:pPr>");
        this.write("</a:p>\n");
        this.write("  </a:txBody>\n");
    }

    public static String getHorizontalTextAlign(HorizontalTextAlignEnum horizontalAlignment) {
        if (horizontalAlignment != null) {
            switch (horizontalAlignment) {
                case RIGHT: {
                    return "right";
                }
                case CENTER: {
                    return "center";
                }
                case JUSTIFIED: {
                    return HORIZONTAL_ALIGN_BOTH;
                }
            }
            return "left";
        }
        return null;
    }

    public static String getHorizontalImageAlign(HorizontalImageAlignEnum horizontalAlignment) {
        if (horizontalAlignment != null) {
            switch (horizontalAlignment) {
                case RIGHT: {
                    return "right";
                }
                case CENTER: {
                    return "center";
                }
            }
            return "left";
        }
        return null;
    }

    public static String getTabStopAlignment(TabStopAlignEnum alignment) {
        switch (alignment) {
            case RIGHT: {
                return "right";
            }
            case CENTER: {
                return "center";
            }
        }
        return "left";
    }
}

