/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal;

import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.internal.util.StringUtils;
import net.sf.oval.localization.value.MessageValueFormatter;

public final class MessageRenderer {
    public static String renderMessage(String messageKey, Map<String, ?> messageValues) {
        String message = Validator.getMessageResolver().getMessage(messageKey);
        if (message == null) {
            message = messageKey;
        }
        if (message.indexOf(123) == -1) {
            return message;
        }
        if (messageValues != null && messageValues.size() > 0) {
            MessageValueFormatter formatter = Validator.getMessageValueFormatter();
            for (Map.Entry<String, ?> entry : messageValues.entrySet()) {
                message = StringUtils.replaceAll(message, "{" + entry.getKey() + "}", formatter.format(entry.getValue()));
            }
        }
        return message;
    }

    public static String renderMessage(String messageKey, String messageValueName, String messageValue) {
        String message = Validator.getMessageResolver().getMessage(messageKey);
        if (message == null) {
            message = messageKey;
        }
        if (message.indexOf(123) == -1) {
            return message;
        }
        message = StringUtils.replaceAll(message, "{" + messageValueName + "}", messageValue);
        return message;
    }

    private MessageRenderer() {
    }
}

