/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Range;

public class RangeCheck
extends AbstractAnnotationCheck<Range> {
    private static final long serialVersionUID = 1L;
    private double min = Double.MIN_VALUE;
    private double max = Double.MAX_VALUE;

    @Override
    public void configure(Range constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMax(constraintAnnotation.max());
        this.setMin(constraintAnnotation.min());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("max", Double.toString(this.max));
        messageVariables.put("min", Double.toString(this.min));
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Number) {
            double doubleValue = ((Number)valueToValidate).doubleValue();
            return doubleValue >= this.min && doubleValue <= this.max;
        }
        String stringValue = valueToValidate.toString();
        try {
            double doubleValue = Double.parseDouble(stringValue);
            return doubleValue >= this.min && doubleValue <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setMax(double max) {
        this.max = max;
        this.requireMessageVariablesRecreation();
    }

    public void setMin(double min) {
        this.min = min;
        this.requireMessageVariablesRecreation();
    }
}

