/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.storm.daemon.nimbus.TopologyResources;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ISchedulingState;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;

public class User {
    private final Set<TopologyDetails> unsuccess = new HashSet<TopologyDetails>();
    private final double cpuGuarantee;
    private final double memoryGuarantee;
    private final Map<String, Double> genericGuarantee;
    private String userId;

    public User(String userId) {
        this(userId, 0.0, 0.0, Collections.emptyMap());
    }

    public User(String userId, Map<String, Double> resourcePool) {
        this(userId, resourcePool == null ? 0.0 : resourcePool.getOrDefault("cpu", 0.0), resourcePool == null ? 0.0 : resourcePool.getOrDefault("memory", 0.0), resourcePool == null ? Collections.emptyMap() : User.extractGenericResourceEntries(resourcePool));
    }

    private User(String userId, double cpuGuarantee, double memoryGuarantee, Map<String, Double> genericGuarantee) {
        this.userId = userId;
        this.cpuGuarantee = cpuGuarantee;
        this.memoryGuarantee = memoryGuarantee;
        this.genericGuarantee = genericGuarantee;
    }

    public String getId() {
        return this.userId;
    }

    public TreeSet<TopologyDetails> getRunningTopologies(ISchedulingState cluster) {
        TreeSet<TopologyDetails> ret = new TreeSet<TopologyDetails>(new PQsortByPriorityAndSubmittionTime());
        for (TopologyDetails td : cluster.getTopologies().getTopologiesOwnedBy(this.userId)) {
            if (cluster.needsSchedulingRas(td)) continue;
            ret.add(td);
        }
        return ret;
    }

    public TreeSet<TopologyDetails> getPendingTopologies(ISchedulingState cluster) {
        TreeSet<TopologyDetails> ret = new TreeSet<TopologyDetails>(new PQsortByPriorityAndSubmittionTime());
        for (TopologyDetails td : cluster.getTopologies().getTopologiesOwnedBy(this.userId)) {
            if (!cluster.needsSchedulingRas(td) || this.unsuccess.contains(td)) continue;
            ret.add(td);
        }
        return ret;
    }

    public void markTopoUnsuccess(TopologyDetails topo, Cluster cluster, String msg) {
        this.unsuccess.add(topo);
        if (cluster != null) {
            if (msg == null) {
                msg = "Scheduling Attempted but topology is invalid";
            }
            cluster.setStatus(topo.getId(), msg);
        }
    }

    public void markTopoUnsuccess(TopologyDetails topo) {
        this.markTopoUnsuccess(topo, null, null);
    }

    public double getResourcePoolAverageUtilization(ISchedulingState cluster) {
        double cpuResourcePoolUtilization = this.getCpuResourcePoolUtilization(cluster);
        double memoryResourcePoolUtilization = this.getMemoryResourcePoolUtilization(cluster);
        return cpuResourcePoolUtilization / 2.0 + memoryResourcePoolUtilization / 2.0;
    }

    public double getCpuResourcePoolUtilization(ISchedulingState cluster) {
        if (this.cpuGuarantee == 0.0) {
            return Double.MAX_VALUE;
        }
        return this.getCpuResourceUsedByUser(cluster) / this.cpuGuarantee;
    }

    public double getMemoryResourcePoolUtilization(ISchedulingState cluster) {
        if (this.memoryGuarantee == 0.0) {
            return Double.MAX_VALUE;
        }
        return this.getMemoryResourceUsedByUser(cluster) / this.memoryGuarantee;
    }

    public double getMemoryResourceRequest(ISchedulingState cluster) {
        double sum = 0.0;
        HashSet<TopologyDetails> topologyDetailsSet = new HashSet<TopologyDetails>(cluster.getTopologies().getTopologiesOwnedBy(this.userId));
        for (TopologyDetails topo : topologyDetailsSet) {
            sum += topo.getTotalRequestedMemOnHeap() + topo.getTotalRequestedMemOffHeap();
        }
        return sum;
    }

    public double getCpuResourceRequest(ISchedulingState cluster) {
        double sum = 0.0;
        HashSet<TopologyDetails> topologyDetailsSet = new HashSet<TopologyDetails>(cluster.getTopologies().getTopologiesOwnedBy(this.userId));
        for (TopologyDetails topo : topologyDetailsSet) {
            sum += topo.getTotalRequestedCpu();
        }
        return sum;
    }

    public double getCpuResourceUsedByUser(ISchedulingState cluster) {
        double sum = 0.0;
        for (TopologyDetails td : cluster.getTopologies().getTopologiesOwnedBy(this.userId)) {
            SchedulerAssignment assignment = cluster.getAssignmentById(td.getId());
            if (assignment == null) continue;
            TopologyResources tr = new TopologyResources(td, assignment);
            sum += tr.getAssignedCpu();
        }
        return sum;
    }

    public double getMemoryResourceUsedByUser(ISchedulingState cluster) {
        double sum = 0.0;
        for (TopologyDetails td : cluster.getTopologies().getTopologiesOwnedBy(this.userId)) {
            SchedulerAssignment assignment = cluster.getAssignmentById(td.getId());
            if (assignment == null) continue;
            TopologyResources tr = new TopologyResources(td, assignment);
            sum += tr.getAssignedMemOnHeap() + tr.getAssignedMemOffHeap();
        }
        return sum;
    }

    public double getMemoryResourceGuaranteed() {
        return this.memoryGuarantee;
    }

    public double getCpuResourceGuaranteed() {
        return this.cpuGuarantee;
    }

    public Map<String, Double> getGenericGuaranteed() {
        return this.genericGuarantee;
    }

    public TopologyDetails getNextTopologyToSchedule(ISchedulingState cluster) {
        Iterator<TopologyDetails> iterator = this.getPendingTopologies(cluster).iterator();
        if (iterator.hasNext()) {
            TopologyDetails topo = iterator.next();
            return topo;
        }
        return null;
    }

    public boolean hasTopologyNeedSchedule(ISchedulingState cluster) {
        return !this.getPendingTopologies(cluster).isEmpty();
    }

    public TopologyDetails getRunningTopologyWithLowestPriority(ISchedulingState cluster) {
        TreeSet<TopologyDetails> queue = this.getRunningTopologies(cluster);
        if (queue.isEmpty()) {
            return null;
        }
        return queue.last();
    }

    private static Map<String, Double> extractGenericResourceEntries(Map<String, Double> resourcePool) {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : resourcePool.entrySet()) {
            String key = entry.getKey();
            Double value = entry.getValue();
            if (key == null || key.equals("cpu") || key.equals("memory")) continue;
            ret.put(key, value);
        }
        return ret;
    }

    public int hashCode() {
        return this.userId.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof User)) {
            return false;
        }
        return this.getId().equals(((User)other).getId());
    }

    public String toString() {
        return this.userId;
    }

    static class PQsortByPriorityAndSubmittionTime
    implements Comparator<TopologyDetails> {
        PQsortByPriorityAndSubmittionTime() {
        }

        @Override
        public int compare(TopologyDetails topo1, TopologyDetails topo2) {
            if (topo1.getTopologyPriority() > topo2.getTopologyPriority()) {
                return 1;
            }
            if (topo1.getTopologyPriority() < topo2.getTopologyPriority()) {
                return -1;
            }
            if (topo1.getUpTime() > topo2.getUpTime()) {
                return -1;
            }
            if (topo1.getUpTime() < topo2.getUpTime()) {
                return 1;
            }
            return topo1.getId().compareTo(topo2.getId());
        }
    }
}

