/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker.codec;

import java.io.IOException;
import java.util.List;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.generated.HBServerMessageType;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.storm.utils.Utils;

public class ThriftDecoder
extends ByteToMessageDecoder {
    private static final int INTEGER_SIZE = 4;
    private final int maxLength;

    public ThriftDecoder(int maxLengthBytes) {
        this.maxLength = maxLengthBytes;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf buf, List<Object> out) throws Exception {
        long available = buf.readableBytes();
        if (available < 4L) {
            return;
        }
        buf.markReaderIndex();
        int thriftLen = buf.readInt();
        if (thriftLen < 0 || thriftLen > this.maxLength) {
            throw new IOException("Thrift message of length " + Integer.toString(thriftLen) + " is greater than allowed " + this.maxLength + " or less than 0.");
        }
        if ((available -= 4L) < (long)thriftLen) {
            buf.resetReaderIndex();
            return;
        }
        byte[] serialized = new byte[thriftLen];
        buf.readBytes(serialized, 0, thriftLen);
        HBMessage m = Utils.thriftDeserialize(HBMessage.class, serialized);
        if (m.get_type() == HBServerMessageType.CONTROL_MESSAGE) {
            ControlMessage cm = ControlMessage.read(m.get_data().get_message_blob());
            out.add(cm);
        } else if (m.get_type() == HBServerMessageType.SASL_MESSAGE_TOKEN) {
            SaslMessageToken sm = SaslMessageToken.read(m.get_data().get_message_blob());
            out.add(sm);
        } else {
            out.add(m);
        }
    }
}

