/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.request.SlingRequestListener;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.servlets.ErrorHandler;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.servlets.resolver.api.IgnoredServletResourcePredicate;
import org.apache.sling.servlets.resolver.internal.HandleErrorSlingHttpServletResponse;
import org.apache.sling.servlets.resolver.internal.PathBasedServletAcceptor;
import org.apache.sling.servlets.resolver.internal.ResolverConfig;
import org.apache.sling.servlets.resolver.internal.ScriptResource;
import org.apache.sling.servlets.resolver.internal.ScriptResourceResolver;
import org.apache.sling.servlets.resolver.internal.defaults.DefaultErrorHandlerServlet;
import org.apache.sling.servlets.resolver.internal.defaults.DefaultServlet;
import org.apache.sling.servlets.resolver.internal.helper.AbstractResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.LocationCollector;
import org.apache.sling.servlets.resolver.internal.helper.NamedScriptResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.ResourceCollector;
import org.apache.sling.servlets.resolver.internal.resolution.ResolutionCache;
import org.apache.sling.servlets.resolver.internal.resource.MergingServletResourceProvider;
import org.apache.sling.servlets.resolver.internal.resource.SlingServletConfig;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.servlets.resolver.SlingServletResolver", service={ServletResolver.class, ErrorHandler.class, SlingRequestListener.class}, property={"service.description=Apache Sling Servlet Resolver and Error Handler", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=ResolverConfig.class)
public class SlingServletResolver
implements ServletResolver,
SlingRequestListener,
ErrorHandler {
    private static final String SERVICE_USER = "scripts";
    public static final Logger LOGGER = LoggerFactory.getLogger(SlingServletResolver.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(target="(|(subServiceName=scripts)(!(subServiceName=*)))")
    private ServiceUserMapped scriptServiceUserMapped;
    @Reference
    private ResolutionCache resolutionCache;
    @Reference(target="(name=org.apache.sling)")
    private ServletContext servletContext;
    private AtomicReference<Servlet> defaultServlet = new AtomicReference();
    private AtomicReference<Servlet> fallbackErrorServlet = new AtomicReference();
    private AtomicReference<ResourceResolver> sharedScriptResolver = new AtomicReference();
    private final ThreadLocal<ResourceResolver> perThreadScriptResolver = new ThreadLocal();
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile IgnoredServletResourcePredicate ignoredResourcePredicate;
    private AtomicReference<String[]> executionPaths = new AtomicReference();
    private AtomicReference<String[]> defaultExtensions = new AtomicReference();
    private boolean useResourceCaching;
    private final PathBasedServletAcceptor pathBasedServletAcceptor = new PathBasedServletAcceptor();
    private static final Servlet forbiddenPathServlet = new HttpServlet(){
        private static final long serialVersionUID = 1L;

        public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.sendError(403);
        }
    };
    private ServiceTracker<MergingServletResourceProvider, MergingServletResourceProvider> tracker;

    public Servlet resolveServlet(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        RequestProgressTracker progressTracker = request.getRequestProgressTracker();
        String timerName = "resolveServlet(" + resource.getPath() + ")";
        progressTracker.startTimer(timerName);
        String resourceType = resource.getResourceType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for resource {}", (Object)resource);
        }
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        Servlet servlet = null;
        if (resourceType.length() > 0) {
            servlet = this.resolveServletInternal(request, null, resourceType, scriptResolver);
        }
        if (servlet == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No specific servlet found, trying default");
            }
            servlet = this.getDefaultServlet();
        }
        progressTracker.logTimer(timerName, "Using servlet {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Servlet {} found for resource={}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)resource);
        }
        return servlet;
    }

    public Servlet resolveServlet(Resource resource, String scriptName) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for resource {} with script name {}", (Object)resource, (Object)scriptName);
        }
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        Servlet servlet = this.resolveServletInternal(null, resource, scriptName, scriptResolver);
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for resource {} and script name {}", new Object[]{RequestUtil.getServletName((Servlet)servlet), resource, scriptName});
            } else {
                LOGGER.debug("No servlet found for resource {} and script name {}", (Object)resource, (Object)scriptName);
            }
        }
        return servlet;
    }

    public Servlet resolveServlet(ResourceResolver resolver, String scriptName) {
        if (resolver == null) {
            throw new IllegalArgumentException("Resource resolver must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for for script name {}", (Object)scriptName);
        }
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        Servlet servlet = this.resolveServletInternal(null, null, scriptName, scriptResolver);
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for script name {}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)scriptName);
            } else {
                LOGGER.debug("No servlet found for script name {}", (Object)scriptName);
            }
        }
        return servlet;
    }

    private Servlet getServlet(Resource scriptResource) {
        if (scriptResource == null) {
            return null;
        }
        if (scriptResource.getResourceResolver() == this.sharedScriptResolver || "sling/bundle/resource".equals(scriptResource.getResourceSuperType())) {
            return (Servlet)scriptResource.adaptTo(Servlet.class);
        }
        return new ScriptResource(scriptResource, this.perThreadScriptResolver::get, this.sharedScriptResolver.get()).adaptTo(Servlet.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(int status, String message, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (request.getAttribute("javax.servlet.error.request_uri") != null) {
            LOGGER.error("handleError: Recursive invocation. Not further handling status {}({})", (Object)status, (Object)message);
            return;
        }
        RequestProgressTracker progressTracker = request.getRequestProgressTracker();
        String timerName = "handleError:status=" + status;
        progressTracker.startTimer(timerName);
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        try {
            Resource resource = this.getErrorResource(request);
            String extension = request.getRequestPathInfo().getExtension();
            ResourceCollector locationUtil = new ResourceCollector(String.valueOf(status), "sling/servlet/errorhandler", resource, extension, this.executionPaths.get(), this.useResourceCaching);
            Servlet servlet = this.getServletInternal(locationUtil, request, scriptResolver);
            if (servlet == null) {
                servlet = this.getDefaultErrorServlet(request, resource, scriptResolver);
            }
            request.setAttribute("javax.servlet.error.status_code", (Object)status);
            request.setAttribute("javax.servlet.error.message", (Object)message);
            Object servletName = request.getAttribute("sling.core.current.servletName");
            if (servletName instanceof String) {
                request.setAttribute("javax.servlet.error.servlet_name", servletName);
            }
            progressTracker.logTimer(timerName, "Using handler {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
            this.handleError(servlet, request, response);
        }
        finally {
            progressTracker.logTimer(timerName, "Error handler finished", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Throwable throwable, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (request.getAttribute("javax.servlet.error.request_uri") != null) {
            LOGGER.error("handleError: Recursive invocation. Not further handling Throwable:", throwable);
            return;
        }
        RequestProgressTracker progressTracker = request.getRequestProgressTracker();
        String timerName = "handleError:throwable=" + throwable.getClass().getName();
        progressTracker.startTimer(timerName);
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        try {
            Servlet servlet = null;
            Resource resource = this.getErrorResource(request);
            for (Class<?> tClass = throwable.getClass(); servlet == null && tClass != Object.class; tClass = tClass.getSuperclass()) {
                String extension = request.getRequestPathInfo().getExtension();
                ResourceCollector locationUtil = new ResourceCollector(tClass.getSimpleName(), "sling/servlet/errorhandler", resource, extension, this.executionPaths.get(), this.useResourceCaching);
                servlet = this.getServletInternal(locationUtil, request, scriptResolver);
            }
            if (servlet == null) {
                servlet = this.getDefaultErrorServlet(request, resource, scriptResolver);
            }
            request.setAttribute("javax.servlet.error.exception", (Object)throwable);
            request.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
            request.setAttribute("javax.servlet.error.message", (Object)throwable.getMessage());
            progressTracker.logTimer(timerName, "Using handler {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
            this.handleError(servlet, request, response);
        }
        finally {
            progressTracker.logTimer(timerName, "Error handler finished", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceResolver getScriptResourceResolver() {
        ResourceResolver scriptResolver = this.perThreadScriptResolver.get();
        if (scriptResolver == null) {
            AtomicReference<ResourceResolver> atomicReference = this.sharedScriptResolver;
            synchronized (atomicReference) {
                this.invalidateCache(this.sharedScriptResolver.get());
                this.sharedScriptResolver.get().refresh();
            }
            scriptResolver = this.sharedScriptResolver.get();
        }
        return scriptResolver;
    }

    public void onEvent(SlingRequestEvent event) {
        ResourceResolver resolver;
        if (event.getType() == SlingRequestEvent.EventType.EVENT_INIT) {
            try {
                ResourceResolver clone = this.sharedScriptResolver.get().clone(null);
                this.perThreadScriptResolver.set(clone);
            }
            catch (LoginException e) {
                LOGGER.error("Unable to create new script resolver clone", (Throwable)e);
            }
        } else if (event.getType() == SlingRequestEvent.EventType.EVENT_DESTROY && (resolver = this.perThreadScriptResolver.get()) != null) {
            this.perThreadScriptResolver.remove();
            resolver.close();
        }
    }

    private Resource getErrorResource(SlingHttpServletRequest request) {
        Resource res = request.getResource();
        if (res == null) {
            res = new SyntheticResource(request.getResourceResolver(), request.getPathInfo(), "sling/servlet/errorhandler");
        }
        return res;
    }

    private boolean ignoreResource(@NotNull Resource r) {
        boolean result;
        boolean bl = result = r != null && this.ignoredResourcePredicate != null && this.ignoredResourcePredicate.test(r);
        if (result && LOGGER.isDebugEnabled()) {
            LOGGER.debug("IgnoredResourcePredicate causes Resource to be ignored: {}", (Object)r.getPath());
        }
        return result;
    }

    private Servlet resolveServletInternal(SlingHttpServletRequest request, Resource resource, String scriptNameOrResourceType, ResourceResolver resolver) {
        AbstractResourceCollector locationUtil;
        Servlet servlet = null;
        if (SlingServletResolver.isInvalidPath(scriptNameOrResourceType)) {
            if (request != null) {
                request.getRequestProgressTracker().log("Will not look for a servlet at {0} as it contains more than two consecutive dots", new Object[]{scriptNameOrResourceType});
            }
            return null;
        }
        if (scriptNameOrResourceType.charAt(0) == '/') {
            String scriptPath = ResourceUtil.normalize((String)scriptNameOrResourceType);
            if (scriptPath != null && SlingServletResolver.isPathAllowed(scriptPath, this.executionPaths.get())) {
                Resource res = AbstractResourceCollector.getResourceOrNull(resolver, scriptPath, this.useResourceCaching);
                Servlet servlet2 = servlet = this.ignoreResource(res) ? null : this.getServlet(res);
                if (servlet != null && !this.pathBasedServletAcceptor.accept(request, servlet)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Servlet {} rejected by {} returning FORBIDDEN status", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)this.pathBasedServletAcceptor.getClass().getSimpleName());
                    }
                    servlet = forbiddenPathServlet;
                } else if (servlet != null && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Servlet {} found using absolute resource type {}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)scriptNameOrResourceType);
                }
            } else if (request != null) {
                request.getRequestProgressTracker().log("Will not look for a servlet at {0} as it is not in the list of allowed paths", new Object[]{scriptNameOrResourceType});
            }
        }
        if (servlet == null && (servlet = this.getServletInternal(locationUtil = request != null ? ResourceCollector.create(request, this.executionPaths.get(), this.defaultExtensions.get(), this.useResourceCaching) : NamedScriptResourceCollector.create(scriptNameOrResourceType, resource, this.executionPaths.get(), this.useResourceCaching), request, resolver)) != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("getServletInternal returns servlet {}", (Object)RequestUtil.getServletName((Servlet)servlet));
        }
        return servlet;
    }

    private Servlet getServletInternal(AbstractResourceCollector locationUtil, SlingHttpServletRequest request, ResourceResolver resolver) {
        ResolutionCache localCache = this.resolutionCache;
        Servlet scriptServlet = localCache.get(locationUtil);
        if (scriptServlet != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using cached servlet {}", (Object)RequestUtil.getServletName((Servlet)scriptServlet));
            }
            return scriptServlet;
        }
        Collection<Resource> candidates = locationUtil.getServlets(resolver, localCache.getScriptEngineExtensions());
        candidates.removeIf(r -> this.ignoreResource((Resource)r));
        if (LOGGER.isDebugEnabled()) {
            if (candidates.isEmpty()) {
                LOGGER.debug("No servlet candidates found");
            } else {
                LOGGER.debug("Ordered list of servlet candidates follows");
                for (Resource candidateResource : candidates) {
                    LOGGER.debug("Servlet candidate: {}", (Object)candidateResource.getPath());
                }
            }
        }
        boolean hasOptingServlet = false;
        for (Resource candidateResource : candidates) {
            LOGGER.debug("Checking if candidate resource {} adapts to servlet and accepts request", (Object)candidateResource.getPath());
            Servlet candidate = this.getServlet(candidateResource);
            if (candidate != null) {
                boolean servletAcceptsRequest;
                boolean isOptingServlet = candidate instanceof OptingServlet;
                boolean bl = servletAcceptsRequest = !isOptingServlet || request != null && ((OptingServlet)candidate).accepts(request);
                if (servletAcceptsRequest) {
                    if (!hasOptingServlet && !isOptingServlet) {
                        localCache.put(locationUtil, candidate);
                    }
                    LOGGER.debug("Using servlet provided by candidate resource {}", (Object)candidateResource.getPath());
                    return candidate;
                }
                if (isOptingServlet) {
                    hasOptingServlet = true;
                }
                LOGGER.debug("Candidate {} does not accept request, ignored", (Object)candidateResource.getPath());
                continue;
            }
            LOGGER.debug("Candidate {} does not adapt to a servlet, ignored", (Object)candidateResource.getPath());
        }
        return null;
    }

    private Servlet getDefaultServlet() {
        Object servlet = this.defaultServlet.get();
        if (servlet == null) {
            try {
                servlet = new DefaultServlet();
                servlet.init((ServletConfig)new SlingServletConfig(this.servletContext, null, "Apache Sling Core Default Servlet"));
                this.defaultServlet.set((Servlet)servlet);
            }
            catch (ServletException se) {
                LOGGER.error("Failed to initialize default servlet", (Throwable)se);
            }
        }
        return servlet;
    }

    private Servlet getDefaultErrorServlet(SlingHttpServletRequest request, Resource resource, ResourceResolver resolver) {
        String extension = request.getRequestPathInfo().getExtension();
        ResourceCollector locationUtil = new ResourceCollector("default", "sling/servlet/errorhandler", resource, extension, this.executionPaths.get(), this.useResourceCaching);
        Servlet servlet = this.getServletInternal(locationUtil, request, resolver);
        if (servlet != null) {
            return servlet;
        }
        Object fallbackServlet = this.fallbackErrorServlet.get();
        if (fallbackServlet == null) {
            try {
                fallbackServlet = new DefaultErrorHandlerServlet();
                fallbackServlet.init((ServletConfig)new SlingServletConfig(this.servletContext, null, "Sling (Ad Hoc) Default Error Handler Servlet"));
                this.fallbackErrorServlet.set((Servlet)fallbackServlet);
            }
            catch (ServletException se) {
                LOGGER.error("Failed to initialize error servlet", (Throwable)se);
            }
        }
        return fallbackServlet;
    }

    private void handleError(Servlet errorHandler, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
        if (request.getAttribute("javax.servlet.error.servlet_name") == null) {
            request.setAttribute("javax.servlet.error.servlet_name", (Object)errorHandler.getServletConfig().getServletName());
        }
        try {
            HandleErrorSlingHttpServletResponse wrappedResponse = new HandleErrorSlingHttpServletResponse(response);
            errorHandler.service((ServletRequest)request, (ServletResponse)wrappedResponse);
            if (wrappedResponse.isOpen()) {
                wrappedResponse.flushBuffer();
                wrappedResponse.getWriter().close();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Calling the error handler resulted in an error", t);
            LOGGER.error("Original error " + request.getAttribute("javax.servlet.error.exception_type"), (Throwable)request.getAttribute("javax.servlet.error.exception"));
            IOException x = new IOException("Error handler failed: " + t.getClass().getName());
            x.initCause(t);
            throw x;
        }
    }

    @Activate
    protected void activate(BundleContext context, ResolverConfig config) throws LoginException {
        this.tracker = new ServiceTracker(context, MergingServletResourceProvider.class, null);
        this.tracker.open();
        this.sharedScriptResolver.set((ResourceResolver)ScriptResourceResolver.wrap(this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SERVICE_USER)), () -> this.tracker.getService()));
        this.executionPaths.set(SlingServletResolver.getExecutionPaths(config.servletresolver_paths()));
        this.defaultExtensions.set(config.servletresolver_defaultExtensions());
        this.useResourceCaching = config.enable_resource_caching();
        this.getDefaultServlet();
    }

    @Modified
    protected void modified(BundleContext context, ResolverConfig config) throws LoginException {
        this.deactivate();
        this.activate(context, config);
    }

    @Deactivate
    protected void deactivate() {
        this.tracker.close();
        this.resolutionCache.flushCache();
        Servlet servlet = this.fallbackErrorServlet.get();
        if (servlet != null) {
            try {
                servlet.destroy();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.fallbackErrorServlet.set(null);
            }
        }
        if (this.sharedScriptResolver != null) {
            ResourceResolver rr = this.sharedScriptResolver.get();
            if (rr != null) {
                rr.close();
            }
            this.sharedScriptResolver.set(null);
        }
        this.executionPaths.set(null);
        this.defaultExtensions.set(null);
    }

    public static boolean isInvalidPath(String path) {
        for (int index = 0; index < path.length(); ++index) {
            int charCount = 0;
            int dotCount = 0;
            while (index < path.length() && path.charAt(index) != '/') {
                if (path.charAt(index) == '.') {
                    ++dotCount;
                }
                ++charCount;
                ++index;
            }
            if (charCount <= 2 || dotCount != charCount) continue;
            return true;
        }
        return false;
    }

    public static boolean isPathAllowed(String path, String[] executionPaths) {
        if (executionPaths == null || executionPaths.length == 0) {
            LOGGER.debug("Accepting servlet at '{}' as there are no configured execution paths.", (Object)path);
            return true;
        }
        if (path == null || path.length() == 0) {
            LOGGER.debug("Ignoring servlet with empty path.");
            return false;
        }
        for (String config : executionPaths) {
            if (config.endsWith("/")) {
                if (!path.startsWith(config)) continue;
                LOGGER.debug("Accepting servlet at '{}' as the path is prefixed with configured execution path '{}'.", (Object)path, (Object)config);
                return true;
            }
            if (!path.equals(config)) continue;
            LOGGER.debug("Accepting servlet at '{}' as the path equals configured execution path '{}'.", (Object)path, (Object)config);
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ignoring servlet at '{}' as the path is not in the configured execution paths.", (Object)path);
        }
        return false;
    }

    public static String[] getExecutionPaths(String[] paths) {
        String[] executionPaths = paths;
        if (executionPaths != null) {
            if (executionPaths.length == 0) {
                executionPaths = null;
            } else {
                boolean hasRoot = false;
                for (String path : executionPaths) {
                    if (path != null && path.length() != 0 && !path.equals("/")) continue;
                    hasRoot = true;
                    break;
                }
                if (hasRoot) {
                    executionPaths = null;
                }
            }
        }
        return executionPaths;
    }

    protected void invalidateCache(ResourceResolver r) {
        LocationCollector.clearCache(r);
        AbstractResourceCollector.clearCache(r);
    }
}

