/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogger
implements Closeable {
    Map<String, AtomicLong> metrics = new HashMap<String, AtomicLong>();
    private static final String SELF_NAME = AccessLogger.class.getName();
    private static final Logger STATISTICS_LOG = LoggerFactory.getLogger((String)"org.apache.sling.jcr.resource.AccessLogger.statistics");
    private static final Logger OPERATION_LOG = LoggerFactory.getLogger((String)"org.apache.sling.jcr.resource.AccessLogger.operation");
    private final ResourceResolver resolver;

    public static void incrementUsage(ResourceResolver resolver, String operation, String path) {
        AccessLogger.incrementUsage(resolver, operation, path, 1L);
    }

    public static void incrementUsage(Resource resource, String operation) {
        AccessLogger.incrementUsage(resource.getResourceResolver(), operation, resource.getPath(), 1L);
    }

    public static void incrementUsage(Resource resource, String operation, long count) {
        AccessLogger.incrementUsage(resource.getResourceResolver(), operation, resource.getPath(), count);
    }

    public static void incrementUsage(ResourceResolver resolver, String operation, String path, long count) {
        if (STATISTICS_LOG.isDebugEnabled()) {
            AccessLogger am = (AccessLogger)resolver.getPropertyMap().get(SELF_NAME);
            if (am == null) {
                am = new AccessLogger(resolver);
            }
            am.incrementUsage(operation, count);
        }
        if (OPERATION_LOG.isTraceEnabled()) {
            try {
                String msg = String.format("invoked %s on [%s]", operation, path);
                throw new Exception(msg);
            }
            catch (Exception e) {
                OPERATION_LOG.trace("AccessLogger recording", (Throwable)e);
            }
        }
    }

    private AccessLogger(ResourceResolver resolver) {
        this.resolver = resolver;
        resolver.getPropertyMap().put(SELF_NAME, this);
    }

    private void incrementUsage(String operation, long count) {
        AtomicLong meter = this.metrics.get(operation);
        if (meter == null) {
            this.metrics.put(operation, new AtomicLong(count));
        } else {
            meter.addAndGet(count);
        }
    }

    public String toString() {
        String values = this.metrics.keySet().stream().map(key -> key + "=" + this.metrics.get(key).get()).collect(Collectors.joining(","));
        return "AccessLogger (" + values + ")";
    }

    @Override
    public void close() {
        STATISTICS_LOG.debug("AccessLogger dump for ResourceResolver (userid={},tostring={}): {}", new Object[]{this.resolver.getUserID(), this.resolver, this});
    }
}

