/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import relocated_for_contentpackage.javax.jcr.Binary;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.Property;
import relocated_for_contentpackage.javax.jcr.PropertyType;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Value;
import relocated_for_contentpackage.javax.jcr.ValueFormatException;
import relocated_for_contentpackage.org.apache.jackrabbit.api.ReferenceBinary;
import relocated_for_contentpackage.org.apache.jackrabbit.commons.jackrabbit.SimpleReferenceBinary;
import relocated_for_contentpackage.org.apache.jackrabbit.util.Text;
import relocated_for_contentpackage.org.apache.jackrabbit.util.XMLChar;
import relocated_for_contentpackage.org.apache.jackrabbit.value.ValueHelper;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.Constants;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.ValueComparator;

public class DocViewProperty {
    public static final String BINARY_REF = "BinaryRef";
    public final String name;
    public final String[] values;
    public final boolean isMulti;
    public final int type;
    public final boolean isReferenceProperty;
    private static final Set<String> UNAMBIGOUS = new HashSet<String>();

    public DocViewProperty(String name, String[] values, boolean multi, int type) {
        this(name, values, multi, type, false);
    }

    public static DocViewProperty fromValues(String name, Value[] values, int type, boolean isMulti, boolean sort, boolean useBinaryReferences) throws RepositoryException {
        ArrayList<String> strValues = new ArrayList<String>();
        if (isMulti && sort) {
            Arrays.sort(values, ValueComparator.getInstance());
        }
        for (Value value : values) {
            strValues.add(DocViewProperty.serializeValue(value, useBinaryReferences));
        }
        boolean isBinaryRef = false;
        if (type == 2 && !((String)strValues.get(0)).isEmpty()) {
            isBinaryRef = true;
        }
        return new DocViewProperty(name, strValues.toArray(new String[0]), isMulti, type, isBinaryRef);
    }

    public static DocViewProperty fromProperty(Property prop, boolean sort, boolean useBinaryReferences) throws RepositoryException {
        boolean isMultiValue = prop.getDefinition().isMultiple();
        Value[] values = isMultiValue ? prop.getValues() : new Value[]{prop.getValue()};
        return DocViewProperty.fromValues(prop.getName(), values, prop.getType(), isMultiValue, sort, useBinaryReferences);
    }

    static String serializeValue(Value value, boolean useBinaryReferences) throws RepositoryException {
        String strValue = null;
        if (value.getType() == 2) {
            Binary bin;
            if (useBinaryReferences && (bin = value.getBinary()) instanceof ReferenceBinary) {
                strValue = ((ReferenceBinary)bin).getReference();
            }
            if (strValue == null) {
                strValue = "";
            }
        } else {
            strValue = ValueHelper.serialize(value, false);
        }
        return strValue;
    }

    public DocViewProperty(String name, String[] values, boolean multi, int type, boolean isRef) {
        this.name = name;
        this.values = values;
        this.isMulti = multi;
        if (type == 0 && ("jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name))) {
            type = 7;
        }
        this.type = type;
        if (!this.isMulti && values.length != 1) {
            throw new IllegalArgumentException("Single value property needs exactly 1 value.");
        }
        this.isReferenceProperty = isRef;
    }

    public static DocViewProperty parse(String name, String value) {
        String[] values;
        boolean isMulti = false;
        boolean isBinaryRef = false;
        int type = 0;
        int pos = 0;
        int state = 98;
        LinkedList<String> vals = null;
        StringBuilder tmp = new StringBuilder();
        int unicode = 0;
        int unicodePos = 0;
        while (pos < value.length()) {
            char c = value.charAt(pos++);
            switch (state) {
                case 98: {
                    if (c == '{') {
                        state = 116;
                        break;
                    }
                    if (c == '[') {
                        isMulti = true;
                        state = 118;
                        break;
                    }
                    if (c == '\\') {
                        state = 101;
                        break;
                    }
                    tmp.append(c);
                    state = 118;
                    break;
                }
                case 97: {
                    if (c == '[') {
                        isMulti = true;
                        state = 118;
                        break;
                    }
                    if (c == '\\') {
                        state = 101;
                        break;
                    }
                    tmp.append(c);
                    state = 118;
                    break;
                }
                case 116: {
                    if (c == '}') {
                        if (BINARY_REF.equals(tmp.toString())) {
                            type = 2;
                            isBinaryRef = true;
                        } else {
                            type = PropertyType.valueFromName(tmp.toString());
                        }
                        tmp.setLength(0);
                        state = 97;
                        break;
                    }
                    tmp.append(c);
                    break;
                }
                case 118: {
                    if (c == '\\') {
                        state = 101;
                        break;
                    }
                    if (c == ',' && isMulti) {
                        if (vals == null) {
                            vals = new LinkedList();
                        }
                        vals.add(tmp.toString());
                        tmp.setLength(0);
                        break;
                    }
                    if (c == ']' && isMulti && pos == value.length()) {
                        if (tmp.length() <= 0 && vals == null) break;
                        if (vals == null) {
                            vals = new LinkedList();
                        }
                        vals.add(tmp.toString());
                        tmp.setLength(0);
                        break;
                    }
                    tmp.append(c);
                    break;
                }
                case 101: {
                    if (c == 'u') {
                        state = 117;
                        unicode = 0;
                        unicodePos = 0;
                        break;
                    }
                    if (c == '0') {
                        state = 118;
                        if (vals != null) break;
                        vals = new LinkedList();
                        break;
                    }
                    state = 118;
                    tmp.append(c);
                    break;
                }
                case 117: {
                    unicode = (unicode << 4) + Character.digit(c, 16);
                    if (++unicodePos != 4) break;
                    tmp.appendCodePoint(unicode);
                    state = 118;
                }
            }
        }
        if (isMulti) {
            if (tmp.length() > 0) {
                if (vals == null) {
                    vals = new LinkedList<String>();
                }
                vals.add(tmp.toString());
            }
            values = vals == null ? Constants.EMPTY_STRING_ARRAY : vals.toArray(new String[vals.size()]);
        } else {
            values = new String[]{tmp.toString()};
        }
        return new DocViewProperty(name, values, isMulti, type, isBinaryRef);
    }

    public static String format(Property prop) throws RepositoryException {
        return DocViewProperty.format(prop, false, false);
    }

    public static String format(Property prop, boolean sort, boolean useBinaryReferences) throws RepositoryException {
        return DocViewProperty.fromProperty(prop, sort, useBinaryReferences).format();
    }

    String format() {
        StringBuilder attrValue = new StringBuilder();
        if (DocViewProperty.isAmbiguous(this.type, this.name)) {
            String strType = this.isReferenceProperty ? BINARY_REF : PropertyType.nameFromValue(this.type);
            attrValue.append('{').append(strType).append('}');
        }
        if (this.isMulti) {
            attrValue.append('[');
        }
        block3: for (int i = 0; i < this.values.length; ++i) {
            String value = this.values[i];
            if (this.values.length == 1 && value.length() == 0) {
                attrValue.append("\\0");
                continue;
            }
            if (i > 0) {
                attrValue.append(',');
            }
            switch (this.type) {
                case 1: 
                case 7: 
                case 8: {
                    attrValue.append(DocViewProperty.escape(value, this.isMulti));
                    continue block3;
                }
                default: {
                    attrValue.append(value);
                }
            }
        }
        if (this.isMulti) {
            attrValue.append(']');
        }
        return attrValue.toString();
    }

    @Deprecated
    protected static void escape(StringBuffer buf, String value, boolean isMulti) {
        buf.append(DocViewProperty.escape(value, isMulti));
    }

    protected static String escape(String value, boolean isMulti) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                buf.append("\\\\");
                continue;
            }
            if (c == ',' && isMulti) {
                buf.append("\\,");
                continue;
            }
            if (!(i != 0 || isMulti || c != '[' && c != '{')) {
                buf.append('\\').append(c);
                continue;
            }
            if (XMLChar.isInvalid(c)) {
                buf.append("\\u");
                buf.append(Text.hexTable[c >> 12 & 0xF]);
                buf.append(Text.hexTable[c >> 8 & 0xF]);
                buf.append(Text.hexTable[c >> 4 & 0xF]);
                buf.append(Text.hexTable[c & 0xF]);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @Deprecated
    public static boolean isAmbiguous(Property prop) throws RepositoryException {
        return DocViewProperty.isAmbiguous(prop.getType(), prop.getName());
    }

    private static boolean isAmbiguous(int type, String name) {
        return type != 1 && !UNAMBIGOUS.contains(name);
    }

    public boolean apply(Node node) throws RepositoryException {
        Value v;
        int propType;
        Property prop;
        Property property = prop = node.hasProperty(this.name) ? node.getProperty(this.name) : null;
        if (prop != null && this.isMulti != prop.getDefinition().isMultiple()) {
            prop.remove();
            prop = null;
        }
        if (prop != null && (propType = prop.getType()) != this.type && (propType != 1 || this.type != 0)) {
            prop = null;
        }
        if (this.isMulti) {
            Value[] vs;
            Value[] valueArray = vs = prop == null ? null : prop.getValues();
            if (vs != null && vs.length == this.values.length) {
                boolean modified = false;
                for (int i = 0; i < vs.length; ++i) {
                    if (vs[i].getString().equals(this.values[i])) continue;
                    modified = true;
                }
                if (!modified) {
                    return false;
                }
            }
            if (this.type == 0) {
                node.setProperty(this.name, this.values);
            } else {
                node.setProperty(this.name, this.values, this.type);
            }
            return true;
        }
        Value value = v = prop == null ? null : prop.getValue();
        if (this.type == 2) {
            if (this.isReferenceProperty) {
                Binary bin;
                SimpleReferenceBinary ref = new SimpleReferenceBinary(this.values[0]);
                Binary binary = node.getSession().getValueFactory().createValue(ref).getBinary();
                if (v != null && (bin = v.getBinary()).equals(binary)) {
                    return false;
                }
                node.setProperty(this.name, binary);
            }
            return true;
        }
        if (v == null || !v.getString().equals(this.values[0])) {
            try {
                if (this.type == 0) {
                    node.setProperty(this.name, this.values[0]);
                } else {
                    node.setProperty(this.name, this.values[0], this.type);
                }
            }
            catch (ValueFormatException e) {
                node.setProperty(this.name, this.values[0], 1);
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isMulti ? 1231 : 1237);
        result = 31 * result + (this.isReferenceProperty ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.type;
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocViewProperty other = (DocViewProperty)obj;
        if (this.isMulti != other.isMulti) {
            return false;
        }
        if (this.isReferenceProperty != other.isReferenceProperty) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    public String toString() {
        return "DocViewProperty [name=" + this.name + ", values=" + Arrays.toString(this.values) + ", isMulti=" + this.isMulti + ", type=" + this.type + ", isReferenceProperty=" + this.isReferenceProperty + "]";
    }

    static {
        UNAMBIGOUS.add("jcr:primaryType");
        UNAMBIGOUS.add("jcr:mixinTypes");
    }
}

