/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relocated_for_contentpackage.javax.jcr.NamespaceException;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.Name;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QNodeTypeDefinition;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.NodeTypeSet;

public class DefaultNodeTypeSet
implements NodeTypeSet {
    private static final Logger log = LoggerFactory.getLogger(DefaultNodeTypeSet.class);
    private String systemId;
    private Map<Name, QNodeTypeDefinition> nodeTypes = new TreeMap<Name, QNodeTypeDefinition>();
    private NamespaceMapping nsMapping = new NamespaceMapping();
    private Map<Name, QNodeTypeDefinition> removed = new TreeMap<Name, QNodeTypeDefinition>();

    public DefaultNodeTypeSet(String systemId) {
        this.systemId = systemId;
    }

    public DefaultNodeTypeSet(NodeTypeSet set) {
        this(set.getSystemId(), set.getNodeTypes().values(), set.getNamespaceMapping());
    }

    public DefaultNodeTypeSet(String systemId, Collection<QNodeTypeDefinition> nodeTypes, NamespaceMapping nsMapping) {
        this.systemId = systemId;
        for (QNodeTypeDefinition t : nodeTypes) {
            this.nodeTypes.put(t.getName(), t);
        }
        this.nsMapping = nsMapping;
    }

    public void add(NodeTypeSet set) {
        for (QNodeTypeDefinition tpl : set.getNodeTypes().values()) {
            log.trace("adding {}", (Object)tpl.getName());
            this.nodeTypes.put(tpl.getName(), tpl);
        }
        this.add(set.getNamespaceMapping());
    }

    public void add(Collection<QNodeTypeDefinition> set, NamespaceMapping nsMapping) {
        for (QNodeTypeDefinition tpl : set) {
            log.trace("adding {}", (Object)tpl.getName());
            this.nodeTypes.put(tpl.getName(), tpl);
        }
        this.add(nsMapping);
    }

    private void add(NamespaceMapping mapping) {
        for (String o : mapping.getPrefixToURIMapping().keySet()) {
            try {
                String pfx = o;
                String uri = mapping.getURI(pfx);
                this.nsMapping.setMapping(pfx, uri);
            }
            catch (NamespaceException e) {
                throw new IllegalStateException("Error while transferring mappings.", e);
            }
        }
    }

    public QNodeTypeDefinition remove(Name name) throws RepositoryException {
        QNodeTypeDefinition tpl = this.nodeTypes.remove(name);
        if (tpl != null) {
            this.removed.put(tpl.getName(), tpl);
            log.trace("removing registered {}", (Object)tpl.getName());
        }
        return tpl;
    }

    @Override
    public Map<Name, QNodeTypeDefinition> getNodeTypes() {
        return this.nodeTypes;
    }

    @Override
    public NamespaceMapping getNamespaceMapping() {
        return this.nsMapping;
    }

    public Map<Name, QNodeTypeDefinition> getRemoved() {
        return this.removed;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
}

