/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.IdConflictPolicy;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.MemoryArchive;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageExistsException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.ScopedWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import org.apache.jackrabbit.vault.packaging.impl.HollowVaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.ZipVaultPackage;
import org.apache.jackrabbit.vault.packaging.registry.DependencyReport;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.impl.DependencyReportImpl;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSInstallState;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSInstallStateCache;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageStatus;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSRegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.InstallationScope;
import org.apache.jackrabbit.vault.util.InputStreamPump;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PackageRegistry.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class FSPackageRegistry
extends AbstractPackageRegistry {
    protected static final String REPOSITORY_HOME = "repository.home";
    private static final Logger log = LoggerFactory.getLogger(FSPackageRegistry.class);
    private FSInstallStateCache stateCache;
    @Reference
    private PackageEventDispatcher dispatcher;
    private InstallationScope scope = InstallationScope.UNSCOPED;

    @Deprecated
    public FSPackageRegistry(@NotNull File homeDir) throws IOException {
        this(homeDir, InstallationScope.UNSCOPED);
    }

    @Deprecated
    public FSPackageRegistry(@NotNull File homeDir, InstallationScope scope) throws IOException {
        this(homeDir, scope, null);
    }

    @Deprecated
    public FSPackageRegistry(@NotNull File homeDir, InstallationScope scope, @Nullable AbstractPackageRegistry.SecurityConfig securityConfig) throws IOException {
        this(homeDir, scope, securityConfig, false, true, IdConflictPolicy.FAIL);
    }

    public FSPackageRegistry(@NotNull File homeDir, InstallationScope scope, @Nullable AbstractPackageRegistry.SecurityConfig securityConfig, boolean isStrict, boolean overwritePrimaryTypesOfFolders, IdConflictPolicy defaultIdConflictPolicy) throws IOException {
        super(securityConfig, isStrict, overwritePrimaryTypesOfFolders, defaultIdConflictPolicy);
        log.info("Jackrabbit Filevault FS Package Registry initialized with home location {}", (Object)homeDir.getPath());
        this.scope = scope;
        this.stateCache = new FSInstallStateCache(homeDir.toPath());
    }

    public FSPackageRegistry() throws IOException {
        super(null, false, true, IdConflictPolicy.FAIL);
    }

    @Activate
    public void activate(BundleContext context, Config config) throws IOException {
        File homeDir;
        File file = context.getProperty(REPOSITORY_HOME) != null ? (new File(config.homePath()).isAbsolute() ? new File(config.homePath()) : new File(context.getProperty(REPOSITORY_HOME) + "/" + config.homePath())) : (homeDir = context.getDataFile(config.homePath()));
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        log.info("Jackrabbit Filevault FS Package Registry initialized with home location {}", (Object)homeDir.getPath());
        this.scope = InstallationScope.valueOf(config.scope());
        this.securityConfig = new AbstractPackageRegistry.SecurityConfig(config.authIdsForHookExecution(), config.authIdsForRootInstallation());
        this.stateCache = new FSInstallStateCache(homeDir.toPath());
    }

    public void setDispatcher(@Nullable PackageEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void dispatch(@NotNull PackageEvent.Type type, @NotNull PackageId id, @Nullable PackageId[] related) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.dispatch(type, id, related);
    }

    @Override
    @Nullable
    public RegisteredPackage open(@NotNull PackageId id) throws IOException {
        FSInstallState state = this.getInstallState(id);
        return state != null ? new FSRegisteredPackage(this, state) : null;
    }

    @Override
    public boolean contains(@NotNull PackageId id) throws IOException {
        return this.getInstallState(id) != null;
    }

    @Nullable
    FSInstallState getInstallState(@NotNull PackageId id) throws IOException {
        try {
            return this.stateCache.get(id);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @NotNull
    private Path getPackageFile(@NotNull PackageId id) throws IOException {
        FSInstallState state = this.getInstallState(id);
        if (state == null) {
            return this.stateCache.getPackageFile(id);
        }
        return state.getFilePath();
    }

    @NotNull
    protected VaultPackage openPackageFile(@NotNull PackageId id) throws IOException, NoSuchPackageException {
        Path pkg = this.getPackageFile(id);
        if (Files.exists(pkg, new LinkOption[0]) && Files.size(pkg) > 0L) {
            return new ZipVaultPackage(pkg.toFile(), false, true);
        }
        FSInstallState state = this.getInstallState(id);
        if (state == null) {
            throw new NoSuchPackageException().setId(id);
        }
        return new HollowVaultPackage(state.getProperties());
    }

    @Override
    @NotNull
    public DependencyReport analyzeDependencies(@NotNull PackageId id, boolean onlyInstalled) throws IOException, NoSuchPackageException {
        LinkedList<Dependency> unresolved = new LinkedList<Dependency>();
        LinkedList<PackageId> resolved = new LinkedList<PackageId>();
        FSInstallState state = this.stateCache.get(id);
        if (state == null) {
            throw new NoSuchPackageException().setId(id);
        }
        HashSet<Dependency> allDependencies = new HashSet<Dependency>();
        allDependencies.addAll(state.getDependencies());
        for (PackageId subId : state.getSubPackages().keySet()) {
            FSInstallState subState = this.getInstallState(subId);
            allDependencies.addAll(subState.getDependencies());
        }
        for (Dependency dep : allDependencies) {
            PackageId resolvedId = this.resolve(dep, onlyInstalled);
            if (resolvedId == null) {
                unresolved.add(dep);
                continue;
            }
            resolved.add(resolvedId);
        }
        return new DependencyReportImpl(id, unresolved.toArray(new Dependency[unresolved.size()]), resolved.toArray(new PackageId[resolved.size()]));
    }

    @Override
    public PackageId resolve(Dependency dependency, boolean onlyInstalled) throws IOException {
        PackageId bestId = null;
        for (PackageId id : this.packages()) {
            if (onlyInstalled && !this.isInstalled(id) || !dependency.matches(id) || bestId != null && id.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
            bestId = id;
        }
        return bestId;
    }

    boolean isInstalled(PackageId id) throws IOException {
        FSInstallState state = this.getInstallState(id);
        if (state != null) {
            return FSPackageStatus.EXTRACTED == state.getStatus();
        }
        return false;
    }

    @Override
    @NotNull
    public PackageId register(@NotNull InputStream in, boolean replace) throws IOException, PackageExistsException {
        return this.register(in, replace, null);
    }

    @NotNull
    private PackageId register(@NotNull InputStream in, boolean replace, Dependency autoDependency) throws IOException, PackageExistsException {
        ZipVaultPackage pkg = this.upload(in, replace);
        Map<PackageId, SubPackageHandling.Option> subpackages = this.registerSubPackages(pkg, replace);
        Path pkgFile = this.getPackageFile(pkg.getId());
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        dependencies.addAll(Arrays.asList(pkg.getDependencies()));
        if (autoDependency != null) {
            dependencies.add(autoDependency);
        }
        FSInstallState state = new FSInstallState(pkg.getId(), FSPackageStatus.REGISTERED, pkgFile).withDependencies(dependencies).withSubPackages(subpackages).withFilter(pkg.getArchive().getMetaInf().getFilter()).withSize(pkg.getSize()).withProperties(pkg.getArchive().getMetaInf().getProperties()).withExternal(false);
        this.stateCache.put(pkg.getId(), state);
        return pkg.getId();
    }

    private Map<PackageId, SubPackageHandling.Option> registerSubPackages(VaultPackage pkg, boolean replace) throws IOException, PackageExistsException {
        HashMap<PackageId, SubPackageHandling.Option> subpackages = new HashMap<PackageId, SubPackageHandling.Option>();
        Archive.Entry packagesRoot = pkg.getArchive().getEntry("/jcr_root/etc/packages");
        if (packagesRoot != null) {
            boolean hasOwnContent = false;
            for (PathFilterSet root : pkg.getArchive().getMetaInf().getFilter().getFilterSets()) {
                if (Text.isDescendantOrEqual((String)"/etc/packages", (String)root.getRoot())) continue;
                log.debug("Package {}: contains content outside /etc/packages. Sub packages will have a dependency to it", (Object)pkg.getId());
                hasOwnContent = true;
            }
            Dependency autoDependency = hasOwnContent ? new Dependency(pkg.getId()) : null;
            this.registerSubPackages(pkg, packagesRoot, "/etc/packages", replace, subpackages, autoDependency);
            this.dispatch(PackageEvent.Type.EXTRACT_SUB_PACKAGES, pkg.getId(), subpackages.keySet().toArray(new PackageId[subpackages.size()]));
        }
        return subpackages;
    }

    private void registerSubPackages(VaultPackage vltPkg, Archive.Entry directory, String parentPath, boolean replace, Map<PackageId, SubPackageHandling.Option> subpackages, Dependency autoDependency) throws IOException, PackageExistsException {
        Collection<? extends Archive.Entry> files = directory.getChildren();
        for (Archive.Entry entry : files) {
            String fileName = entry.getName();
            String repoName = PlatformNameFormat.getRepositoryName(fileName);
            String repoPath = parentPath + "/" + repoName;
            if (entry.isDirectory()) {
                this.registerSubPackages(vltPkg, entry, repoPath, replace, subpackages, autoDependency);
                continue;
            }
            if (!repoPath.startsWith("/etc/packages/") || !repoPath.endsWith(".jar") && !repoPath.endsWith(".zip")) continue;
            try {
                InputStream in = vltPkg.getArchive().openInputStream(entry);
                try {
                    if (in == null) {
                        throw new IOException("Unable to open archive input stream of " + entry);
                    }
                    PackageId id = this.register(in, replace);
                    SubPackageHandling.Option option = vltPkg.getSubPackageHandling().getOption(id);
                    subpackages.put(id, option);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (PackageExistsException e) {
                log.info("Subpackage already registered, skipping subpackage extraction.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ZipVaultPackage upload(InputStream in, boolean replace) throws IOException, PackageExistsException {
        Path tempFile = Files.createTempFile("upload", ".zip", new FileAttribute[0]);
        try {
            MemoryArchive archive = new MemoryArchive(false);
            try (InputStreamPump pump = new InputStreamPump(in, archive);){
                try {
                    Files.copy(pump, tempFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    String msg = "Stream could not be read successfully.";
                    throw new IOException(msg, e);
                }
            }
            if (archive.getJcrRoot() == null) {
                String msg = "Stream is not a content package. Missing 'jcr_root'.";
                throw new IOException(msg);
            }
            MetaInf inf = archive.getMetaInf();
            PackageId pid = inf.getPackageProperties().getId();
            if (pid == null) {
                throw new IllegalArgumentException("Unable to create package. No package pid set.");
            }
            if (!pid.isValid()) {
                throw new IllegalArgumentException("Unable to create package. Illegal package name.");
            }
            Path pkgFile = this.getPackageFile(pid);
            FSInstallState state = this.getInstallState(pid);
            if (Files.exists(pkgFile, new LinkOption[0])) {
                if (!replace || state.isExternal()) throw new PackageExistsException("Package already exists: " + pid).setId(pid);
                Files.delete(pkgFile);
            } else {
                Files.createDirectories(pkgFile.getParent(), new FileAttribute[0]);
            }
            ZipVaultPackage pkg = new ZipVaultPackage(archive, true);
            this.registerSubPackages(pkg, replace);
            Files.move(tempFile, pkgFile, new CopyOption[0]);
            this.dispatch(PackageEvent.Type.UPLOAD, pid, null);
            ZipVaultPackage zipVaultPackage = pkg;
            return zipVaultPackage;
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
    }

    @Override
    @NotNull
    public PackageId register(@NotNull File file, boolean replace) throws IOException, PackageExistsException {
        return this.doRegister(file, replace, false);
    }

    @Override
    @NotNull
    public PackageId registerExternal(@NotNull File file, boolean replace) throws IOException, PackageExistsException {
        return this.doRegister(file, replace, true);
    }

    @NotNull
    private PackageId doRegister(@NotNull File file, boolean replace, boolean external) throws IOException, PackageExistsException {
        PackageId oldPackageId = this.stateCache.getIdForFile(file.toPath());
        if (!replace && oldPackageId != null) {
            throw new PackageExistsException("Package already exists: " + oldPackageId).setId(oldPackageId);
        }
        try (ZipVaultPackage pack = new ZipVaultPackage(file, false, true);){
            Path newPackageFile;
            FSInstallState state = this.getInstallState(pack.getId());
            if (state != null) {
                if (replace) {
                    try {
                        this.remove(pack.getId());
                    }
                    catch (NoSuchPackageException e) {
                        log.error("No metafile exists to remove", (Throwable)e);
                    }
                } else {
                    throw new PackageExistsException("Package already exists: " + pack.getId()).setId(pack.getId());
                }
            }
            if (!external) {
                newPackageFile = this.getPackageFile(pack.getId());
                Files.createDirectories(newPackageFile.getParent(), new FileAttribute[0]);
                Files.copy(file.toPath(), newPackageFile, new CopyOption[0]);
            } else {
                newPackageFile = file.toPath();
            }
            Map<PackageId, SubPackageHandling.Option> subpackages = this.registerSubPackages(pack, replace);
            HashSet<Dependency> dependencies = new HashSet<Dependency>(Arrays.asList(pack.getDependencies()));
            FSInstallState targetState = new FSInstallState(pack.getId(), FSPackageStatus.REGISTERED, newPackageFile).withDependencies(dependencies).withSubPackages(subpackages).withFilter(pack.getArchive().getMetaInf().getFilter()).withSize(pack.getSize()).withProperties(pack.getArchive().getMetaInf().getProperties()).withExternal(external);
            this.stateCache.put(pack.getId(), targetState);
            PackageId packageId = pack.getId();
            return packageId;
        }
    }

    @Override
    public void remove(@NotNull PackageId id) throws IOException, NoSuchPackageException {
        FSInstallState state = this.stateCache.remove(id);
        if (state == null) {
            throw new NoSuchPackageException().setId(id);
        }
        if (!state.isExternal()) {
            Files.delete(state.getFilePath());
        }
        this.dispatch(PackageEvent.Type.REMOVE, id, null);
    }

    @Override
    @NotNull
    public Set<PackageId> packages() throws IOException {
        return this.stateCache.keySet();
    }

    @Override
    public void installPackage(@NotNull Session session, @NotNull RegisteredPackage pkg, @NotNull ImportOptions opts, boolean extract) throws IOException, PackageException {
        block16: {
            if (!extract) {
                String msg = "Only extraction supported by FS based registry";
                log.error(msg);
                throw new PackageException(msg);
            }
            try (VaultPackage vltPkg = pkg.getPackage();){
                WorkspaceFilter filter = this.getInstallState(vltPkg.getId()).getFilter();
                switch (this.scope) {
                    case APPLICATION_SCOPED: {
                        if (filter instanceof DefaultWorkspaceFilter) {
                            opts.setFilter(ScopedWorkspaceFilter.createApplicationScoped((DefaultWorkspaceFilter)filter));
                            break;
                        }
                        String msg = "Scoped only supports WorkspaceFilters extending DefaultWorkspaceFilter";
                        log.error(msg);
                        throw new PackageException(msg);
                    }
                    case CONTENT_SCOPED: {
                        if (filter instanceof DefaultWorkspaceFilter) {
                            opts.setFilter(ScopedWorkspaceFilter.createContentScoped((DefaultWorkspaceFilter)filter));
                            break;
                        }
                        String msg = "Scoped only supports WorkspaceFilters extending DefaultWorkspaceFilter";
                        log.error(msg);
                        throw new PackageException(msg);
                    }
                }
                if (vltPkg instanceof ZipVaultPackage) {
                    ((ZipVaultPackage)vltPkg).extract(session, opts, this.getSecurityConfig(), this.isStrictByDefault(), this.overwritePrimaryTypesOfFoldersByDefault(), this.getDefaultIdConflictPolicy());
                    this.dispatch(PackageEvent.Type.EXTRACT, pkg.getId(), null);
                    this.stateCache.updatePackageStatus(vltPkg.getId(), FSPackageStatus.EXTRACTED);
                    break block16;
                }
                throw new IllegalArgumentException("Only ZipVaultPackages can be installed but given package is " + vltPkg.getClass());
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void uninstallPackage(@NotNull Session session, @NotNull RegisteredPackage pkg, @NotNull ImportOptions opts) throws IOException, PackageException {
        String msg = "Uninstallation not supported by FS based registry";
        log.error(msg);
        throw new PackageException(msg);
    }

    @ObjectClassDefinition(name="Apache Jackrabbit FS Package Registry Service")
    static @interface Config {
        @AttributeDefinition
        public String homePath() default "packageregistry";

        @AttributeDefinition(name="Installation Scope", description="Allows to limit the installation scope of this Apache Jackrabbit FS Package Registry Service. Packages installed from this registry may be unscoped (unfiltered), application scoped (only content for /apps & /libs) or content scoped (all content except for /libs & /apps)", options={@Option(label="Unscoped", value="UNSCOPED"), @Option(label="Application Scoped", value="APPLICATION_SCOPED"), @Option(label="Content Scoped", value="CONTENT_SCOPED")})
        public String scope() default "UNSCOPED";

        @AttributeDefinition(description="The authorizable ids which are allowed to execute hooks (in addition to 'admin', 'administrators' and 'system'")
        public String[] authIdsForHookExecution();

        @AttributeDefinition(description="The authorizable ids which are allowed to install packages with the 'requireRoot' flag (in addition to 'admin', 'administrators' and 'system'")
        public String[] authIdsForRootInstallation();
    }
}

