/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link;

import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.collect.ImmutableList;
import io.wcm.handler.commons.dom.Anchor;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.Rendition;
import io.wcm.wcm.commons.util.ToStringStyle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jdom2.Attribute;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ProviderType
public final class Link {
    @NotNull
    private final LinkType linkType;
    @NotNull
    private LinkRequest linkRequest;
    private boolean linkReferenceInvalid;
    private Anchor anchor;
    private String url;
    private Page targetPage;
    private Asset targetAsset;
    private Rendition targetRendition;
    private List<Page> redirectPages;

    public Link(@NotNull LinkType linkType, @NotNull LinkRequest linkRequest) {
        this.linkRequest = linkRequest;
        this.linkType = linkType;
    }

    @JsonUnwrapped
    @NotNull
    public LinkType getLinkType() {
        return this.linkType;
    }

    @JsonIgnore
    @NotNull
    public LinkRequest getLinkRequest() {
        return this.linkRequest;
    }

    public void setLinkRequest(@NotNull LinkRequest linkRequest) {
        this.linkRequest = linkRequest;
    }

    @JsonIgnore
    public boolean isLinkReferenceInvalid() {
        return this.linkReferenceInvalid;
    }

    public void setLinkReferenceInvalid(boolean linkReferenceInvalid) {
        this.linkReferenceInvalid = linkReferenceInvalid;
    }

    @JsonIgnore
    public Anchor getAnchor() {
        return this.anchor;
    }

    @JsonIgnore
    public Map<String, String> getAnchorAttributes() {
        if (this.getAnchor() == null) {
            return null;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Attribute attribute : this.getAnchor().getAttributes()) {
            attributes.put(attribute.getName(), attribute.getValue());
        }
        return attributes;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    @JsonIgnore
    public String getMarkup() {
        if (this.anchor != null) {
            return StringUtils.removeEnd((String)this.anchor.toString(), (String)"</a>");
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonIgnore
    public Page getTargetPage() {
        return this.targetPage;
    }

    public void setTargetPage(Page targetPage) {
        this.targetPage = targetPage;
    }

    @JsonIgnore
    public Asset getTargetAsset() {
        return this.targetAsset;
    }

    public void setTargetAsset(Asset targetAsset) {
        this.targetAsset = targetAsset;
    }

    @JsonIgnore
    public Rendition getTargetRendition() {
        return this.targetRendition;
    }

    public void setTargetRendition(Rendition targetRendition) {
        this.targetRendition = targetRendition;
    }

    @JsonIgnore
    @NotNull
    public List<Page> getRedirectPages() {
        if (this.redirectPages == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.redirectPages);
    }

    public void addRedirectPage(@NotNull Page redirectPage) {
        if (this.redirectPages == null) {
            this.redirectPages = new LinkedList<Page>();
        }
        this.redirectPages.add(0, redirectPage);
    }

    public boolean isValid() {
        return this.getLinkType() != null && this.getUrl() != null && !StringUtils.equals((CharSequence)this.getUrl(), (CharSequence)"/invalid///link");
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (org.apache.commons.lang3.builder.ToStringStyle)ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
    }
}

