/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.engine.impl.parameters.AbstractRequestParameter;
import org.apache.sling.engine.impl.parameters.ContainerRequestParameter;
import org.apache.sling.engine.impl.parameters.ParameterMap;

public class Util {
    public static final String ENCODING_DIRECT = "ISO-8859-1";
    public static final String ENCODING_DEFAULT = "UTF-8";
    public static final byte[] NO_CONTENT = new byte[0];
    private static String defaultFixEncoding = "ISO-8859-1";
    private static final int BEFORE_NAME = 0;
    private static final int INSIDE_NAME = 1;
    private static final int ESC_NAME = 2;
    private static final int BEFORE_EQU = 3;
    private static final int BEFORE_VALUE = 4;
    private static final int INSIDE_VALUE = 5;
    private static final int ESC_VALUE = 6;
    private static final int AFTER_VALUE = 6;
    private static final int BEFORE_SEP = 7;

    public static void setDefaultFixEncoding(String encoding) {
        defaultFixEncoding = Util.validateEncoding(encoding);
    }

    static String getDefaultFixEncoding() {
        return defaultFixEncoding;
    }

    static String toIdentityEncodedString(byte[] data) {
        if (data == null) {
            return null;
        }
        char[] characters = new char[data.length];
        for (int i = 0; i < characters.length; ++i) {
            characters[i] = (char)(data[i] & 0xFF);
        }
        return new String(characters);
    }

    static byte[] fromIdentityEncodedString(String string) {
        if (string == null) {
            return NO_CONTENT;
        }
        byte[] data = new byte[string.length()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(string.charAt(i) & 0xFF);
        }
        return data;
    }

    static InputStream toInputStream(String source) {
        byte[] data = Util.fromIdentityEncodedString(source);
        return new ByteArrayInputStream(data);
    }

    static void fixEncoding(ParameterMap parameterMap) {
        String formEncoding = Util.getDefaultFixEncoding();
        RequestParameter[] feParm = (RequestParameter[])parameterMap.get("_charset_");
        if (feParm != null) {
            byte[] rawEncoding = feParm[0].get();
            formEncoding = Util.toIdentityEncodedString(rawEncoding);
            formEncoding = Util.validateEncoding(formEncoding);
        }
        LinkedHashMap<String, String> renameMap = new LinkedHashMap<String, String>();
        for (Map.Entry paramEntry : parameterMap.entrySet()) {
            RequestParameter[] params = (RequestParameter[])paramEntry.getValue();
            String parName = null;
            for (int i = 0; i < params.length; ++i) {
                String name;
                AbstractRequestParameter param;
                if (!(params[i] instanceof AbstractRequestParameter) || formEncoding.equalsIgnoreCase((param = (AbstractRequestParameter)params[i]).getEncoding())) continue;
                param.setEncoding(formEncoding);
                if (parName != null || (parName = (String)paramEntry.getKey()).equals(name = Util.reencode(parName, formEncoding))) continue;
                renameMap.put(parName, name);
            }
        }
        if (!renameMap.isEmpty()) {
            for (Map.Entry entry : renameMap.entrySet()) {
                parameterMap.renameParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static String reencode(String parName, String encoding) {
        if (!ENCODING_DIRECT.equalsIgnoreCase(encoding)) {
            try {
                return new String(parName.getBytes(ENCODING_DIRECT), encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return parName;
    }

    private static String validateEncoding(String encoding) {
        if (encoding != null && encoding.length() > 0) {
            try {
                "".getBytes(encoding);
                return encoding;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return Util.getDefaultFixEncoding();
    }

    public static void parseQueryString(InputStream data, String encoding, ParameterMap map, boolean prependNew) throws UnsupportedEncodingException, IOException {
        Util.parseNVPairString(data, encoding, map, '&', false, prependNew);
    }

    private static void parseNVPairString(InputStream data, String encoding, ParameterMap map, char separator, boolean allowSpaces, boolean prependNew) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream keyBuffer = new ByteArrayOutputStream(256);
        ByteArrayOutputStream valueBuffer = new ByteArrayOutputStream(256);
        char[] chCode = new char[2];
        int state = 0;
        int subState = 0;
        int in = data.read();
        while (in >= 0) {
            char ch = (char)in;
            switch (state) {
                case 0: {
                    if (ch == ' ') break;
                    if (ch == '%') {
                        state = 2;
                        subState = 0;
                        break;
                    }
                    if (ch == '+' && !allowSpaces) {
                        keyBuffer.write(32);
                        state = 1;
                        break;
                    }
                    keyBuffer.write(ch);
                    state = 1;
                    break;
                }
                case 1: {
                    if (ch == '=') {
                        state = 4;
                        break;
                    }
                    if (ch == '+' && !allowSpaces) {
                        keyBuffer.write(32);
                        break;
                    }
                    if (ch == '%') {
                        state = 2;
                        subState = 0;
                        break;
                    }
                    if (ch == '&') {
                        Util.addNVPair(map, keyBuffer, valueBuffer, encoding, prependNew);
                        state = 0;
                        break;
                    }
                    keyBuffer.write(ch);
                    break;
                }
                case 2: {
                    chCode[subState++] = ch;
                    if (subState != chCode.length) break;
                    String code = new String(chCode);
                    try {
                        keyBuffer.write(Integer.parseInt(code, 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Bad escape sequence: %" + code);
                    }
                    state = 1;
                    break;
                }
                case 3: {
                    if (ch != '=') break;
                    state = 4;
                    break;
                }
                case 4: {
                    if (ch == ' ') break;
                    if (ch == '%') {
                        state = 6;
                        subState = 0;
                        break;
                    }
                    if (ch == '+' && !allowSpaces) {
                        valueBuffer.write(32);
                        state = 5;
                        break;
                    }
                    if (ch == separator) {
                        Util.addNVPair(map, keyBuffer, valueBuffer, encoding, prependNew);
                        state = 0;
                        break;
                    }
                    valueBuffer.write(ch);
                    state = 5;
                    break;
                }
                case 5: {
                    if (ch == separator) {
                        Util.addNVPair(map, keyBuffer, valueBuffer, encoding, prependNew);
                        state = 0;
                        break;
                    }
                    if (ch == '+' && !allowSpaces) {
                        valueBuffer.write(32);
                        break;
                    }
                    if (ch == '%') {
                        state = 6;
                        subState = 0;
                        break;
                    }
                    valueBuffer.write(ch);
                    break;
                }
                case 6: {
                    chCode[subState++] = ch;
                    if (subState != chCode.length) break;
                    String code = new String(chCode);
                    try {
                        valueBuffer.write(Integer.parseInt(code, 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Bad escape sequence: %" + code);
                    }
                    state = 5;
                    break;
                }
                case 7: {
                    if (ch != separator) break;
                    state = 0;
                }
            }
            in = data.read();
        }
        if (keyBuffer.size() > 0) {
            Util.addNVPair(map, keyBuffer, valueBuffer, encoding, prependNew);
        }
    }

    private static void addNVPair(ParameterMap map, ByteArrayOutputStream keyBuffer, ByteArrayOutputStream valueBuffer, String encoding, boolean prependNew) throws UnsupportedEncodingException {
        String key = keyBuffer.toString(encoding);
        String value = valueBuffer.toString(encoding);
        map.addParameter(new ContainerRequestParameter(key, value, encoding), prependNew);
        keyBuffer.reset();
        valueBuffer.reset();
    }
}

