/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.discovery;

import java.util.ArrayList;
import java.util.Map;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEndpointDiscoveryFilter
implements DiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEndpointDiscoveryFilter.class);
    private static final String ALL_TRANSPORT = "";
    private static final String WEBSOCKET_TRANSPORT = "websocket";

    @Override
    public boolean isGroupingFilter() {
        return true;
    }

    @Override
    public DiscoveryTreeNode discovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        String expectTransportName = this.findTransportName(context, parent);
        return parent.children().computeIfAbsent(expectTransportName, etn -> this.createDiscoveryTreeNode(expectTransportName, context, parent));
    }

    protected DiscoveryTreeNode createDiscoveryTreeNode(String expectTransportName, DiscoveryContext context, DiscoveryTreeNode parent) {
        ArrayList<Object> endpoints = new ArrayList<Object>();
        for (MicroserviceInstance instance : ((Map)parent.data()).values()) {
            for (String endpoint : instance.getEndpoints()) {
                try {
                    Object objEndpoint;
                    URIEndpointObject endpointObject = new URIEndpointObject(endpoint);
                    String transportName = endpointObject.getScheme();
                    if (endpointObject.isWebsocketEnabled() && WEBSOCKET_TRANSPORT.equals(expectTransportName)) {
                        transportName = WEBSOCKET_TRANSPORT;
                    }
                    if (!this.isTransportNameMatch(transportName, expectTransportName) || (objEndpoint = this.createEndpoint(context, transportName, endpoint, instance)) == null) continue;
                    endpoints.add(objEndpoint);
                }
                catch (Exception e) {
                    LOGGER.warn("unrecognized address find, ignore {}.", (Object)endpoint);
                }
            }
        }
        return (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, expectTransportName).data(endpoints);
    }

    protected boolean isTransportNameMatch(String transportName, String expectTransportName) {
        if (ALL_TRANSPORT.equals(expectTransportName)) {
            return true;
        }
        return transportName.equals(expectTransportName);
    }

    protected abstract String findTransportName(DiscoveryContext var1, DiscoveryTreeNode var2);

    protected abstract Object createEndpoint(DiscoveryContext var1, String var2, String var3, MicroserviceInstance var4);
}

