/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.stream;

import io.netty.buffer.ByteBuf;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BufferInputStream
extends ServletInputStream {
    private final ByteBuf byteBuf;

    public BufferInputStream(ByteBuf buffer) {
        this.byteBuf = buffer;
    }

    public long skip(long len) {
        int skipLen = Math.min((int)len, this.available());
        this.byteBuf.skipBytes(skipLen);
        return skipLen;
    }

    public byte readByte() {
        return this.byteBuf.readByte();
    }

    public int read() {
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        return this.byteBuf.readUnsignedByte();
    }

    public boolean readBoolean() {
        return this.byteBuf.readBoolean();
    }

    public short readShort() {
        return this.byteBuf.readShort();
    }

    public int readInt() {
        return this.byteBuf.readInt();
    }

    public long readLong() {
        return this.byteBuf.readLong();
    }

    public int getIndex() {
        return this.byteBuf.readerIndex();
    }

    public String readString() {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        this.byteBuf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) {
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        if (len > avail) {
            len = avail;
        }
        this.byteBuf.readBytes(b, off, len);
        return len;
    }

    public int available() {
        return this.byteBuf.readableBytes();
    }

    public void close() {
        this.byteBuf.release();
    }

    public void reset() throws IOException {
        this.byteBuf.resetReaderIndex();
    }

    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    public boolean isFinished() {
        return !this.byteBuf.isReadable();
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener readListener) {
    }
}

