/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.SchemaWriter;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.lang.reflect.Array;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.MessageWriteSchema;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedWriteSchemas;

public class PropertyWrapperRepeatedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor, SchemaWriter<Object> elementSchema) {
        JavaType contentType = propertyDescriptor.getJavaType().getContentType();
        Class contentClass = contentType == null ? Object.class : contentType.getRawClass();
        Class<Object[]> arrayClass = Array.newInstance(contentClass, 0).getClass();
        return RepeatedWriteSchemas.create(protoField, propertyDescriptor, new PropertyWrapperWriters(protoField, elementSchema, arrayClass));
    }

    private static class PropertyWrapperWriters
    extends AbstractWriters<Object> {
        public PropertyWrapperWriters(Field protoField, SchemaWriter<Object> elementSchema, Class<Object[]> arrayClass) {
            super(protoField, arrayClass);
            FieldSchema fieldSchema = elementSchema instanceof MessageWriteSchema ? ((MessageWriteSchema)elementSchema).getMainPojoFieldMaps().getFieldByNumber(1) : null;
            this.arrayWriter = (output, array) -> {
                for (Object element : array) {
                    if (element != null) {
                        output.writeObject(this.tag, this.tagSize, element, fieldSchema::writeTo);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.collectionWriter = (output, collection) -> {
                for (Object element : collection) {
                    if (element != null) {
                        output.writeObject(this.tag, this.tagSize, element, fieldSchema::writeTo);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
        }
    }
}

