/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.guavacommon;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.javacrumbs.futureconverter.common.internal.FutureWrapper;
import net.javacrumbs.futureconverter.common.internal.ValueSource;
import net.javacrumbs.futureconverter.common.internal.ValueSourceFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.AbstractFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.SettableFuture;

public class GuavaFutureUtils {
    public static <T> ListenableFuture<T> createListenableFuture(ValueSourceFuture<T> valueSourceFuture) {
        if (valueSourceFuture instanceof ListenableFutureBackedValueSourceFuture) {
            return ((ListenableFutureBackedValueSourceFuture)valueSourceFuture).getWrappedFuture();
        }
        return new ValueSourceFutureBackedListenableFuture<T>(valueSourceFuture);
    }

    public static <T> ListenableFuture<T> createListenableFuture(ValueSource<T> valueSource) {
        if (valueSource instanceof ListenableFutureBackedValueSourceFuture) {
            return ((ListenableFutureBackedValueSourceFuture)valueSource).getWrappedFuture();
        }
        return new ValueSourceBackedListenableFuture(valueSource);
    }

    public static <T> ValueSourceFuture<T> createValueSourceFuture(ListenableFuture<T> listenableFuture) {
        if (listenableFuture instanceof ValueSourceFutureBackedListenableFuture) {
            return ((ValueSourceFutureBackedListenableFuture)listenableFuture).getWrappedFuture();
        }
        return new ListenableFutureBackedValueSourceFuture(listenableFuture);
    }

    public static <T> ValueSource<T> createValueSource(ListenableFuture<T> listenableFuture) {
        if (listenableFuture instanceof ValueSourceBackedListenableFuture) {
            return ((ValueSourceBackedListenableFuture)listenableFuture).getValueSource();
        }
        return new ListenableFutureBackedValueSourceFuture(listenableFuture);
    }

    private static class ListenableFutureBackedValueSourceFuture<T>
    extends ValueSourceFuture<T> {
        private ListenableFutureBackedValueSourceFuture(ListenableFuture<T> wrappedFuture) {
            super(wrappedFuture);
        }

        @Override
        public void addCallbacks(final Consumer<T> successCallback, final Consumer<Throwable> failureCallback) {
            Futures.addCallback(this.getWrappedFuture(), new FutureCallback<T>(){

                @Override
                public void onSuccess(T result) {
                    successCallback.accept(result);
                }

                @Override
                public void onFailure(Throwable t2) {
                    failureCallback.accept(t2);
                }
            }, MoreExecutors.directExecutor());
        }

        @Override
        protected ListenableFuture<T> getWrappedFuture() {
            return (ListenableFuture)super.getWrappedFuture();
        }
    }

    private static class ValueSourceBackedListenableFuture<T>
    extends FutureWrapper<T>
    implements ListenableFuture<T> {
        private final ValueSource<T> valueSource;

        private ValueSourceBackedListenableFuture(ValueSource<T> valueSource) {
            super(SettableFuture.create());
            this.valueSource = valueSource;
            valueSource.addCallbacks(value -> ((SettableFuture)this.getWrappedFuture()).set(value), ex -> ((SettableFuture)this.getWrappedFuture()).setException((Throwable)ex));
        }

        @Override
        public void addListener(Runnable listener, Executor executor) {
            ((AbstractFuture.TrustedFuture)this.getWrappedFuture()).addListener(listener, executor);
        }

        @Override
        protected SettableFuture<T> getWrappedFuture() {
            return (SettableFuture)super.getWrappedFuture();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.valueSource.cancel(mayInterruptIfRunning);
            return super.cancel(mayInterruptIfRunning);
        }

        private ValueSource<T> getValueSource() {
            return this.valueSource;
        }
    }

    private static class ValueSourceFutureBackedListenableFuture<T>
    extends FutureWrapper<T>
    implements ListenableFuture<T> {
        ValueSourceFutureBackedListenableFuture(ValueSourceFuture<T> valueSourceFuture) {
            super(valueSourceFuture);
        }

        @Override
        protected ValueSourceFuture<T> getWrappedFuture() {
            return (ValueSourceFuture)super.getWrappedFuture();
        }

        @Override
        public void addListener(Runnable listener, Executor executor) {
            this.getWrappedFuture().addCallbacks(value -> executor.execute(listener), ex -> executor.execute(listener));
        }
    }
}

