/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_RealIdentificationApi_Slot implements Message {

  // Properties.
  protected final int slotNumber;
  protected final long moduleIdentNumber;
  protected final List<PnIoCm_RealIdentificationApi_Subslot> subslots;

  public PnIoCm_RealIdentificationApi_Slot(
      int slotNumber, long moduleIdentNumber, List<PnIoCm_RealIdentificationApi_Subslot> subslots) {
    super();
    this.slotNumber = slotNumber;
    this.moduleIdentNumber = moduleIdentNumber;
    this.subslots = subslots;
  }

  public int getSlotNumber() {
    return slotNumber;
  }

  public long getModuleIdentNumber() {
    return moduleIdentNumber;
  }

  public List<PnIoCm_RealIdentificationApi_Subslot> getSubslots() {
    return subslots;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_RealIdentificationApi_Slot");

    // Simple Field (slotNumber)
    writeSimpleField(
        "slotNumber",
        slotNumber,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (moduleIdentNumber)
    writeSimpleField(
        "moduleIdentNumber",
        moduleIdentNumber,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Implicit Field (numSubslots) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int numSubslots = (int) (COUNT(getSubslots()));
    writeImplicitField(
        "numSubslots",
        numSubslots,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Array Field (subslots)
    writeComplexTypeArrayField(
        "subslots", subslots, writeBuffer, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_RealIdentificationApi_Slot");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PnIoCm_RealIdentificationApi_Slot _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (slotNumber)
    lengthInBits += 16;

    // Simple field (moduleIdentNumber)
    lengthInBits += 32;

    // Implicit Field (numSubslots)
    lengthInBits += 16;

    // Array field
    if (subslots != null) {
      int i = 0;
      for (PnIoCm_RealIdentificationApi_Subslot element : subslots) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= subslots.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static PnIoCm_RealIdentificationApi_Slot staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_RealIdentificationApi_Slot");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int slotNumber =
        readSimpleField(
            "slotNumber",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long moduleIdentNumber =
        readSimpleField(
            "moduleIdentNumber",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int numSubslots =
        readImplicitField(
            "numSubslots",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    List<PnIoCm_RealIdentificationApi_Subslot> subslots =
        readCountArrayField(
            "subslots",
            readComplex(
                () -> PnIoCm_RealIdentificationApi_Subslot.staticParse(readBuffer), readBuffer),
            numSubslots,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_RealIdentificationApi_Slot");
    // Create the instance
    PnIoCm_RealIdentificationApi_Slot _pnIoCm_RealIdentificationApi_Slot;
    _pnIoCm_RealIdentificationApi_Slot =
        new PnIoCm_RealIdentificationApi_Slot(slotNumber, moduleIdentNumber, subslots);
    return _pnIoCm_RealIdentificationApi_Slot;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_RealIdentificationApi_Slot)) {
      return false;
    }
    PnIoCm_RealIdentificationApi_Slot that = (PnIoCm_RealIdentificationApi_Slot) o;
    return (getSlotNumber() == that.getSlotNumber())
        && (getModuleIdentNumber() == that.getModuleIdentNumber())
        && (getSubslots() == that.getSubslots())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSlotNumber(), getModuleIdentNumber(), getSubslots());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
