/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PubSubConfiguration2DataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 23604;
  }

  // Properties.
  protected final List<PublishedDataSetDataType> publishedDataSets;
  protected final List<PubSubConnectionDataType> connections;
  protected final boolean enabled;
  protected final List<StandaloneSubscribedDataSetDataType> subscribedDataSets;
  protected final List<DataSetMetaDataType> dataSetClasses;
  protected final List<EndpointDescription> defaultSecurityKeyServices;
  protected final List<SecurityGroupDataType> securityGroups;
  protected final List<PubSubKeyPushTargetDataType> pubSubKeyPushTargets;
  protected final long configurationVersion;
  protected final List<KeyValuePair> configurationProperties;

  public PubSubConfiguration2DataType(
      List<PublishedDataSetDataType> publishedDataSets,
      List<PubSubConnectionDataType> connections,
      boolean enabled,
      List<StandaloneSubscribedDataSetDataType> subscribedDataSets,
      List<DataSetMetaDataType> dataSetClasses,
      List<EndpointDescription> defaultSecurityKeyServices,
      List<SecurityGroupDataType> securityGroups,
      List<PubSubKeyPushTargetDataType> pubSubKeyPushTargets,
      long configurationVersion,
      List<KeyValuePair> configurationProperties) {
    super();
    this.publishedDataSets = publishedDataSets;
    this.connections = connections;
    this.enabled = enabled;
    this.subscribedDataSets = subscribedDataSets;
    this.dataSetClasses = dataSetClasses;
    this.defaultSecurityKeyServices = defaultSecurityKeyServices;
    this.securityGroups = securityGroups;
    this.pubSubKeyPushTargets = pubSubKeyPushTargets;
    this.configurationVersion = configurationVersion;
    this.configurationProperties = configurationProperties;
  }

  public List<PublishedDataSetDataType> getPublishedDataSets() {
    return publishedDataSets;
  }

  public List<PubSubConnectionDataType> getConnections() {
    return connections;
  }

  public boolean getEnabled() {
    return enabled;
  }

  public List<StandaloneSubscribedDataSetDataType> getSubscribedDataSets() {
    return subscribedDataSets;
  }

  public List<DataSetMetaDataType> getDataSetClasses() {
    return dataSetClasses;
  }

  public List<EndpointDescription> getDefaultSecurityKeyServices() {
    return defaultSecurityKeyServices;
  }

  public List<SecurityGroupDataType> getSecurityGroups() {
    return securityGroups;
  }

  public List<PubSubKeyPushTargetDataType> getPubSubKeyPushTargets() {
    return pubSubKeyPushTargets;
  }

  public long getConfigurationVersion() {
    return configurationVersion;
  }

  public List<KeyValuePair> getConfigurationProperties() {
    return configurationProperties;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PubSubConfiguration2DataType");

    // Implicit Field (noOfPublishedDataSets) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfPublishedDataSets =
        (int) ((((getPublishedDataSets()) == (null)) ? -(1) : COUNT(getPublishedDataSets())));
    writeImplicitField(
        "noOfPublishedDataSets", noOfPublishedDataSets, writeSignedInt(writeBuffer, 32));

    // Array Field (publishedDataSets)
    writeComplexTypeArrayField("publishedDataSets", publishedDataSets, writeBuffer);

    // Implicit Field (noOfConnections) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfConnections = (int) ((((getConnections()) == (null)) ? -(1) : COUNT(getConnections())));
    writeImplicitField("noOfConnections", noOfConnections, writeSignedInt(writeBuffer, 32));

    // Array Field (connections)
    writeComplexTypeArrayField("connections", connections, writeBuffer);

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (enabled)
    writeSimpleField("enabled", enabled, writeBoolean(writeBuffer));

    // Implicit Field (noOfSubscribedDataSets) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfSubscribedDataSets =
        (int) ((((getSubscribedDataSets()) == (null)) ? -(1) : COUNT(getSubscribedDataSets())));
    writeImplicitField(
        "noOfSubscribedDataSets", noOfSubscribedDataSets, writeSignedInt(writeBuffer, 32));

    // Array Field (subscribedDataSets)
    writeComplexTypeArrayField("subscribedDataSets", subscribedDataSets, writeBuffer);

    // Implicit Field (noOfDataSetClasses) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDataSetClasses =
        (int) ((((getDataSetClasses()) == (null)) ? -(1) : COUNT(getDataSetClasses())));
    writeImplicitField("noOfDataSetClasses", noOfDataSetClasses, writeSignedInt(writeBuffer, 32));

    // Array Field (dataSetClasses)
    writeComplexTypeArrayField("dataSetClasses", dataSetClasses, writeBuffer);

    // Implicit Field (noOfDefaultSecurityKeyServices) (Used for parsing, but its value is not
    // stored as it's implicitly given by the objects content)
    int noOfDefaultSecurityKeyServices =
        (int)
            ((((getDefaultSecurityKeyServices()) == (null))
                ? -(1)
                : COUNT(getDefaultSecurityKeyServices())));
    writeImplicitField(
        "noOfDefaultSecurityKeyServices",
        noOfDefaultSecurityKeyServices,
        writeSignedInt(writeBuffer, 32));

    // Array Field (defaultSecurityKeyServices)
    writeComplexTypeArrayField(
        "defaultSecurityKeyServices", defaultSecurityKeyServices, writeBuffer);

    // Implicit Field (noOfSecurityGroups) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfSecurityGroups =
        (int) ((((getSecurityGroups()) == (null)) ? -(1) : COUNT(getSecurityGroups())));
    writeImplicitField("noOfSecurityGroups", noOfSecurityGroups, writeSignedInt(writeBuffer, 32));

    // Array Field (securityGroups)
    writeComplexTypeArrayField("securityGroups", securityGroups, writeBuffer);

    // Implicit Field (noOfPubSubKeyPushTargets) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfPubSubKeyPushTargets =
        (int) ((((getPubSubKeyPushTargets()) == (null)) ? -(1) : COUNT(getPubSubKeyPushTargets())));
    writeImplicitField(
        "noOfPubSubKeyPushTargets", noOfPubSubKeyPushTargets, writeSignedInt(writeBuffer, 32));

    // Array Field (pubSubKeyPushTargets)
    writeComplexTypeArrayField("pubSubKeyPushTargets", pubSubKeyPushTargets, writeBuffer);

    // Simple Field (configurationVersion)
    writeSimpleField(
        "configurationVersion", configurationVersion, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfConfigurationProperties) (Used for parsing, but its value is not stored
    // as it's implicitly given by the objects content)
    int noOfConfigurationProperties =
        (int)
            ((((getConfigurationProperties()) == (null))
                ? -(1)
                : COUNT(getConfigurationProperties())));
    writeImplicitField(
        "noOfConfigurationProperties",
        noOfConfigurationProperties,
        writeSignedInt(writeBuffer, 32));

    // Array Field (configurationProperties)
    writeComplexTypeArrayField("configurationProperties", configurationProperties, writeBuffer);

    writeBuffer.popContext("PubSubConfiguration2DataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PubSubConfiguration2DataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (noOfPublishedDataSets)
    lengthInBits += 32;

    // Array field
    if (publishedDataSets != null) {
      int i = 0;
      for (PublishedDataSetDataType element : publishedDataSets) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= publishedDataSets.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfConnections)
    lengthInBits += 32;

    // Array field
    if (connections != null) {
      int i = 0;
      for (PubSubConnectionDataType element : connections) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= connections.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (enabled)
    lengthInBits += 1;

    // Implicit Field (noOfSubscribedDataSets)
    lengthInBits += 32;

    // Array field
    if (subscribedDataSets != null) {
      int i = 0;
      for (StandaloneSubscribedDataSetDataType element : subscribedDataSets) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= subscribedDataSets.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfDataSetClasses)
    lengthInBits += 32;

    // Array field
    if (dataSetClasses != null) {
      int i = 0;
      for (DataSetMetaDataType element : dataSetClasses) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= dataSetClasses.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfDefaultSecurityKeyServices)
    lengthInBits += 32;

    // Array field
    if (defaultSecurityKeyServices != null) {
      int i = 0;
      for (EndpointDescription element : defaultSecurityKeyServices) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= defaultSecurityKeyServices.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfSecurityGroups)
    lengthInBits += 32;

    // Array field
    if (securityGroups != null) {
      int i = 0;
      for (SecurityGroupDataType element : securityGroups) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= securityGroups.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfPubSubKeyPushTargets)
    lengthInBits += 32;

    // Array field
    if (pubSubKeyPushTargets != null) {
      int i = 0;
      for (PubSubKeyPushTargetDataType element : pubSubKeyPushTargets) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= pubSubKeyPushTargets.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (configurationVersion)
    lengthInBits += 32;

    // Implicit Field (noOfConfigurationProperties)
    lengthInBits += 32;

    // Array field
    if (configurationProperties != null) {
      int i = 0;
      for (KeyValuePair element : configurationProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= configurationProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("PubSubConfiguration2DataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int noOfPublishedDataSets =
        readImplicitField("noOfPublishedDataSets", readSignedInt(readBuffer, 32));

    List<PublishedDataSetDataType> publishedDataSets =
        readCountArrayField(
            "publishedDataSets",
            readComplex(
                () ->
                    (PublishedDataSetDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15580)),
                readBuffer),
            noOfPublishedDataSets);

    int noOfConnections = readImplicitField("noOfConnections", readSignedInt(readBuffer, 32));

    List<PubSubConnectionDataType> connections =
        readCountArrayField(
            "connections",
            readComplex(
                () ->
                    (PubSubConnectionDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15619)),
                readBuffer),
            noOfConnections);

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean enabled = readSimpleField("enabled", readBoolean(readBuffer));

    int noOfSubscribedDataSets =
        readImplicitField("noOfSubscribedDataSets", readSignedInt(readBuffer, 32));

    List<StandaloneSubscribedDataSetDataType> subscribedDataSets =
        readCountArrayField(
            "subscribedDataSets",
            readComplex(
                () ->
                    (StandaloneSubscribedDataSetDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (23602)),
                readBuffer),
            noOfSubscribedDataSets);

    int noOfDataSetClasses = readImplicitField("noOfDataSetClasses", readSignedInt(readBuffer, 32));

    List<DataSetMetaDataType> dataSetClasses =
        readCountArrayField(
            "dataSetClasses",
            readComplex(
                () ->
                    (DataSetMetaDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (14525)),
                readBuffer),
            noOfDataSetClasses);

    int noOfDefaultSecurityKeyServices =
        readImplicitField("noOfDefaultSecurityKeyServices", readSignedInt(readBuffer, 32));

    List<EndpointDescription> defaultSecurityKeyServices =
        readCountArrayField(
            "defaultSecurityKeyServices",
            readComplex(
                () ->
                    (EndpointDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (314)),
                readBuffer),
            noOfDefaultSecurityKeyServices);

    int noOfSecurityGroups = readImplicitField("noOfSecurityGroups", readSignedInt(readBuffer, 32));

    List<SecurityGroupDataType> securityGroups =
        readCountArrayField(
            "securityGroups",
            readComplex(
                () ->
                    (SecurityGroupDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (23603)),
                readBuffer),
            noOfSecurityGroups);

    int noOfPubSubKeyPushTargets =
        readImplicitField("noOfPubSubKeyPushTargets", readSignedInt(readBuffer, 32));

    List<PubSubKeyPushTargetDataType> pubSubKeyPushTargets =
        readCountArrayField(
            "pubSubKeyPushTargets",
            readComplex(
                () ->
                    (PubSubKeyPushTargetDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (25272)),
                readBuffer),
            noOfPubSubKeyPushTargets);

    long configurationVersion =
        readSimpleField("configurationVersion", readUnsignedLong(readBuffer, 32));

    int noOfConfigurationProperties =
        readImplicitField("noOfConfigurationProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> configurationProperties =
        readCountArrayField(
            "configurationProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfConfigurationProperties);

    readBuffer.closeContext("PubSubConfiguration2DataType");
    // Create the instance
    return new PubSubConfiguration2DataTypeBuilderImpl(
        publishedDataSets,
        connections,
        enabled,
        subscribedDataSets,
        dataSetClasses,
        defaultSecurityKeyServices,
        securityGroups,
        pubSubKeyPushTargets,
        configurationVersion,
        configurationProperties);
  }

  public static class PubSubConfiguration2DataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final List<PublishedDataSetDataType> publishedDataSets;
    private final List<PubSubConnectionDataType> connections;
    private final boolean enabled;
    private final List<StandaloneSubscribedDataSetDataType> subscribedDataSets;
    private final List<DataSetMetaDataType> dataSetClasses;
    private final List<EndpointDescription> defaultSecurityKeyServices;
    private final List<SecurityGroupDataType> securityGroups;
    private final List<PubSubKeyPushTargetDataType> pubSubKeyPushTargets;
    private final long configurationVersion;
    private final List<KeyValuePair> configurationProperties;

    public PubSubConfiguration2DataTypeBuilderImpl(
        List<PublishedDataSetDataType> publishedDataSets,
        List<PubSubConnectionDataType> connections,
        boolean enabled,
        List<StandaloneSubscribedDataSetDataType> subscribedDataSets,
        List<DataSetMetaDataType> dataSetClasses,
        List<EndpointDescription> defaultSecurityKeyServices,
        List<SecurityGroupDataType> securityGroups,
        List<PubSubKeyPushTargetDataType> pubSubKeyPushTargets,
        long configurationVersion,
        List<KeyValuePair> configurationProperties) {
      this.publishedDataSets = publishedDataSets;
      this.connections = connections;
      this.enabled = enabled;
      this.subscribedDataSets = subscribedDataSets;
      this.dataSetClasses = dataSetClasses;
      this.defaultSecurityKeyServices = defaultSecurityKeyServices;
      this.securityGroups = securityGroups;
      this.pubSubKeyPushTargets = pubSubKeyPushTargets;
      this.configurationVersion = configurationVersion;
      this.configurationProperties = configurationProperties;
    }

    public PubSubConfiguration2DataType build() {
      PubSubConfiguration2DataType pubSubConfiguration2DataType =
          new PubSubConfiguration2DataType(
              publishedDataSets,
              connections,
              enabled,
              subscribedDataSets,
              dataSetClasses,
              defaultSecurityKeyServices,
              securityGroups,
              pubSubKeyPushTargets,
              configurationVersion,
              configurationProperties);
      return pubSubConfiguration2DataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PubSubConfiguration2DataType)) {
      return false;
    }
    PubSubConfiguration2DataType that = (PubSubConfiguration2DataType) o;
    return (getPublishedDataSets() == that.getPublishedDataSets())
        && (getConnections() == that.getConnections())
        && (getEnabled() == that.getEnabled())
        && (getSubscribedDataSets() == that.getSubscribedDataSets())
        && (getDataSetClasses() == that.getDataSetClasses())
        && (getDefaultSecurityKeyServices() == that.getDefaultSecurityKeyServices())
        && (getSecurityGroups() == that.getSecurityGroups())
        && (getPubSubKeyPushTargets() == that.getPubSubKeyPushTargets())
        && (getConfigurationVersion() == that.getConfigurationVersion())
        && (getConfigurationProperties() == that.getConfigurationProperties())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getPublishedDataSets(),
        getConnections(),
        getEnabled(),
        getSubscribedDataSets(),
        getDataSetClasses(),
        getDefaultSecurityKeyServices(),
        getSecurityGroups(),
        getPubSubKeyPushTargets(),
        getConfigurationVersion(),
        getConfigurationProperties());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
