/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonDataSetMessage extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19314;
  }

  // Properties.
  protected final int dataSetWriterId;
  protected final PascalString dataSetWriterName;
  protected final PascalString publisherId;
  protected final PascalString writerGroupName;
  protected final long sequenceNumber;
  protected final ConfigurationVersionDataType metaDataVersion;
  protected final long minorVersion;
  protected final long timestamp;
  protected final StatusCode status;
  protected final PascalString messageType;
  protected final ExtensionObject payload;

  public JsonDataSetMessage(
      int dataSetWriterId,
      PascalString dataSetWriterName,
      PascalString publisherId,
      PascalString writerGroupName,
      long sequenceNumber,
      ConfigurationVersionDataType metaDataVersion,
      long minorVersion,
      long timestamp,
      StatusCode status,
      PascalString messageType,
      ExtensionObject payload) {
    super();
    this.dataSetWriterId = dataSetWriterId;
    this.dataSetWriterName = dataSetWriterName;
    this.publisherId = publisherId;
    this.writerGroupName = writerGroupName;
    this.sequenceNumber = sequenceNumber;
    this.metaDataVersion = metaDataVersion;
    this.minorVersion = minorVersion;
    this.timestamp = timestamp;
    this.status = status;
    this.messageType = messageType;
    this.payload = payload;
  }

  public int getDataSetWriterId() {
    return dataSetWriterId;
  }

  public PascalString getDataSetWriterName() {
    return dataSetWriterName;
  }

  public PascalString getPublisherId() {
    return publisherId;
  }

  public PascalString getWriterGroupName() {
    return writerGroupName;
  }

  public long getSequenceNumber() {
    return sequenceNumber;
  }

  public ConfigurationVersionDataType getMetaDataVersion() {
    return metaDataVersion;
  }

  public long getMinorVersion() {
    return minorVersion;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public StatusCode getStatus() {
    return status;
  }

  public PascalString getMessageType() {
    return messageType;
  }

  public ExtensionObject getPayload() {
    return payload;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonDataSetMessage");

    // Simple Field (dataSetWriterId)
    writeSimpleField("dataSetWriterId", dataSetWriterId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (dataSetWriterName)
    writeSimpleField("dataSetWriterName", dataSetWriterName, writeComplex(writeBuffer));

    // Simple Field (publisherId)
    writeSimpleField("publisherId", publisherId, writeComplex(writeBuffer));

    // Simple Field (writerGroupName)
    writeSimpleField("writerGroupName", writerGroupName, writeComplex(writeBuffer));

    // Simple Field (sequenceNumber)
    writeSimpleField("sequenceNumber", sequenceNumber, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (metaDataVersion)
    writeSimpleField("metaDataVersion", metaDataVersion, writeComplex(writeBuffer));

    // Simple Field (minorVersion)
    writeSimpleField("minorVersion", minorVersion, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeSignedLong(writeBuffer, 64));

    // Simple Field (status)
    writeSimpleField("status", status, writeComplex(writeBuffer));

    // Simple Field (messageType)
    writeSimpleField("messageType", messageType, writeComplex(writeBuffer));

    // Simple Field (payload)
    writeSimpleField("payload", payload, writeComplex(writeBuffer));

    writeBuffer.popContext("JsonDataSetMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonDataSetMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (dataSetWriterId)
    lengthInBits += 16;

    // Simple field (dataSetWriterName)
    lengthInBits += dataSetWriterName.getLengthInBits();

    // Simple field (publisherId)
    lengthInBits += publisherId.getLengthInBits();

    // Simple field (writerGroupName)
    lengthInBits += writerGroupName.getLengthInBits();

    // Simple field (sequenceNumber)
    lengthInBits += 32;

    // Simple field (metaDataVersion)
    lengthInBits += metaDataVersion.getLengthInBits();

    // Simple field (minorVersion)
    lengthInBits += 32;

    // Simple field (timestamp)
    lengthInBits += 64;

    // Simple field (status)
    lengthInBits += status.getLengthInBits();

    // Simple field (messageType)
    lengthInBits += messageType.getLengthInBits();

    // Simple field (payload)
    lengthInBits += payload.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonDataSetMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int dataSetWriterId = readSimpleField("dataSetWriterId", readUnsignedInt(readBuffer, 16));

    PascalString dataSetWriterName =
        readSimpleField(
            "dataSetWriterName",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString publisherId =
        readSimpleField(
            "publisherId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString writerGroupName =
        readSimpleField(
            "writerGroupName", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    long sequenceNumber = readSimpleField("sequenceNumber", readUnsignedLong(readBuffer, 32));

    ConfigurationVersionDataType metaDataVersion =
        readSimpleField(
            "metaDataVersion",
            readComplex(
                () ->
                    (ConfigurationVersionDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (14595)),
                readBuffer));

    long minorVersion = readSimpleField("minorVersion", readUnsignedLong(readBuffer, 32));

    long timestamp = readSimpleField("timestamp", readSignedLong(readBuffer, 64));

    StatusCode status =
        readSimpleField(
            "status", readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer));

    PascalString messageType =
        readSimpleField(
            "messageType", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    ExtensionObject payload =
        readSimpleField(
            "payload",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    readBuffer.closeContext("JsonDataSetMessage");
    // Create the instance
    return new JsonDataSetMessageBuilderImpl(
        dataSetWriterId,
        dataSetWriterName,
        publisherId,
        writerGroupName,
        sequenceNumber,
        metaDataVersion,
        minorVersion,
        timestamp,
        status,
        messageType,
        payload);
  }

  public static class JsonDataSetMessageBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final int dataSetWriterId;
    private final PascalString dataSetWriterName;
    private final PascalString publisherId;
    private final PascalString writerGroupName;
    private final long sequenceNumber;
    private final ConfigurationVersionDataType metaDataVersion;
    private final long minorVersion;
    private final long timestamp;
    private final StatusCode status;
    private final PascalString messageType;
    private final ExtensionObject payload;

    public JsonDataSetMessageBuilderImpl(
        int dataSetWriterId,
        PascalString dataSetWriterName,
        PascalString publisherId,
        PascalString writerGroupName,
        long sequenceNumber,
        ConfigurationVersionDataType metaDataVersion,
        long minorVersion,
        long timestamp,
        StatusCode status,
        PascalString messageType,
        ExtensionObject payload) {
      this.dataSetWriterId = dataSetWriterId;
      this.dataSetWriterName = dataSetWriterName;
      this.publisherId = publisherId;
      this.writerGroupName = writerGroupName;
      this.sequenceNumber = sequenceNumber;
      this.metaDataVersion = metaDataVersion;
      this.minorVersion = minorVersion;
      this.timestamp = timestamp;
      this.status = status;
      this.messageType = messageType;
      this.payload = payload;
    }

    public JsonDataSetMessage build() {
      JsonDataSetMessage jsonDataSetMessage =
          new JsonDataSetMessage(
              dataSetWriterId,
              dataSetWriterName,
              publisherId,
              writerGroupName,
              sequenceNumber,
              metaDataVersion,
              minorVersion,
              timestamp,
              status,
              messageType,
              payload);
      return jsonDataSetMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonDataSetMessage)) {
      return false;
    }
    JsonDataSetMessage that = (JsonDataSetMessage) o;
    return (getDataSetWriterId() == that.getDataSetWriterId())
        && (getDataSetWriterName() == that.getDataSetWriterName())
        && (getPublisherId() == that.getPublisherId())
        && (getWriterGroupName() == that.getWriterGroupName())
        && (getSequenceNumber() == that.getSequenceNumber())
        && (getMetaDataVersion() == that.getMetaDataVersion())
        && (getMinorVersion() == that.getMinorVersion())
        && (getTimestamp() == that.getTimestamp())
        && (getStatus() == that.getStatus())
        && (getMessageType() == that.getMessageType())
        && (getPayload() == that.getPayload())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getDataSetWriterId(),
        getDataSetWriterName(),
        getPublisherId(),
        getWriterGroupName(),
        getSequenceNumber(),
        getMetaDataVersion(),
        getMinorVersion(),
        getTimestamp(),
        getStatus(),
        getMessageType(),
        getPayload());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
