/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.api;

import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.ApiClient;
import org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.ApiException;
import org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.Configuration;
import org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.Pair;
import org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model.CreateRemoteRequest;
import org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model.Data;
import org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model.ReadNode200Response;
import org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model.RemoteConfig;

import java.util.*;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class RemotesApi {
  private ApiClient apiClient;

  public RemotesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public RemotesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Creates an access to a remote Data Layer
   * By adding a remote Data Layer, the content of the Data Layer is mapped into the address space of the current Data Layer. Requests are forwarded to the remote Data Layer.
   * @param createRemoteRequest Desciption of new remote connection (optional)
   * @return RemoteConfig
   * @throws ApiException if fails to make API call
   */
  public RemoteConfig createRemote(CreateRemoteRequest createRemoteRequest) throws ApiException {
    Object localVarPostBody = createRemoteRequest;
    
    // create path and map variables
    String localVarPath = "/nodes/devices/remotes";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    
    
    final String[] localVarAccepts = {
      "application/json", "application/octet-stream", "plain/text"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "Bearer", "UsernamePassword" };

    TypeReference<RemoteConfig> localVarReturnType = new TypeReference<RemoteConfig>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }
  /**
   * Execute a create operation on a remote Data Layer
   * Execute a create operation on a remote node. The values for the new node are posted as payload.
   * @param remoteName The name of the remote (required)
   * @param path The path is a string which contains the full access path in the data layer tree. The sub elements in the path are separated by &#39;/&#39;. To query the root node use &#39;/&#39; as path. (required)
   * @param data The data for the create operation (optional)
   * @throws ApiException if fails to make API call
   */
  public void createRemoteNode(String remoteName, String path, Data data) throws ApiException {
    Object localVarPostBody = data;
    
    // verify the required parameter 'remoteName' is set
    if (remoteName == null) {
      throw new ApiException(400, "Missing the required parameter 'remoteName' when calling createRemoteNode");
    }
    
    // verify the required parameter 'path' is set
    if (path == null) {
      throw new ApiException(400, "Missing the required parameter 'path' when calling createRemoteNode");
    }
    
    // create path and map variables
    String localVarPath = "/nodes/devices/remotes/{RemoteName}/{Path}"
      .replaceAll("\\{" + "RemoteName" + "\\}", apiClient.escapeString(remoteName.toString()))
      .replaceAll("\\{" + "Path" + "\\}", apiClient.escapeString(path.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json", "application/octet-stream", "plain/text"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "Bearer", "UsernamePassword" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }
  /**
   * Delete a remote configuration
   * Delete a remote configuration.
   * @param remoteName The name of the remote (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteRemoteConfig(String remoteName) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'remoteName' is set
    if (remoteName == null) {
      throw new ApiException(400, "Missing the required parameter 'remoteName' when calling deleteRemoteConfig");
    }
    
    // create path and map variables
    String localVarPath = "/nodes/devices/remotes/{RemoteName}"
      .replaceAll("\\{" + "RemoteName" + "\\}", apiClient.escapeString(remoteName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "Bearer", "UsernamePassword" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }
  /**
   * Execute a delete operation on a remote Data Layer
   * Execute a delete operation on a remote Data Layer.
   * @param remoteName The name of the remote (required)
   * @param path The path is a string which contains the full access path in the data layer tree. The sub elements in the path are separated by &#39;/&#39;. To query the root node use &#39;/&#39; as path. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteRemoteNode(String remoteName, String path) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'remoteName' is set
    if (remoteName == null) {
      throw new ApiException(400, "Missing the required parameter 'remoteName' when calling deleteRemoteNode");
    }
    
    // verify the required parameter 'path' is set
    if (path == null) {
      throw new ApiException(400, "Missing the required parameter 'path' when calling deleteRemoteNode");
    }
    
    // create path and map variables
    String localVarPath = "/nodes/devices/remotes/{RemoteName}/{Path}"
      .replaceAll("\\{" + "RemoteName" + "\\}", apiClient.escapeString(remoteName.toString()))
      .replaceAll("\\{" + "Path" + "\\}", apiClient.escapeString(path.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "Bearer", "UsernamePassword" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }
  /**
   * Access the remote configuration
   * Access the remote configuration.
   * @param remoteName The name of the remote (required)
   * @return RemoteConfig
   * @throws ApiException if fails to make API call
   */
  public RemoteConfig getRemote(String remoteName) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'remoteName' is set
    if (remoteName == null) {
      throw new ApiException(400, "Missing the required parameter 'remoteName' when calling getRemote");
    }
    
    // create path and map variables
    String localVarPath = "/nodes/devices/remotes/{RemoteName}"
      .replaceAll("\\{" + "RemoteName" + "\\}", apiClient.escapeString(remoteName.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    
    
    final String[] localVarAccepts = {
      "application/json", "application/octet-stream", "plain/text"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "Bearer", "UsernamePassword" };

    TypeReference<RemoteConfig> localVarReturnType = new TypeReference<RemoteConfig>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }
  /**
   * Execute a read operation to get data from a remote Data Layer
   * Returns the data, browse-information or metadata of a requested node. Depends on the query parameter.
   * @param remoteName The name of the remote (required)
   * @param path The path is a string which contains the full access path in the data layer tree. The sub elements in the path are separated by &#39;/&#39;. To query the root node use &#39;/&#39; as path. (required)
   * @param type  (optional, default to null)
   * @return ReadNode200Response
   * @throws ApiException if fails to make API call
   */
  public ReadNode200Response readRemoteNode(String remoteName, String path, String type) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'remoteName' is set
    if (remoteName == null) {
      throw new ApiException(400, "Missing the required parameter 'remoteName' when calling readRemoteNode");
    }
    
    // verify the required parameter 'path' is set
    if (path == null) {
      throw new ApiException(400, "Missing the required parameter 'path' when calling readRemoteNode");
    }
    
    // create path and map variables
    String localVarPath = "/nodes/devices/remotes/{RemoteName}/{Path}"
      .replaceAll("\\{" + "RemoteName" + "\\}", apiClient.escapeString(remoteName.toString()))
      .replaceAll("\\{" + "Path" + "\\}", apiClient.escapeString(path.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    
    
    
    final String[] localVarAccepts = {
      "application/json", "application/octet-stream", "plain/text"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "Bearer", "UsernamePassword" };

    TypeReference<ReadNode200Response> localVarReturnType = new TypeReference<ReadNode200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }
  /**
   * Execute a write operation on a remote Data Layer
   * Execute a write operation. The written values are posted as payload.
   * @param remoteName The name of the remote (required)
   * @param path The path is a string which contains the full access path in the data layer tree. The sub elements in the path are separated by &#39;/&#39;. To query the root node use &#39;/&#39; as path. (required)
   * @param data The data of the node to be updated or the data of the command to be executed. (optional)
   * @throws ApiException if fails to make API call
   */
  public void writeRemoteNode(String remoteName, String path, Data data) throws ApiException {
    Object localVarPostBody = data;
    
    // verify the required parameter 'remoteName' is set
    if (remoteName == null) {
      throw new ApiException(400, "Missing the required parameter 'remoteName' when calling writeRemoteNode");
    }
    
    // verify the required parameter 'path' is set
    if (path == null) {
      throw new ApiException(400, "Missing the required parameter 'path' when calling writeRemoteNode");
    }
    
    // create path and map variables
    String localVarPath = "/nodes/devices/remotes/{RemoteName}/{Path}"
      .replaceAll("\\{" + "RemoteName" + "\\}", apiClient.escapeString(remoteName.toString()))
      .replaceAll("\\{" + "Path" + "\\}", apiClient.escapeString(path.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json", "application/octet-stream", "plain/text"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "Bearer", "UsernamePassword" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }
}
