/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TamperStatus implements Message {

  // Properties.
  protected final short status;

  public TamperStatus(short status) {
    super();
    this.status = status;
  }

  public short getStatus() {
    return status;
  }

  public boolean getIsNoTamper() {
    return (boolean) ((getStatus()) == (0x00));
  }

  public boolean getIsReserved() {
    return (boolean) (((getStatus()) >= (0x01)) && ((getStatus()) <= (0xFE)));
  }

  public boolean getIsTamperActive() {
    return (boolean) ((getStatus()) > (0xFE));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TamperStatus");

    // Simple Field (status)
    writeSimpleField("status", status, writeUnsignedShort(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isNoTamper = getIsNoTamper();
    writeBuffer.writeVirtual("isNoTamper", isNoTamper);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isReserved = getIsReserved();
    writeBuffer.writeVirtual("isReserved", isReserved);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isTamperActive = getIsTamperActive();
    writeBuffer.writeVirtual("isTamperActive", isTamperActive);

    writeBuffer.popContext("TamperStatus");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    TamperStatus _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (status)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static TamperStatus staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("TamperStatus");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short status = readSimpleField("status", readUnsignedShort(readBuffer, 8));
    boolean isNoTamper = readVirtualField("isNoTamper", boolean.class, (status) == (0x00));
    boolean isReserved =
        readVirtualField("isReserved", boolean.class, ((status) >= (0x01)) && ((status) <= (0xFE)));
    boolean isTamperActive = readVirtualField("isTamperActive", boolean.class, (status) > (0xFE));

    readBuffer.closeContext("TamperStatus");
    // Create the instance
    TamperStatus _tamperStatus;
    _tamperStatus = new TamperStatus(status);
    return _tamperStatus;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TamperStatus)) {
      return false;
    }
    TamperStatus that = (TamperStatus) o;
    return (getStatus() == that.getStatus()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getStatus());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
