/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HVACRawLevels implements Message {

  // Properties.
  protected final short rawValue;

  public HVACRawLevels(short rawValue) {
    super();
    this.rawValue = rawValue;
  }

  public short getRawValue() {
    return rawValue;
  }

  public float getValueInPercent() {
    return (float) ((getRawValue()) / (32767F));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HVACRawLevels");

    // Simple Field (rawValue)
    writeSimpleField("rawValue", rawValue, writeSignedShort(writeBuffer, 16));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    float valueInPercent = getValueInPercent();
    writeBuffer.writeVirtual("valueInPercent", valueInPercent);

    writeBuffer.popContext("HVACRawLevels");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    HVACRawLevels _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (rawValue)
    lengthInBits += 16;

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static HVACRawLevels staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("HVACRawLevels");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short rawValue = readSimpleField("rawValue", readSignedShort(readBuffer, 16));
    float valueInPercent = readVirtualField("valueInPercent", float.class, (rawValue) / (32767F));

    readBuffer.closeContext("HVACRawLevels");
    // Create the instance
    HVACRawLevels _hVACRawLevels;
    _hVACRawLevels = new HVACRawLevels(rawValue);
    return _hVACRawLevels;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HVACRawLevels)) {
      return false;
    }
    HVACRawLevels that = (HVACRawLevels) o;
    return (getRawValue() == that.getRawValue()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getRawValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
