/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetDataType {
  NULL((short) 0),
  BOOLEAN((short) 1),
  UNSIGNED_INTEGER((short) 2),
  SIGNED_INTEGER((short) 3),
  REAL((short) 4),
  DOUBLE((short) 5),
  OCTET_STRING((short) 6),
  CHARACTER_STRING((short) 7),
  BIT_STRING((short) 8),
  ENUMERATED((short) 9),
  DATE((short) 10),
  TIME((short) 11),
  BACNET_OBJECT_IDENTIFIER((short) 12),
  UNKNOWN((short) 33);
  private static final Map<Short, BACnetDataType> map;

  static {
    map = new HashMap<>();
    for (BACnetDataType value : BACnetDataType.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  BACnetDataType(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static BACnetDataType enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
