/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetActionList implements Message {

  // Properties.
  protected final BACnetOpeningTag innerOpeningTag;
  protected final List<BACnetActionCommand> action;
  protected final BACnetClosingTag innerClosingTag;

  public BACnetActionList(
      BACnetOpeningTag innerOpeningTag,
      List<BACnetActionCommand> action,
      BACnetClosingTag innerClosingTag) {
    super();
    this.innerOpeningTag = innerOpeningTag;
    this.action = action;
    this.innerClosingTag = innerClosingTag;
  }

  public BACnetOpeningTag getInnerOpeningTag() {
    return innerOpeningTag;
  }

  public List<BACnetActionCommand> getAction() {
    return action;
  }

  public BACnetClosingTag getInnerClosingTag() {
    return innerClosingTag;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetActionList");

    // Simple Field (innerOpeningTag)
    writeSimpleField("innerOpeningTag", innerOpeningTag, writeComplex(writeBuffer));

    // Array Field (action)
    writeComplexTypeArrayField("action", action, writeBuffer);

    // Simple Field (innerClosingTag)
    writeSimpleField("innerClosingTag", innerClosingTag, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetActionList");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetActionList _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (innerOpeningTag)
    lengthInBits += innerOpeningTag.getLengthInBits();

    // Array field
    if (action != null) {
      for (Message element : action) {
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (innerClosingTag)
    lengthInBits += innerClosingTag.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetActionList staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetActionList");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetOpeningTag innerOpeningTag =
        readSimpleField(
            "innerOpeningTag",
            readComplex(() -> BACnetOpeningTag.staticParse(readBuffer, (short) (0)), readBuffer));

    List<BACnetActionCommand> action =
        readTerminatedArrayField(
            "action",
            readComplex(() -> BACnetActionCommand.staticParse(readBuffer), readBuffer),
            () ->
                ((boolean)
                    (org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper
                        .isBACnetConstructedDataClosingTag(readBuffer, false, 0))));

    BACnetClosingTag innerClosingTag =
        readSimpleField(
            "innerClosingTag",
            readComplex(() -> BACnetClosingTag.staticParse(readBuffer, (short) (0)), readBuffer));

    readBuffer.closeContext("BACnetActionList");
    // Create the instance
    BACnetActionList _bACnetActionList;
    _bACnetActionList = new BACnetActionList(innerOpeningTag, action, innerClosingTag);
    return _bACnetActionList;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetActionList)) {
      return false;
    }
    BACnetActionList that = (BACnetActionList) o;
    return (getInnerOpeningTag() == that.getInnerOpeningTag())
        && (getAction() == that.getAction())
        && (getInnerClosingTag() == that.getInnerClosingTag())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getInnerOpeningTag(), getAction(), getInnerClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
