/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ConfigurationUpdateType is an enum
type ConfigurationUpdateType uint32

type IConfigurationUpdateType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	ConfigurationUpdateType_configurationUpdateTypeInsert          ConfigurationUpdateType = 1
	ConfigurationUpdateType_configurationUpdateTypeReplace         ConfigurationUpdateType = 2
	ConfigurationUpdateType_configurationUpdateTypeInsertOrReplace ConfigurationUpdateType = 3
	ConfigurationUpdateType_configurationUpdateTypeDelete          ConfigurationUpdateType = 4
)

var ConfigurationUpdateTypeValues []ConfigurationUpdateType

func init() {
	_ = errors.New
	ConfigurationUpdateTypeValues = []ConfigurationUpdateType{
		ConfigurationUpdateType_configurationUpdateTypeInsert,
		ConfigurationUpdateType_configurationUpdateTypeReplace,
		ConfigurationUpdateType_configurationUpdateTypeInsertOrReplace,
		ConfigurationUpdateType_configurationUpdateTypeDelete,
	}
}

func ConfigurationUpdateTypeByValue(value uint32) (enum ConfigurationUpdateType, ok bool) {
	switch value {
	case 1:
		return ConfigurationUpdateType_configurationUpdateTypeInsert, true
	case 2:
		return ConfigurationUpdateType_configurationUpdateTypeReplace, true
	case 3:
		return ConfigurationUpdateType_configurationUpdateTypeInsertOrReplace, true
	case 4:
		return ConfigurationUpdateType_configurationUpdateTypeDelete, true
	}
	return 0, false
}

func ConfigurationUpdateTypeByName(value string) (enum ConfigurationUpdateType, ok bool) {
	switch value {
	case "configurationUpdateTypeInsert":
		return ConfigurationUpdateType_configurationUpdateTypeInsert, true
	case "configurationUpdateTypeReplace":
		return ConfigurationUpdateType_configurationUpdateTypeReplace, true
	case "configurationUpdateTypeInsertOrReplace":
		return ConfigurationUpdateType_configurationUpdateTypeInsertOrReplace, true
	case "configurationUpdateTypeDelete":
		return ConfigurationUpdateType_configurationUpdateTypeDelete, true
	}
	return 0, false
}

func ConfigurationUpdateTypeKnows(value uint32) bool {
	for _, typeValue := range ConfigurationUpdateTypeValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastConfigurationUpdateType(structType any) ConfigurationUpdateType {
	castFunc := func(typ any) ConfigurationUpdateType {
		if sConfigurationUpdateType, ok := typ.(ConfigurationUpdateType); ok {
			return sConfigurationUpdateType
		}
		return 0
	}
	return castFunc(structType)
}

func (m ConfigurationUpdateType) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m ConfigurationUpdateType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ConfigurationUpdateTypeParse(ctx context.Context, theBytes []byte) (ConfigurationUpdateType, error) {
	return ConfigurationUpdateTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ConfigurationUpdateTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ConfigurationUpdateType, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("ConfigurationUpdateType", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading ConfigurationUpdateType")
	}
	if enum, ok := ConfigurationUpdateTypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for ConfigurationUpdateType")
		return ConfigurationUpdateType(val), nil
	} else {
		return enum, nil
	}
}

func (e ConfigurationUpdateType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e ConfigurationUpdateType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("ConfigurationUpdateType", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e ConfigurationUpdateType) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e ConfigurationUpdateType) PLC4XEnumName() string {
	switch e {
	case ConfigurationUpdateType_configurationUpdateTypeInsert:
		return "configurationUpdateTypeInsert"
	case ConfigurationUpdateType_configurationUpdateTypeReplace:
		return "configurationUpdateTypeReplace"
	case ConfigurationUpdateType_configurationUpdateTypeInsertOrReplace:
		return "configurationUpdateTypeInsertOrReplace"
	case ConfigurationUpdateType_configurationUpdateTypeDelete:
		return "configurationUpdateTypeDelete"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e ConfigurationUpdateType) String() string {
	return e.PLC4XEnumName()
}
