/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const CEMIAdditionalInformationBusmonitorInfo_LEN uint8 = uint8(1)

// CEMIAdditionalInformationBusmonitorInfo is the corresponding interface of CEMIAdditionalInformationBusmonitorInfo
type CEMIAdditionalInformationBusmonitorInfo interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CEMIAdditionalInformation
	// GetFrameErrorFlag returns FrameErrorFlag (property field)
	GetFrameErrorFlag() bool
	// GetBitErrorFlag returns BitErrorFlag (property field)
	GetBitErrorFlag() bool
	// GetParityErrorFlag returns ParityErrorFlag (property field)
	GetParityErrorFlag() bool
	// GetUnknownFlag returns UnknownFlag (property field)
	GetUnknownFlag() bool
	// GetLostFlag returns LostFlag (property field)
	GetLostFlag() bool
	// GetSequenceNumber returns SequenceNumber (property field)
	GetSequenceNumber() uint8
	// IsCEMIAdditionalInformationBusmonitorInfo is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCEMIAdditionalInformationBusmonitorInfo()
	// CreateBuilder creates a CEMIAdditionalInformationBusmonitorInfoBuilder
	CreateCEMIAdditionalInformationBusmonitorInfoBuilder() CEMIAdditionalInformationBusmonitorInfoBuilder
}

// _CEMIAdditionalInformationBusmonitorInfo is the data-structure of this message
type _CEMIAdditionalInformationBusmonitorInfo struct {
	CEMIAdditionalInformationContract
	FrameErrorFlag  bool
	BitErrorFlag    bool
	ParityErrorFlag bool
	UnknownFlag     bool
	LostFlag        bool
	SequenceNumber  uint8
}

var _ CEMIAdditionalInformationBusmonitorInfo = (*_CEMIAdditionalInformationBusmonitorInfo)(nil)
var _ CEMIAdditionalInformationRequirements = (*_CEMIAdditionalInformationBusmonitorInfo)(nil)

// NewCEMIAdditionalInformationBusmonitorInfo factory function for _CEMIAdditionalInformationBusmonitorInfo
func NewCEMIAdditionalInformationBusmonitorInfo(frameErrorFlag bool, bitErrorFlag bool, parityErrorFlag bool, unknownFlag bool, lostFlag bool, sequenceNumber uint8) *_CEMIAdditionalInformationBusmonitorInfo {
	_result := &_CEMIAdditionalInformationBusmonitorInfo{
		CEMIAdditionalInformationContract: NewCEMIAdditionalInformation(),
		FrameErrorFlag:                    frameErrorFlag,
		BitErrorFlag:                      bitErrorFlag,
		ParityErrorFlag:                   parityErrorFlag,
		UnknownFlag:                       unknownFlag,
		LostFlag:                          lostFlag,
		SequenceNumber:                    sequenceNumber,
	}
	_result.CEMIAdditionalInformationContract.(*_CEMIAdditionalInformation)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CEMIAdditionalInformationBusmonitorInfoBuilder is a builder for CEMIAdditionalInformationBusmonitorInfo
type CEMIAdditionalInformationBusmonitorInfoBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(frameErrorFlag bool, bitErrorFlag bool, parityErrorFlag bool, unknownFlag bool, lostFlag bool, sequenceNumber uint8) CEMIAdditionalInformationBusmonitorInfoBuilder
	// WithFrameErrorFlag adds FrameErrorFlag (property field)
	WithFrameErrorFlag(bool) CEMIAdditionalInformationBusmonitorInfoBuilder
	// WithBitErrorFlag adds BitErrorFlag (property field)
	WithBitErrorFlag(bool) CEMIAdditionalInformationBusmonitorInfoBuilder
	// WithParityErrorFlag adds ParityErrorFlag (property field)
	WithParityErrorFlag(bool) CEMIAdditionalInformationBusmonitorInfoBuilder
	// WithUnknownFlag adds UnknownFlag (property field)
	WithUnknownFlag(bool) CEMIAdditionalInformationBusmonitorInfoBuilder
	// WithLostFlag adds LostFlag (property field)
	WithLostFlag(bool) CEMIAdditionalInformationBusmonitorInfoBuilder
	// WithSequenceNumber adds SequenceNumber (property field)
	WithSequenceNumber(uint8) CEMIAdditionalInformationBusmonitorInfoBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CEMIAdditionalInformationBuilder
	// Build builds the CEMIAdditionalInformationBusmonitorInfo or returns an error if something is wrong
	Build() (CEMIAdditionalInformationBusmonitorInfo, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CEMIAdditionalInformationBusmonitorInfo
}

// NewCEMIAdditionalInformationBusmonitorInfoBuilder() creates a CEMIAdditionalInformationBusmonitorInfoBuilder
func NewCEMIAdditionalInformationBusmonitorInfoBuilder() CEMIAdditionalInformationBusmonitorInfoBuilder {
	return &_CEMIAdditionalInformationBusmonitorInfoBuilder{_CEMIAdditionalInformationBusmonitorInfo: new(_CEMIAdditionalInformationBusmonitorInfo)}
}

type _CEMIAdditionalInformationBusmonitorInfoBuilder struct {
	*_CEMIAdditionalInformationBusmonitorInfo

	parentBuilder *_CEMIAdditionalInformationBuilder

	collectedErr []error
}

var _ (CEMIAdditionalInformationBusmonitorInfoBuilder) = (*_CEMIAdditionalInformationBusmonitorInfoBuilder)(nil)

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) setParent(contract CEMIAdditionalInformationContract) {
	b.CEMIAdditionalInformationContract = contract
	contract.(*_CEMIAdditionalInformation)._SubType = b._CEMIAdditionalInformationBusmonitorInfo
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) WithMandatoryFields(frameErrorFlag bool, bitErrorFlag bool, parityErrorFlag bool, unknownFlag bool, lostFlag bool, sequenceNumber uint8) CEMIAdditionalInformationBusmonitorInfoBuilder {
	return b.WithFrameErrorFlag(frameErrorFlag).WithBitErrorFlag(bitErrorFlag).WithParityErrorFlag(parityErrorFlag).WithUnknownFlag(unknownFlag).WithLostFlag(lostFlag).WithSequenceNumber(sequenceNumber)
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) WithFrameErrorFlag(frameErrorFlag bool) CEMIAdditionalInformationBusmonitorInfoBuilder {
	b.FrameErrorFlag = frameErrorFlag
	return b
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) WithBitErrorFlag(bitErrorFlag bool) CEMIAdditionalInformationBusmonitorInfoBuilder {
	b.BitErrorFlag = bitErrorFlag
	return b
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) WithParityErrorFlag(parityErrorFlag bool) CEMIAdditionalInformationBusmonitorInfoBuilder {
	b.ParityErrorFlag = parityErrorFlag
	return b
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) WithUnknownFlag(unknownFlag bool) CEMIAdditionalInformationBusmonitorInfoBuilder {
	b.UnknownFlag = unknownFlag
	return b
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) WithLostFlag(lostFlag bool) CEMIAdditionalInformationBusmonitorInfoBuilder {
	b.LostFlag = lostFlag
	return b
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) WithSequenceNumber(sequenceNumber uint8) CEMIAdditionalInformationBusmonitorInfoBuilder {
	b.SequenceNumber = sequenceNumber
	return b
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) Build() (CEMIAdditionalInformationBusmonitorInfo, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CEMIAdditionalInformationBusmonitorInfo.deepCopy(), nil
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) MustBuild() CEMIAdditionalInformationBusmonitorInfo {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) Done() CEMIAdditionalInformationBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCEMIAdditionalInformationBuilder().(*_CEMIAdditionalInformationBuilder)
	}
	return b.parentBuilder
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) buildForCEMIAdditionalInformation() (CEMIAdditionalInformation, error) {
	return b.Build()
}

func (b *_CEMIAdditionalInformationBusmonitorInfoBuilder) DeepCopy() any {
	_copy := b.CreateCEMIAdditionalInformationBusmonitorInfoBuilder().(*_CEMIAdditionalInformationBusmonitorInfoBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCEMIAdditionalInformationBusmonitorInfoBuilder creates a CEMIAdditionalInformationBusmonitorInfoBuilder
func (b *_CEMIAdditionalInformationBusmonitorInfo) CreateCEMIAdditionalInformationBusmonitorInfoBuilder() CEMIAdditionalInformationBusmonitorInfoBuilder {
	if b == nil {
		return NewCEMIAdditionalInformationBusmonitorInfoBuilder()
	}
	return &_CEMIAdditionalInformationBusmonitorInfoBuilder{_CEMIAdditionalInformationBusmonitorInfo: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetAdditionalInformationType() uint8 {
	return 0x03
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetParent() CEMIAdditionalInformationContract {
	return m.CEMIAdditionalInformationContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetFrameErrorFlag() bool {
	return m.FrameErrorFlag
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetBitErrorFlag() bool {
	return m.BitErrorFlag
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetParityErrorFlag() bool {
	return m.ParityErrorFlag
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetUnknownFlag() bool {
	return m.UnknownFlag
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetLostFlag() bool {
	return m.LostFlag
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetSequenceNumber() uint8 {
	return m.SequenceNumber
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetLen() uint8 {
	return CEMIAdditionalInformationBusmonitorInfo_LEN
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCEMIAdditionalInformationBusmonitorInfo(structType any) CEMIAdditionalInformationBusmonitorInfo {
	if casted, ok := structType.(CEMIAdditionalInformationBusmonitorInfo); ok {
		return casted
	}
	if casted, ok := structType.(*CEMIAdditionalInformationBusmonitorInfo); ok {
		return *casted
	}
	return nil
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetTypeName() string {
	return "CEMIAdditionalInformationBusmonitorInfo"
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CEMIAdditionalInformationContract.(*_CEMIAdditionalInformation).getLengthInBits(ctx))

	// Const Field (len)
	lengthInBits += 8

	// Simple field (frameErrorFlag)
	lengthInBits += 1

	// Simple field (bitErrorFlag)
	lengthInBits += 1

	// Simple field (parityErrorFlag)
	lengthInBits += 1

	// Simple field (unknownFlag)
	lengthInBits += 1

	// Simple field (lostFlag)
	lengthInBits += 1

	// Simple field (sequenceNumber)
	lengthInBits += 3

	return lengthInBits
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CEMIAdditionalInformation) (__cEMIAdditionalInformationBusmonitorInfo CEMIAdditionalInformationBusmonitorInfo, err error) {
	m.CEMIAdditionalInformationContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CEMIAdditionalInformationBusmonitorInfo"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CEMIAdditionalInformationBusmonitorInfo")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	len, err := ReadConstField[uint8](ctx, "len", ReadUnsignedByte(readBuffer, uint8(8)), CEMIAdditionalInformationBusmonitorInfo_LEN)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'len' field"))
	}
	_ = len

	frameErrorFlag, err := ReadSimpleField(ctx, "frameErrorFlag", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'frameErrorFlag' field"))
	}
	m.FrameErrorFlag = frameErrorFlag

	bitErrorFlag, err := ReadSimpleField(ctx, "bitErrorFlag", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bitErrorFlag' field"))
	}
	m.BitErrorFlag = bitErrorFlag

	parityErrorFlag, err := ReadSimpleField(ctx, "parityErrorFlag", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'parityErrorFlag' field"))
	}
	m.ParityErrorFlag = parityErrorFlag

	unknownFlag, err := ReadSimpleField(ctx, "unknownFlag", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'unknownFlag' field"))
	}
	m.UnknownFlag = unknownFlag

	lostFlag, err := ReadSimpleField(ctx, "lostFlag", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lostFlag' field"))
	}
	m.LostFlag = lostFlag

	sequenceNumber, err := ReadSimpleField(ctx, "sequenceNumber", ReadUnsignedByte(readBuffer, uint8(3)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sequenceNumber' field"))
	}
	m.SequenceNumber = sequenceNumber

	if closeErr := readBuffer.CloseContext("CEMIAdditionalInformationBusmonitorInfo"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CEMIAdditionalInformationBusmonitorInfo")
	}

	return m, nil
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CEMIAdditionalInformationBusmonitorInfo"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CEMIAdditionalInformationBusmonitorInfo")
		}

		if err := WriteConstField(ctx, "len", CEMIAdditionalInformationBusmonitorInfo_LEN, WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'len' field")
		}

		if err := WriteSimpleField[bool](ctx, "frameErrorFlag", m.GetFrameErrorFlag(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'frameErrorFlag' field")
		}

		if err := WriteSimpleField[bool](ctx, "bitErrorFlag", m.GetBitErrorFlag(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'bitErrorFlag' field")
		}

		if err := WriteSimpleField[bool](ctx, "parityErrorFlag", m.GetParityErrorFlag(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'parityErrorFlag' field")
		}

		if err := WriteSimpleField[bool](ctx, "unknownFlag", m.GetUnknownFlag(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'unknownFlag' field")
		}

		if err := WriteSimpleField[bool](ctx, "lostFlag", m.GetLostFlag(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lostFlag' field")
		}

		if err := WriteSimpleField[uint8](ctx, "sequenceNumber", m.GetSequenceNumber(), WriteUnsignedByte(writeBuffer, 3)); err != nil {
			return errors.Wrap(err, "Error serializing 'sequenceNumber' field")
		}

		if popErr := writeBuffer.PopContext("CEMIAdditionalInformationBusmonitorInfo"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CEMIAdditionalInformationBusmonitorInfo")
		}
		return nil
	}
	return m.CEMIAdditionalInformationContract.(*_CEMIAdditionalInformation).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) IsCEMIAdditionalInformationBusmonitorInfo() {}

func (m *_CEMIAdditionalInformationBusmonitorInfo) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) deepCopy() *_CEMIAdditionalInformationBusmonitorInfo {
	if m == nil {
		return nil
	}
	_CEMIAdditionalInformationBusmonitorInfoCopy := &_CEMIAdditionalInformationBusmonitorInfo{
		m.CEMIAdditionalInformationContract.(*_CEMIAdditionalInformation).deepCopy(),
		m.FrameErrorFlag,
		m.BitErrorFlag,
		m.ParityErrorFlag,
		m.UnknownFlag,
		m.LostFlag,
		m.SequenceNumber,
	}
	_CEMIAdditionalInformationBusmonitorInfoCopy.CEMIAdditionalInformationContract.(*_CEMIAdditionalInformation)._SubType = m
	return _CEMIAdditionalInformationBusmonitorInfoCopy
}

func (m *_CEMIAdditionalInformationBusmonitorInfo) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
