/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// IdentifyReplyCommandManufacturer is the corresponding interface of IdentifyReplyCommandManufacturer
type IdentifyReplyCommandManufacturer interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	IdentifyReplyCommand
	// GetManufacturerName returns ManufacturerName (property field)
	GetManufacturerName() string
	// IsIdentifyReplyCommandManufacturer is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsIdentifyReplyCommandManufacturer()
	// CreateBuilder creates a IdentifyReplyCommandManufacturerBuilder
	CreateIdentifyReplyCommandManufacturerBuilder() IdentifyReplyCommandManufacturerBuilder
}

// _IdentifyReplyCommandManufacturer is the data-structure of this message
type _IdentifyReplyCommandManufacturer struct {
	IdentifyReplyCommandContract
	ManufacturerName string
}

var _ IdentifyReplyCommandManufacturer = (*_IdentifyReplyCommandManufacturer)(nil)
var _ IdentifyReplyCommandRequirements = (*_IdentifyReplyCommandManufacturer)(nil)

// NewIdentifyReplyCommandManufacturer factory function for _IdentifyReplyCommandManufacturer
func NewIdentifyReplyCommandManufacturer(manufacturerName string, numBytes uint8) *_IdentifyReplyCommandManufacturer {
	_result := &_IdentifyReplyCommandManufacturer{
		IdentifyReplyCommandContract: NewIdentifyReplyCommand(numBytes),
		ManufacturerName:             manufacturerName,
	}
	_result.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// IdentifyReplyCommandManufacturerBuilder is a builder for IdentifyReplyCommandManufacturer
type IdentifyReplyCommandManufacturerBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(manufacturerName string) IdentifyReplyCommandManufacturerBuilder
	// WithManufacturerName adds ManufacturerName (property field)
	WithManufacturerName(string) IdentifyReplyCommandManufacturerBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() IdentifyReplyCommandBuilder
	// Build builds the IdentifyReplyCommandManufacturer or returns an error if something is wrong
	Build() (IdentifyReplyCommandManufacturer, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() IdentifyReplyCommandManufacturer
}

// NewIdentifyReplyCommandManufacturerBuilder() creates a IdentifyReplyCommandManufacturerBuilder
func NewIdentifyReplyCommandManufacturerBuilder() IdentifyReplyCommandManufacturerBuilder {
	return &_IdentifyReplyCommandManufacturerBuilder{_IdentifyReplyCommandManufacturer: new(_IdentifyReplyCommandManufacturer)}
}

type _IdentifyReplyCommandManufacturerBuilder struct {
	*_IdentifyReplyCommandManufacturer

	parentBuilder *_IdentifyReplyCommandBuilder

	collectedErr []error
}

var _ (IdentifyReplyCommandManufacturerBuilder) = (*_IdentifyReplyCommandManufacturerBuilder)(nil)

func (b *_IdentifyReplyCommandManufacturerBuilder) setParent(contract IdentifyReplyCommandContract) {
	b.IdentifyReplyCommandContract = contract
	contract.(*_IdentifyReplyCommand)._SubType = b._IdentifyReplyCommandManufacturer
}

func (b *_IdentifyReplyCommandManufacturerBuilder) WithMandatoryFields(manufacturerName string) IdentifyReplyCommandManufacturerBuilder {
	return b.WithManufacturerName(manufacturerName)
}

func (b *_IdentifyReplyCommandManufacturerBuilder) WithManufacturerName(manufacturerName string) IdentifyReplyCommandManufacturerBuilder {
	b.ManufacturerName = manufacturerName
	return b
}

func (b *_IdentifyReplyCommandManufacturerBuilder) Build() (IdentifyReplyCommandManufacturer, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._IdentifyReplyCommandManufacturer.deepCopy(), nil
}

func (b *_IdentifyReplyCommandManufacturerBuilder) MustBuild() IdentifyReplyCommandManufacturer {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_IdentifyReplyCommandManufacturerBuilder) Done() IdentifyReplyCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewIdentifyReplyCommandBuilder().(*_IdentifyReplyCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_IdentifyReplyCommandManufacturerBuilder) buildForIdentifyReplyCommand() (IdentifyReplyCommand, error) {
	return b.Build()
}

func (b *_IdentifyReplyCommandManufacturerBuilder) DeepCopy() any {
	_copy := b.CreateIdentifyReplyCommandManufacturerBuilder().(*_IdentifyReplyCommandManufacturerBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateIdentifyReplyCommandManufacturerBuilder creates a IdentifyReplyCommandManufacturerBuilder
func (b *_IdentifyReplyCommandManufacturer) CreateIdentifyReplyCommandManufacturerBuilder() IdentifyReplyCommandManufacturerBuilder {
	if b == nil {
		return NewIdentifyReplyCommandManufacturerBuilder()
	}
	return &_IdentifyReplyCommandManufacturerBuilder{_IdentifyReplyCommandManufacturer: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_IdentifyReplyCommandManufacturer) GetAttribute() Attribute {
	return Attribute_Manufacturer
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_IdentifyReplyCommandManufacturer) GetParent() IdentifyReplyCommandContract {
	return m.IdentifyReplyCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_IdentifyReplyCommandManufacturer) GetManufacturerName() string {
	return m.ManufacturerName
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastIdentifyReplyCommandManufacturer(structType any) IdentifyReplyCommandManufacturer {
	if casted, ok := structType.(IdentifyReplyCommandManufacturer); ok {
		return casted
	}
	if casted, ok := structType.(*IdentifyReplyCommandManufacturer); ok {
		return *casted
	}
	return nil
}

func (m *_IdentifyReplyCommandManufacturer) GetTypeName() string {
	return "IdentifyReplyCommandManufacturer"
}

func (m *_IdentifyReplyCommandManufacturer) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).getLengthInBits(ctx))

	// Simple field (manufacturerName)
	lengthInBits += 64

	return lengthInBits
}

func (m *_IdentifyReplyCommandManufacturer) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_IdentifyReplyCommandManufacturer) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_IdentifyReplyCommand, attribute Attribute, numBytes uint8) (__identifyReplyCommandManufacturer IdentifyReplyCommandManufacturer, err error) {
	m.IdentifyReplyCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("IdentifyReplyCommandManufacturer"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for IdentifyReplyCommandManufacturer")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	manufacturerName, err := ReadSimpleField(ctx, "manufacturerName", ReadString(readBuffer, uint32(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'manufacturerName' field"))
	}
	m.ManufacturerName = manufacturerName

	if closeErr := readBuffer.CloseContext("IdentifyReplyCommandManufacturer"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for IdentifyReplyCommandManufacturer")
	}

	return m, nil
}

func (m *_IdentifyReplyCommandManufacturer) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_IdentifyReplyCommandManufacturer) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("IdentifyReplyCommandManufacturer"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for IdentifyReplyCommandManufacturer")
		}

		if err := WriteSimpleField[string](ctx, "manufacturerName", m.GetManufacturerName(), WriteString(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'manufacturerName' field")
		}

		if popErr := writeBuffer.PopContext("IdentifyReplyCommandManufacturer"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for IdentifyReplyCommandManufacturer")
		}
		return nil
	}
	return m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_IdentifyReplyCommandManufacturer) IsIdentifyReplyCommandManufacturer() {}

func (m *_IdentifyReplyCommandManufacturer) DeepCopy() any {
	return m.deepCopy()
}

func (m *_IdentifyReplyCommandManufacturer) deepCopy() *_IdentifyReplyCommandManufacturer {
	if m == nil {
		return nil
	}
	_IdentifyReplyCommandManufacturerCopy := &_IdentifyReplyCommandManufacturer{
		m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).deepCopy(),
		m.ManufacturerName,
	}
	_IdentifyReplyCommandManufacturerCopy.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = m
	return _IdentifyReplyCommandManufacturerCopy
}

func (m *_IdentifyReplyCommandManufacturer) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
