/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetReadAccessResult is the corresponding interface of BACnetReadAccessResult
type BACnetReadAccessResult interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetContextTagObjectIdentifier
	// GetListOfResults returns ListOfResults (property field)
	GetListOfResults() BACnetReadAccessResultListOfResults
	// IsBACnetReadAccessResult is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetReadAccessResult()
	// CreateBuilder creates a BACnetReadAccessResultBuilder
	CreateBACnetReadAccessResultBuilder() BACnetReadAccessResultBuilder
}

// _BACnetReadAccessResult is the data-structure of this message
type _BACnetReadAccessResult struct {
	ObjectIdentifier BACnetContextTagObjectIdentifier
	ListOfResults    BACnetReadAccessResultListOfResults
}

var _ BACnetReadAccessResult = (*_BACnetReadAccessResult)(nil)

// NewBACnetReadAccessResult factory function for _BACnetReadAccessResult
func NewBACnetReadAccessResult(objectIdentifier BACnetContextTagObjectIdentifier, listOfResults BACnetReadAccessResultListOfResults) *_BACnetReadAccessResult {
	if objectIdentifier == nil {
		panic("objectIdentifier of type BACnetContextTagObjectIdentifier for BACnetReadAccessResult must not be nil")
	}
	return &_BACnetReadAccessResult{ObjectIdentifier: objectIdentifier, ListOfResults: listOfResults}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetReadAccessResultBuilder is a builder for BACnetReadAccessResult
type BACnetReadAccessResultBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier) BACnetReadAccessResultBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithObjectIdentifier(BACnetContextTagObjectIdentifier) BACnetReadAccessResultBuilder
	// WithObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithObjectIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetReadAccessResultBuilder
	// WithListOfResults adds ListOfResults (property field)
	WithOptionalListOfResults(BACnetReadAccessResultListOfResults) BACnetReadAccessResultBuilder
	// WithOptionalListOfResultsBuilder adds ListOfResults (property field) which is build by the builder
	WithOptionalListOfResultsBuilder(func(BACnetReadAccessResultListOfResultsBuilder) BACnetReadAccessResultListOfResultsBuilder) BACnetReadAccessResultBuilder
	// Build builds the BACnetReadAccessResult or returns an error if something is wrong
	Build() (BACnetReadAccessResult, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetReadAccessResult
}

// NewBACnetReadAccessResultBuilder() creates a BACnetReadAccessResultBuilder
func NewBACnetReadAccessResultBuilder() BACnetReadAccessResultBuilder {
	return &_BACnetReadAccessResultBuilder{_BACnetReadAccessResult: new(_BACnetReadAccessResult)}
}

type _BACnetReadAccessResultBuilder struct {
	*_BACnetReadAccessResult

	collectedErr []error
}

var _ (BACnetReadAccessResultBuilder) = (*_BACnetReadAccessResultBuilder)(nil)

func (b *_BACnetReadAccessResultBuilder) WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier) BACnetReadAccessResultBuilder {
	return b.WithObjectIdentifier(objectIdentifier)
}

func (b *_BACnetReadAccessResultBuilder) WithObjectIdentifier(objectIdentifier BACnetContextTagObjectIdentifier) BACnetReadAccessResultBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetReadAccessResultBuilder) WithObjectIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetReadAccessResultBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetReadAccessResultBuilder) WithOptionalListOfResults(listOfResults BACnetReadAccessResultListOfResults) BACnetReadAccessResultBuilder {
	b.ListOfResults = listOfResults
	return b
}

func (b *_BACnetReadAccessResultBuilder) WithOptionalListOfResultsBuilder(builderSupplier func(BACnetReadAccessResultListOfResultsBuilder) BACnetReadAccessResultListOfResultsBuilder) BACnetReadAccessResultBuilder {
	builder := builderSupplier(b.ListOfResults.CreateBACnetReadAccessResultListOfResultsBuilder())
	var err error
	b.ListOfResults, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetReadAccessResultListOfResultsBuilder failed"))
	}
	return b
}

func (b *_BACnetReadAccessResultBuilder) Build() (BACnetReadAccessResult, error) {
	if b.ObjectIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'objectIdentifier' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetReadAccessResult.deepCopy(), nil
}

func (b *_BACnetReadAccessResultBuilder) MustBuild() BACnetReadAccessResult {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetReadAccessResultBuilder) DeepCopy() any {
	_copy := b.CreateBACnetReadAccessResultBuilder().(*_BACnetReadAccessResultBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetReadAccessResultBuilder creates a BACnetReadAccessResultBuilder
func (b *_BACnetReadAccessResult) CreateBACnetReadAccessResultBuilder() BACnetReadAccessResultBuilder {
	if b == nil {
		return NewBACnetReadAccessResultBuilder()
	}
	return &_BACnetReadAccessResultBuilder{_BACnetReadAccessResult: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetReadAccessResult) GetObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetReadAccessResult) GetListOfResults() BACnetReadAccessResultListOfResults {
	return m.ListOfResults
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetReadAccessResult(structType any) BACnetReadAccessResult {
	if casted, ok := structType.(BACnetReadAccessResult); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetReadAccessResult); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetReadAccessResult) GetTypeName() string {
	return "BACnetReadAccessResult"
}

func (m *_BACnetReadAccessResult) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (objectIdentifier)
	lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)

	// Optional Field (listOfResults)
	if m.ListOfResults != nil {
		lengthInBits += m.ListOfResults.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_BACnetReadAccessResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetReadAccessResultParse(ctx context.Context, theBytes []byte) (BACnetReadAccessResult, error) {
	return BACnetReadAccessResultParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetReadAccessResultParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReadAccessResult, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReadAccessResult, error) {
		return BACnetReadAccessResultParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetReadAccessResultParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReadAccessResult, error) {
	v, err := (&_BACnetReadAccessResult{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetReadAccessResult) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetReadAccessResult BACnetReadAccessResult, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetReadAccessResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetReadAccessResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	m.ObjectIdentifier = objectIdentifier

	var listOfResults BACnetReadAccessResultListOfResults
	_listOfResults, err := ReadOptionalField[BACnetReadAccessResultListOfResults](ctx, "listOfResults", ReadComplex[BACnetReadAccessResultListOfResults](BACnetReadAccessResultListOfResultsParseWithBufferProducer((uint8)(uint8(1)), (BACnetObjectType)(objectIdentifier.GetObjectType())), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfResults' field"))
	}
	if _listOfResults != nil {
		listOfResults = *_listOfResults
		m.ListOfResults = listOfResults
	}

	if closeErr := readBuffer.CloseContext("BACnetReadAccessResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetReadAccessResult")
	}

	return m, nil
}

func (m *_BACnetReadAccessResult) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetReadAccessResult) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetReadAccessResult"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetReadAccessResult")
	}

	if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", m.GetObjectIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
	}

	if err := WriteOptionalField[BACnetReadAccessResultListOfResults](ctx, "listOfResults", GetRef(m.GetListOfResults()), WriteComplex[BACnetReadAccessResultListOfResults](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'listOfResults' field")
	}

	if popErr := writeBuffer.PopContext("BACnetReadAccessResult"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetReadAccessResult")
	}
	return nil
}

func (m *_BACnetReadAccessResult) IsBACnetReadAccessResult() {}

func (m *_BACnetReadAccessResult) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetReadAccessResult) deepCopy() *_BACnetReadAccessResult {
	if m == nil {
		return nil
	}
	_BACnetReadAccessResultCopy := &_BACnetReadAccessResult{
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.ObjectIdentifier),
		utils.DeepCopy[BACnetReadAccessResultListOfResults](m.ListOfResults),
	}
	return _BACnetReadAccessResultCopy
}

func (m *_BACnetReadAccessResult) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
