/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.annotation;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.annotation.AnnotationValidatorFactory;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public abstract class AnnotationValidator {
    private AnnotationValidatorFactory annotFact = null;
    protected PreflightContext ctx = null;
    private COSDocument cosDocument = null;
    protected COSDictionary annotDictionary = null;
    protected PDAnnotation pdAnnot = null;

    public AnnotationValidator(PreflightContext context, COSDictionary annotDictionary) {
        this.ctx = context;
        this.annotDictionary = annotDictionary;
        this.cosDocument = this.ctx.getDocument().getDocument();
    }

    protected boolean checkFlags() {
        boolean result = this.pdAnnot.isPrinted();
        result = result && !this.pdAnnot.isHidden();
        result = result && !this.pdAnnot.isInvisible();
        boolean bl = result = result && !this.pdAnnot.isNoView();
        if (!result) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.2.2", "Flags of " + this.pdAnnot.getSubtype() + " annotation are invalid"));
        }
        return result;
    }

    protected boolean checkCA() {
        float caf;
        COSBase ca = this.pdAnnot.getCOSObject().getItem(COSName.CA);
        if (ca != null && (caf = COSUtils.getAsFloat(ca, this.cosDocument).floatValue()) != 1.0f) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.2", "CA entry is invalid. Expected 1.0 / Read " + caf));
            return false;
        }
        return true;
    }

    protected boolean checkColors() throws ValidationException {
        if (this.pdAnnot.getColor() != null && !this.searchRGBProfile()) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.2.3", "Annotation uses a Color profile which isn't the same than the profile contained by the OutputIntent"));
            return false;
        }
        return true;
    }

    protected boolean searchRGBProfile() throws ValidationException {
        ICCProfileWrapper iccpw = ICCProfileWrapper.getOrSearchICCProfile(this.ctx);
        if (iccpw != null) {
            return iccpw.isRGBColorSpace();
        }
        return false;
    }

    protected boolean checkAP() throws ValidationException {
        PDAppearanceDictionary ap = this.pdAnnot.getAppearance();
        if (ap != null) {
            COSDictionary apDict = ap.getCOSObject();
            if (apDict.getItem(COSName.D) != null || apDict.getItem(COSName.R) != null) {
                this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "Only the N Appearance is authorized"));
                return false;
            }
            if (apDict.getItem(COSName.N) == null) {
                this.ctx.addValidationError(new ValidationResult.ValidationError("5.1.2", "The N Appearance must be present"));
                return false;
            }
            COSBase apn = apDict.getItem(COSName.N);
            COSBase subtype = this.annotDictionary.getItem(COSName.SUBTYPE);
            COSBase ft = this.getFieldType();
            if (COSName.WIDGET.equals((Object)subtype) && COSName.BTN.equals((Object)ft)) {
                if (COSUtils.isStream(apn, this.cosDocument)) {
                    this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "The N Appearance of a Btn widget must not be a stream, but an appearance subdictionary"));
                    ContextHelper.validateElement(this.ctx, new PDFormXObject(COSUtils.getAsStream(apn, this.cosDocument)), "graphic-process");
                    return false;
                }
                if (!COSUtils.isDictionary(apn, this.cosDocument)) {
                    this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "The N Appearance must be an appearance subdictionary"));
                    return false;
                }
                COSDictionary apnDict = COSUtils.getAsDictionary(apn, this.cosDocument);
                if (this.pdAnnot.getAppearanceState() == null) {
                    this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "The appearance state is required if the appearance contains a subdictionary"));
                    return false;
                }
                if (apnDict.size() == 0) {
                    this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "The N Appearance of a Btn widget must not be empty"));
                    return false;
                }
                for (COSBase val : apnDict.getValues()) {
                    COSStream strm = COSUtils.getAsStream(val, this.cosDocument);
                    if (!(strm instanceof COSStream)) {
                        this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "The N Appearance of a Btn widget must be a stream"));
                        return false;
                    }
                    ContextHelper.validateElement(this.ctx, new PDFormXObject(strm), "graphic-process");
                }
            } else {
                if (!COSUtils.isStream(apn, this.cosDocument)) {
                    this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "The N Appearance must be a Stream"));
                    return false;
                }
                ContextHelper.validateElement(this.ctx, new PDFormXObject(COSUtils.getAsStream(apn, this.cosDocument)), "graphic-process");
            }
        } else if (this.pdAnnot instanceof PDAnnotationWidget && this.pdAnnot.getAppearance() == null) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.1", "widget annotation lacks an appearance dictionary"));
            return false;
        }
        return true;
    }

    protected boolean checkActions() throws ValidationException {
        ContextHelper.validateElement(this.ctx, this.annotDictionary, "actions-process");
        return true;
    }

    protected boolean checkPopup() throws ValidationException {
        COSBase cosPopup = this.annotDictionary.getItem("Popup");
        if (cosPopup != null) {
            COSDictionary popupDict = COSUtils.getAsDictionary(cosPopup, this.cosDocument);
            if (popupDict == null) {
                this.ctx.addValidationError(new ValidationResult.ValidationError("1.2.3", "An Annotation has a Popup entry, but the value is missing or isn't a dictionary"));
                return false;
            }
            AnnotationValidator popupVal = this.annotFact.getAnnotationValidator(this.ctx, popupDict);
            return popupVal.validate();
        }
        return true;
    }

    public boolean validate() throws ValidationException {
        boolean isValid = this.checkMandatoryFields();
        isValid = this.checkFlags() && isValid;
        isValid = this.checkColors() && isValid;
        isValid = this.checkAP() && isValid;
        isValid = this.checkCA() && isValid;
        isValid = this.checkActions() && isValid;
        isValid = this.checkPopup() && isValid;
        return isValid;
    }

    protected boolean checkMandatoryFields() {
        boolean result;
        boolean subtype = this.annotDictionary.containsKey(COSName.SUBTYPE);
        boolean rect = this.annotDictionary.containsKey(COSName.RECT);
        boolean bl = result = subtype && rect && this.checkSpecificMandatoryFields();
        if (!result) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.1", "A mandatory field for the " + this.pdAnnot.getSubtype() + " annotation is missing"));
        }
        return result;
    }

    protected boolean checkSpecificMandatoryFields() {
        return true;
    }

    public final void setFactory(AnnotationValidatorFactory fact) {
        this.annotFact = fact;
    }

    private COSBase getFieldType() {
        COSBase parentBase;
        COSBase ft = this.annotDictionary.getDictionaryObject(COSName.FT);
        COSDictionary parent = this.annotDictionary;
        while (ft == null && (parentBase = parent.getDictionaryObject(COSName.PARENT)) instanceof COSDictionary) {
            parent = (COSDictionary)parentBase;
            ft = parent.getDictionaryObject(COSName.FT);
        }
        return ft;
    }
}

