/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.util.Map;
import javax.swing.text.AttributeSet;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.base.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.LexerBasedHighlightLayer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;

public class LexerBasedHighlightSequence
implements HighlightsSequence {
    private LexerBasedHighlightLayer layer;
    private Map<Token, ColoringAttributes.Coloring> colorings;
    private TokenSequence ts;
    private TokenSequence java;

    public LexerBasedHighlightSequence(LexerBasedHighlightLayer layer, TokenSequence ts, Map<Token, ColoringAttributes.Coloring> colorings) {
        this.layer = layer;
        this.ts = ts;
        this.java = ts;
        this.colorings = colorings;
    }

    @Override
    public boolean moveNext() {
        Token t;
        if (this.ts != this.java) {
            while (this.ts.moveNext()) {
                t = this.ts.token();
                if (t.id() != JavadocTokenId.IDENT || t.getProperty("javadoc-identifier") == null) continue;
                return true;
            }
            this.ts = this.java;
        }
        while (this.ts.moveNext()) {
            t = this.ts.token();
            if (t.id() == JavaTokenId.JAVADOC_COMMENT) {
                this.ts = this.ts.embedded();
                return this.moveNext();
            }
            if (t.id() != JavaTokenId.IDENTIFIER || !this.colorings.containsKey(this.ts.token())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStartOffset() {
        return this.ts.offset();
    }

    @Override
    public int getEndOffset() {
        return this.ts.offset() + this.ts.token().length();
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.ts.token().id() == JavadocTokenId.IDENT) {
            return this.layer.getColoring(ColoringAttributes.add(ColoringAttributes.empty(), ColoringAttributes.JAVADOC_IDENTIFIER));
        }
        return this.layer.getColoring(this.colorings.get(this.ts.token()));
    }
}

