/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.editor.java.JavaMoveCodeElementAction;
import org.netbeans.modules.editor.java.SelectCodeElementAction;
import org.netbeans.modules.editor.java.TypingCompletion;
import org.netbeans.modules.java.editor.codegen.InsertSemicolonAction;
import org.netbeans.modules.java.editor.fold.JavaElementFoldManager;
import org.netbeans.modules.java.editor.imports.ClipboardHandler;
import org.netbeans.modules.java.editor.imports.FastImportAction;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.editor.overridden.GoToSuperTypeAction;
import org.netbeans.modules.java.editor.rename.InstantRenameAction;
import org.netbeans.modules.java.editor.semantic.GoToMarkOccurrencesAction;
import org.netbeans.spi.editor.typinghooks.DeletedTextInterceptor;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JavaKit
extends NbEditorKit {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    static final long serialVersionUID = -5445829962533684922L;
    private static final boolean INSTANT = Boolean.getBoolean("org.netbeans.modules.java.refactoring.instantRename");
    public static final BaseTokenID LINE_COMMENT = new BaseTokenID("line-comment", 7);
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fixImportsAction = "fix-imports";
    public static final String fastImportAction = "fast-import";
    public static final String tryCatchAction = "try-catch";
    public static final String javaDocShowAction = "javadoc-show-action";
    public static final String expandAllJavadocFolds = "expand-all-javadoc-folds";
    public static final String collapseAllJavadocFolds = "collapse-all-javadoc-folds";
    public static final String expandAllCodeBlockFolds = "expand-all-code-block-folds";
    public static final String collapseAllCodeBlockFolds = "collapse-all-code-block-folds";
    public static final String selectNextElementAction = "select-element-next";
    public static final String selectPreviousElementAction = "select-element-previous";

    @Override
    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public String getSourceLevel(BaseDocument doc) {
        DataObject dob = NbEditorUtilities.getDataObject(doc);
        return dob != null ? SourceLevelQuery.getSourceLevel(dob.getPrimaryFile()) : null;
    }

    @Override
    protected void initDocument(BaseDocument doc) {
        doc.putProperty(SyntaxUpdateTokens.class, new SyntaxUpdateTokens(){
            private List tokenList = new ArrayList();

            @Override
            public void syntaxUpdateStart() {
                this.tokenList.clear();
            }

            @Override
            public List syntaxUpdateEnd() {
                return this.tokenList;
            }

            @Override
            public void syntaxUpdateToken(TokenID id, TokenContextPath contextPath, int offset, int length) {
                if (id != null && id.getNumericID() == LINE_COMMENT.getNumericID()) {
                    this.tokenList.add(new SyntaxUpdateTokens.TokenInfo(id, contextPath, offset, length));
                }
            }
        });
        InputAttributes attrs = new InputAttributes();
        attrs.setValue(JavaTokenId.language(), (Object)"fileName", () -> {
            FileObject fo = NbEditorUtilities.getFileObject(doc);
            return fo != null ? fo.getNameExt() : null;
        }, true);
        attrs.setValue(JavaTokenId.language(), (Object)"version", () -> this.getSourceLevel(doc), true);
        doc.putProperty(InputAttributes.class, attrs);
    }

    @Override
    protected Action[] createActions() {
        Action[] superActions = super.createActions();
        Action[] actions = new BaseAction[]{new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new ExtKit.ToggleCommentAction("//"), new JavaGenerateFoldPopupAction(), new InstantRenameAction(), new InsertSemicolonAction(true), new InsertSemicolonAction(false), new SelectCodeElementAction(selectNextElementAction, true), new SelectCodeElementAction(selectPreviousElementAction, false), new JavaMoveCodeElementAction("move-code-element-up", false), new JavaMoveCodeElementAction("move-code-element-down", true), new FastImportAction(), new GoToSuperTypeAction(), new GoToMarkOccurrencesAction(false), new GoToMarkOccurrencesAction(true), new ClipboardHandler.JavaCutAction()};
        Action[] value = TextAction.augmentList(superActions, actions);
        return !INSTANT ? value : this.removeInstant(value);
    }

    private Action[] removeInstant(Action[] actions) {
        LinkedList<Action> value = new LinkedList<Action>();
        for (Action action : actions) {
            if (action instanceof InstantRenameAction) continue;
            value.add(action);
        }
        return value.toArray(new Action[0]);
    }

    @Override
    public void install(JEditorPane c) {
        super.install(c);
        ClipboardHandler.install(c);
    }

    public static class JavaGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        @Override
        protected void addAdditionalItems(JTextComponent target, JMenu menu) {
            this.addAction(target, menu, JavaKit.collapseAllJavadocFolds);
            this.addAction(target, menu, JavaKit.expandAllJavadocFolds);
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(target, menu, JavaKit.collapseAllCodeBlockFolds);
            this.addAction(target, menu, JavaKit.expandAllCodeBlockFolds);
        }
    }

    public static class JavaGotoHelpAction
    extends BaseAction {
        public JavaGotoHelpAction() {
            super(142);
            this.putValue("helpID", JavaGotoHelpAction.class.getName());
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                GoToSupport.goToJavadoc(target.getDocument(), target.getCaretPosition());
            }
        }

        @Override
        public String getPopupMenuText(JTextComponent target) {
            return NbBundle.getBundle(JavaKit.class).getString("show_javadoc");
        }
    }

    public static class JavaFixImports
    extends BaseAction {
        public JavaFixImports() {
            super(14);
            this.putValue("trimmed-text", NbBundle.getBundle(JavaKit.class).getString("fix-imports-trimmed"));
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString("desc-fix-imports"));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-fix-imports"));
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            Document doc;
            Object source;
            if (target != null && (source = (doc = target.getDocument()).getProperty("stream")) instanceof DataObject) {
                FileObject fo = ((DataObject)source).getPrimaryFile();
                JavaFixAllImports.getDefault().fixAllImports(fo, target);
            }
        }

        public static final class GlobalAction
        extends MainMenuAction {
            public GlobalAction() {
                this.postSetMenu();
            }

            @Override
            protected String getMenuItemText() {
                return NbBundle.getBundle(GlobalAction.class).getString("fix-imports-main-menu-source-item");
            }

            @Override
            protected String getActionName() {
                return JavaKit.fixImportsAction;
            }
        }
    }

    public static class JavaGoToSourceAction
    extends BaseAction {
        static final long serialVersionUID = -6440495023918097760L;

        public JavaGoToSourceAction() {
            super(142);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null && target.getDocument() instanceof BaseDocument) {
                GoToSupport.goTo((BaseDocument)target.getDocument(), target.getCaretPosition(), true);
            }
        }

        @Override
        public String getPopupMenuText(JTextComponent target) {
            return NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted");
        }

        @Override
        protected Class getShortDescriptionBundleClass() {
            return BaseKit.class;
        }
    }

    @Deprecated
    public static class JavaGoToDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        @Override
        public boolean gotoDeclaration(JTextComponent target) {
            if (!(target.getDocument() instanceof BaseDocument)) {
                return false;
            }
            GoToSupport.goTo((BaseDocument)target.getDocument(), target.getCaretPosition(), false);
            return true;
        }
    }

    public static class CollapseAllCodeBlockFolds
    extends BaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get(target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(JavaElementFoldManager.CODE_BLOCK_FOLD_TYPE);
            types.add(JavaElementFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.collapse(hierarchy, types);
        }
    }

    public static class ExpandAllCodeBlockFolds
    extends BaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get(target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(JavaElementFoldManager.CODE_BLOCK_FOLD_TYPE);
            types.add(JavaElementFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.expand(hierarchy, types);
        }
    }

    public static class CollapseAllJavadocFolds
    extends BaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get(target);
            FoldUtilities.collapse(hierarchy, JavaElementFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class ExpandAllJavadocFolds
    extends BaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get(target);
            FoldUtilities.expand(hierarchy, JavaElementFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class JavaTypedTextInterceptor
    implements TypedTextInterceptor {
        private int caretPosition = -1;

        @Override
        public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
            return false;
        }

        @Override
        public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
            char insertedChar = context.getText().charAt(0);
            switch (insertedChar) {
                case '(': 
                case '[': 
                case '{': {
                    if (!TypingCompletion.isCompletionSettingEnabled()) break;
                    TypingCompletion.completeOpeningBracket(context);
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (!TypingCompletion.isCompletionSettingEnabled()) break;
                    this.caretPosition = TypingCompletion.skipClosingBracket(context);
                    break;
                }
                case ';': {
                    if (!TypingCompletion.isCompletionSettingEnabled()) break;
                    this.caretPosition = TypingCompletion.moveOrSkipSemicolon(context);
                    break;
                }
                case '\"': 
                case '\'': {
                    if (!TypingCompletion.isCompletionSettingEnabled()) break;
                    this.caretPosition = TypingCompletion.completeQuote(context);
                }
            }
        }

        @Override
        public void afterInsert(TypedTextInterceptor.Context context) throws BadLocationException {
            if (this.caretPosition != -1) {
                context.getComponent().setCaretPosition(this.caretPosition);
                this.caretPosition = -1;
            }
        }

        @Override
        public void cancelled(TypedTextInterceptor.Context context) {
        }

        public static class Factory
        implements TypedTextInterceptor.Factory {
            @Override
            public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
                return new JavaTypedTextInterceptor();
            }
        }
    }

    public static class JavaDeletedTextInterceptor
    implements DeletedTextInterceptor {
        @Override
        public boolean beforeRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
            return false;
        }

        @Override
        public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
            char removedChar = context.getText().charAt(0);
            switch (removedChar) {
                case '(': 
                case '[': {
                    if (!TypingCompletion.isCompletionSettingEnabled()) break;
                    TypingCompletion.removeBrackets(context);
                    break;
                }
                case '\"': 
                case '\'': {
                    if (!TypingCompletion.isCompletionSettingEnabled()) break;
                    TypingCompletion.removeCompletedQuote(context);
                }
            }
        }

        @Override
        public void afterRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
        }

        @Override
        public void cancelled(DeletedTextInterceptor.Context context) {
        }

        public static class Factory
        implements DeletedTextInterceptor.Factory {
            @Override
            public DeletedTextInterceptor createDeletedTextInterceptor(MimePath mimePath) {
                return new JavaDeletedTextInterceptor();
            }
        }
    }

    public static class JavaTypedBreakInterceptor
    implements TypedBreakInterceptor {
        private boolean isJavadocTouched = false;

        @Override
        public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
            return false;
        }

        @Override
        public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
            int dotPos = context.getCaretOffset();
            Document doc = context.getDocument();
            if (TypingCompletion.posWithinTextBlock(doc, dotPos)) {
                return;
            }
            if (TypingCompletion.posWithinString(doc, dotPos)) {
                if (CodeStyle.getDefault(doc).wrapAfterBinaryOps()) {
                    context.setText("\" +\n \"", 3, 6, new int[0]);
                } else {
                    context.setText("\"\n + \"", 1, 6, new int[0]);
                }
                return;
            }
            BaseDocument baseDoc = (BaseDocument)context.getDocument();
            if (TypingCompletion.isCompletionSettingEnabled() && TypingCompletion.isAddRightBrace(baseDoc, dotPos)) {
                boolean[] insert = new boolean[]{true};
                int end = TypingCompletion.getRowOrBlockEnd(baseDoc, dotPos, insert);
                if (insert[0]) {
                    doc.insertString(end, "}", null);
                    Indent.get(doc).indentNewLine(end);
                }
                context.getComponent().getCaret().setDot(dotPos);
            } else {
                if (TypingCompletion.blockCommentCompletion(context)) {
                    this.blockCommentComplete(doc, dotPos, context);
                }
                this.isJavadocTouched = TypingCompletion.javadocBlockCompletion(context);
                if (this.isJavadocTouched) {
                    this.blockCommentComplete(doc, dotPos, context);
                }
                TypingCompletion.javadocLineRunCompletion(context);
            }
        }

        @Override
        public void afterInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
            if (this.isJavadocTouched) {
                Lookup.Result<TextAction> res = MimeLookup.getLookup(MimePath.parse("text/x-javadoc")).lookupResult(TextAction.class);
                ActionEvent newevt = new ActionEvent(context.getComponent(), 1001, "fix-javadoc");
                for (TextAction action : res.allInstances()) {
                    action.actionPerformed(newevt);
                }
                this.isJavadocTouched = false;
            }
        }

        @Override
        public void cancelled(TypedBreakInterceptor.Context context) {
        }

        private void blockCommentComplete(Document doc, int dotPos, TypedBreakInterceptor.MutableContext context) throws BadLocationException {
            doc.insertString(dotPos, "*/", null);
            Indent.get(doc).indentNewLine(dotPos);
            context.getComponent().getCaret().setDot(dotPos);
        }

        public static class JavaFactory
        implements TypedBreakInterceptor.Factory {
            @Override
            public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
                return new JavaTypedBreakInterceptor();
            }
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                StringBuffer sb = new StringBuffer("System.out.println(\"");
                String title = (String)doc.getProperty("title");
                if (title != null) {
                    sb.append(title);
                    sb.append(':');
                }
                try {
                    sb.append(Utilities.getLineOffset(doc, target.getCaret().getDot()) + 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                sb.append(' ');
                BaseKit kit = Utilities.getKit(target);
                if (kit == null) {
                    return;
                }
                Action a = kit.getActionByName("insert-content");
                if (a != null) {
                    Utilities.performAction(a, new ActionEvent(target, 1001, sb.toString()), target);
                }
            }
        }
    }

    public static class JavaGenerateGoToPopupAction
    extends NbEditorKit.NbGenerateGoToPopupAction {
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        private void addAcceleretors(Action a, JMenuItem item, JTextComponent target) {
            Keymap km = target.getKeymap();
            if (km != null) {
                KeyStroke ks;
                KeyStroke[] keys = km.getKeyStrokesForAction(a);
                if (keys != null && keys.length > 0) {
                    item.setAccelerator(keys[0]);
                } else if (a != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
                    item.setAccelerator(ks);
                }
            }
        }

        private void addAction(JTextComponent target, JMenu menu, Action a) {
            if (a != null) {
                String actionName = (String)a.getValue("Name");
                JMenuItem item = null;
                if (a instanceof BaseAction) {
                    item = ((BaseAction)a).getPopupMenuItem(target);
                }
                if (item == null) {
                    String itemText = (String)a.getValue("trimmed-text");
                    if (itemText == null) {
                        itemText = this.getItemText(target, actionName, a);
                    }
                    if (itemText != null) {
                        item = new JMenuItem(itemText);
                        Mnemonics.setLocalizedText(item, itemText);
                        item.addActionListener(a);
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(a.isEnabled());
                        Object helpID = a.getValue("helpID");
                        if (helpID instanceof String) {
                            item.putClientProperty("HelpID", helpID);
                        }
                    } else if ("goto-source".equals(actionName)) {
                        item = new JMenuItem(NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted"));
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(false);
                    }
                }
                if (item != null) {
                    menu.add(item);
                }
            }
        }

        protected void addAction(JTextComponent target, JMenu menu, String actionName) {
            BaseKit kit = Utilities.getKit(target);
            if (kit == null) {
                return;
            }
            Action a = kit.getActionByName(actionName);
            if (a != null) {
                this.addAction(target, menu, a);
            } else {
                menu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent target, String actionName, Action a) {
            String itemText = a instanceof BaseAction ? ((BaseAction)a).getPopupMenuText(target) : actionName;
            return itemText;
        }

        @Override
        public JMenuItem getPopupMenuItem(JTextComponent target) {
            String menuText = NbBundle.getBundle(JavaKit.class).getString("generate-goto-popup");
            JMenu jm = new JMenu(menuText);
            this.addAction(target, jm, "goto-source");
            this.addAction(target, jm, "goto-declaration");
            this.addAction(target, jm, "goto-super-implementation");
            this.addAction(target, jm, "goto");
            return jm;
        }
    }
}

