/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.text.MessageFormat;
import org.apache.felix.cm.impl.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Log {
    public static final Log logger = new Log();
    private static final String CM_LOG_LEVEL = "felix.cm.loglevel";
    private static final String LOG_SERVICE_NAME = "org.osgi.service.log.LogService";
    private static final int CM_LOG_LEVEL_DEFAULT = 2;
    private volatile ServiceTracker logTracker;
    private volatile int logLevel = 2;
    private volatile ServiceReference<ConfigurationAdmin> serviceReference;

    public void start(BundleContext bundleContext) {
        this.logTracker = new ServiceTracker(bundleContext, LOG_SERVICE_NAME, null);
        this.logTracker.open();
        String logLevelProp = bundleContext.getProperty(CM_LOG_LEVEL);
        if (logLevelProp == null) {
            this.logLevel = 2;
        } else {
            try {
                this.logLevel = Integer.parseInt(logLevelProp);
            }
            catch (NumberFormatException nfe) {
                this.logLevel = 2;
            }
        }
    }

    public void set(ServiceReference<ConfigurationAdmin> ref) {
        this.serviceReference = ref;
    }

    public void stop() {
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        this.serviceReference = null;
    }

    public boolean isLogEnabled(int level) {
        return level <= this.logLevel;
    }

    public void log(int level, String format, Object[] args) {
        Object log;
        ServiceTracker tracker = this.logTracker;
        Object object = log = tracker == null ? null : tracker.getService();
        if (log != null || this.isLogEnabled(level)) {
            Throwable throwable = null;
            String message = format;
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof ServiceReference)) continue;
                    args[i] = Log.toString((ServiceReference)args[i]);
                }
                if (args[args.length - 1] instanceof Throwable) {
                    throwable = (Throwable)args[args.length - 1];
                }
                message = MessageFormat.format(format, args);
            }
            this.log(level, message, throwable);
        }
    }

    public void log(int level, String message, Throwable t) {
        Object log;
        ServiceTracker tracker = this.logTracker;
        Object object = log = tracker == null ? null : tracker.getService();
        if (log != null) {
            ((LogService)log).log(this.serviceReference, level, message, t);
            return;
        }
        if (this.isLogEnabled(level)) {
            String code;
            switch (level) {
                case 3: {
                    code = "*INFO *";
                    break;
                }
                case 2: {
                    code = "*WARN *";
                    break;
                }
                case 1: {
                    code = "*ERROR*";
                    break;
                }
                default: {
                    code = "*DEBUG*";
                }
            }
            System.err.println(code + " " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    private static String toString(ServiceReference<?> ref) {
        String[] ocs = (String[])ref.getProperty("objectClass");
        StringBuilder buf = new StringBuilder("[");
        for (int i = 0; i < ocs.length; ++i) {
            buf.append(ocs[i]);
            if (i >= ocs.length - 1) continue;
            buf.append(", ");
        }
        buf.append(", id=").append(ref.getProperty("service.id"));
        Bundle provider = ref.getBundle();
        if (provider != null) {
            buf.append(", bundle=").append(provider.getBundleId());
            buf.append('/').append(Activator.getLocation(provider));
        } else {
            buf.append(", unregistered");
        }
        buf.append("]");
        return buf.toString();
    }
}

