/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client.compatible1X;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.StreamMessage;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQCompatibleMessage;

public class ActiveMQStreamCompatibleMessage
extends ActiveMQStreamMessage {
    @Override
    protected SimpleString checkPrefix(SimpleString address) {
        return ActiveMQCompatibleMessage.checkPrefix1X(address);
    }

    @Override
    public void setJMSReplyTo(Destination dest) throws JMSException {
        this.replyTo = ActiveMQCompatibleMessage.setCompatibleReplyTo(dest, this.message);
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        if (this.replyTo == null) {
            this.replyTo = ActiveMQCompatibleMessage.findCompatibleReplyTo(this.message);
        }
        return this.replyTo;
    }

    public ActiveMQStreamCompatibleMessage(ClientSession session) {
        super(session);
    }

    public ActiveMQStreamCompatibleMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public ActiveMQStreamCompatibleMessage(StreamMessage foreign, ClientSession session) throws JMSException {
        super(foreign, session);
    }

    public ActiveMQStreamCompatibleMessage() {
    }
}

