/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.IDRequest;
import org.apache.james.imap.message.response.IdResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.util.ReactorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class IdProcessor
extends AbstractMailboxProcessor<IDRequest>
implements CapabilityImplementingProcessor {
    public static final String MDC_KEY = "bound_MDC";
    private static final Logger LOGGER = LoggerFactory.getLogger(IdProcessor.class);
    private static final ImmutableList<Capability> CAPABILITIES = ImmutableList.of((Object)Capability.of("ID"));
    public static final String USER_AGENT = "userAgent";
    private final Map<String, String> fields = new HashMap<String, String>();

    @Inject
    public IdProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(IDRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.fields.putAll((Map<String, String>)imapConfiguration.getIdFieldsResponse());
    }

    @Override
    protected Mono<Void> processRequestReactive(IDRequest request, ImapSession session, ImapProcessor.Responder responder) {
        responder.respond(new IdResponse(this.fields));
        String mailUserAgent = request.getParameters().map(Object::toString).orElse("NIL");
        if (session.getAttribute(USER_AGENT) == null) {
            this.addMailUserAgentToMDC(session, mailUserAgent);
        }
        session.setAttribute(USER_AGENT, mailUserAgent);
        return this.logMailUserAgent(mailUserAgent).then(this.unsolicitedResponses(session, responder, false)).then(Mono.fromRunnable(() -> this.okComplete(request, responder)));
    }

    private Mono<Void> logMailUserAgent(String mailUserAgent) {
        return ReactorUtils.logAsMono(() -> MDCStructuredLogger.forLogger((Logger)LOGGER).field("parameters", mailUserAgent).log(logger -> logger.info("Received id information")));
    }

    private void addMailUserAgentToMDC(ImapSession session, String mailUserAgent) {
        Object maybeMDC = session.getAttribute(MDC_KEY);
        if (maybeMDC instanceof MDCBuilder) {
            MDCBuilder boundMDC = (MDCBuilder)maybeMDC;
            MDCBuilder newMDC = boundMDC.addToContext("mailUserAgent", mailUserAgent);
            session.setAttribute(MDC_KEY, newMDC);
        }
    }

    @Override
    protected MDCBuilder mdc(IDRequest message) {
        return MDCBuilder.create().addToContext("action", "ID");
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }
}

