/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import com.github.fge.lambdas.Throwing;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.MailboxName;
import org.apache.james.imap.message.response.ACLResponse;
import org.apache.james.mailbox.model.MailboxACL;

public class ACLResponseEncoder
implements ImapResponseEncoder<ACLResponse> {
    @Override
    public void encode(ACLResponse aclResponse, ImapResponseComposer composer) throws IOException {
        Map entries = aclResponse.getAcl().getEntries();
        composer.untagged();
        composer.message("ACL");
        Optional.ofNullable(aclResponse.getMailboxName()).ifPresent((Consumer<MailboxName>)Throwing.consumer(value -> composer.mailbox(value.asString())));
        if (entries != null) {
            for (Map.Entry entry : entries.entrySet()) {
                String identifier = ((MailboxACL.EntryKey)entry.getKey()).serialize();
                composer.quote(identifier);
                Optional.ofNullable((MailboxACL.Rfc4314Rights)entry.getValue()).ifPresent((Consumer<MailboxACL.Rfc4314Rights>)Throwing.consumer(value -> composer.quote(value.serialize())));
            }
        }
        composer.end();
    }

    @Override
    public Class<ACLResponse> acceptableMessages() {
        return ACLResponse.class;
    }
}

